/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#ifndef PEMDEF_HEADER
#define PEMDEF_HEADER

/*  This file contains definitions needed for interaction with TIS/PEM */

/* 
 * Default sendproc script used; init.c looks for user's sendproc entry, if any
 * in .mh_profile.
 */
#define DEFAULT_SENDPROC "pemsend.sh"

/* program to check if you are logged into pem */
#define PEM_LOG_CHECK "pemlogcheck alias sig-user 1>/dev/null 2>&1"

/* used to flag a composition window as having a PEM enhanced message */
#define PEM_ENHANCED_MSG  1

#define QUIT  1
#define OK    0

#define PEM_NOT_SUPPORTED  "PEM: You must use the #privacy directive on first line to sign and encrypt."
#define PEM_NOT_SUPPORTED2 "PEM: You must use the #encrypt directive on first line to encrypt."

#define PEM_LOG_NOTICE "You can not perform this PEM option because you are not logged into PEM.\nYou must run pemlogin first."


typedef enum pem_op { PEM_UNKNOWN_OP, PEM_NOSEND, PEM_SIGN,PEM_ENCRYPT,PEM_SIGN_ENCRYPT } Pem_Op;

typedef struct MsgAndDiag {
    Msg         msg;
    Widget      dialog;
} MsgAndDiagRec, *MsgAndDiag;



#endif
