; --------------------------------------------------------------------------
; NOISE.SYS v0.53+ API Routines and Data

; --------------------------------------------------------------------------
IOCTL_Read      PROC    NEAR                    ; Updated IOCTL
                mov     si, OFFSET ControlOut
		mov	cx, es:[di].ReqHdr.Siz	; Bytes	to read
                cmp     cx, szControlOut
                jna     SHORT @@irSizeOk
                mov     cx, szControlOut        ; Don't read more than that!
@@irSizeOk:
                mov     es:[di].ReqHdr.Siz, cx
                les     di, es:[di].ReqHdr.Addr ; Address to read to
                cld
                rep     movsb
                jmp     rdevok
IOCTL_Read      ENDP


; --------------------------------------------------------------------------
IdTag           equ     "noiz"

ControlOut      LABEL   BYTE
                DW      szControlOut    ; Size of the output record
ReturnTag       DD      IdTag           ; Id tag
                DW      NoiseVersion    ; Version
HookAPI         DB      DefaultInt      ; Int used by API
HookFunc        DB      'n'             ; AH = HookFunc
FarCallAddr     DW      Offset FarCallHook
                DW      0
Flags   LABEL WORD                      ; Flags
        DW  DEFAULTFLAGS                ; NoHashFlag = 0 if hashing enabled
        DW  0                           ; (reserved)
Counter         DD      0               ; Counter used for estimating entropy
Quality         DW     QualityThreshold ; Output threshold
Outqueue        DW      0               ; Bytes waiting in outpool[]
FreshCount      DW      0               ; total fresh bits in pool
UsageFlag       DB      0               ; Multi-tasking friendliness                
szControlOut    equ     $-ControlOut

@ReturnJump     LABEL   DWORD
                DD      ?
                ibm_isp NoiseHook
@NoiseHookEntry LABEL   NEAR
                cmp     ah, cs:[HookFunc]  ; are we being called?
                je      SHORT @HelloSailor ; if yes, groovy
                jmp     DWORD PTR cs:[NoiseHook+2] ; otherwise continue
FarCallHook     LABEL   FAR                ; hook for far calls
                pushf
                jmp     SHORT @NoiseHookEntry
@ReturnOk:      dec     BYTE PTR [UsageFlag]
                clc                        ; CF=0 (Ok)
                pop     bp si ds
                jmp     DWORD PTR cs:[@ReturnJump]
@AlreadyUsed:   mov     al, apiUseErr      ; API already in use
@ReturnErr:     dec     BYTE PTR [UsageFlag]
                stc                        ; CF=1 (Error)
                pop     si ds
                jmp     DWORD PTR cs:[@ReturnJump]
@HelloSailor:   pop     DWORD PTR cs:[@ReturnJump]
                popf
                push    ds si bp cs
                pop     ds
                inc     BYTE PTR [UsageFlag]
                cmp     al, NumFunctions
                jb      SHORT @FuncOk
@Invalid:       mov     al, apiInvalid     ; Bad function number
                jmp     SHORT @ReturnErr
@FuncOk:        mov     ah, 0
                add     ax, ax
                mov     si, ax
                jmp     @FuncTbl[si]
@FuncTbl        LABEL   WORD
                DW      @AMIS00       ; Installation Check (AL=0)
                DW      @AMIS01       ; Get Entryy Point (AL=1)
                DW      @AMISUnimplem ;
                DW      @AMISUnimplem ;
                DW      @AMIS04       ; Get Interrupt Hook List (AL=4)
                DW      @AMISUnimplem ;
                DW      @AMIS06       ; Reserved for future use
                DW      @Invalid      ;
                DW      @Invalid      ;
                DW      @Invalid      ;
                DW      @Invalid      ;
                DW      @Invalid      ;
                DW      @Invalid      ;
                DW      @Invalid      ;
                DW      @Invalid      ;
                DW      @Invalid      ;
                DW      @InstallCheck ; AL = 10h
                DW      @GetEstimate  ; AL = 11h
                DW      @SampleTimer, @AddSample
                DW      @GetFlags, @SetFlags
                DW      @ReadPRNG, @ReadRAND
NumFunctions    equ     ($ - @FuncTbl)/2

@AMIS00         LABEL   NEAR            ; Installation Check (AL=0)
                mov     al, apiOk
                mov     cx, NoiseVersion
                mov     dx, cs
                mov     di, OFFSET SignatureString
                jmp     SHORT @ReturnOk
SignatureString LABEL   BYTE
                DB      "WlkngOwl", "NoiseSYS", 0
@AMIS01         LABEL   NEAR            ; Get Entry Point (AL=1)
                mov     al, apiOk
                mov     dx, cs
                mov     bx, OFFSET FarCallHook ; or should this be DI reg?
                jmp     @ReturnOk
@HookList       LABEL   BYTE
        REPT 12 ; (!) Install_Int() routine does not check boundaries here!
                DB      DefaultInt
                DW      OFFSET NoiseHook
        ENDM
@AMIS04         LABEL   NEAR
                mov     al, 04h
                mov     dx, cs
                mov     bx, OFFSET @HookList
                jmp     @ReturnOk
@AMIS06         LABEL   NEAR    ; AMIS v3.5.9 proposed spec
                mov     dx, cs
                mov     bx, OFFSET rheader
  if __ALIASRAND
                mov     ax, 3
  else
                mov     ax, 2
  endif
                jmp     @ReturnOk
@AMISUnimplem   LABEL   NEAR
                mov     al, apiInvalid
                jmp     @ReturnErr
; --------------------------------------------------------------------------
@InstallCheck   LABEL   NEAR            ; Get Driver Status (AL=10h)
                mov     bh, [UsageFlag] ;          BH  = Usage Count
                mov     bl, (NumFunctions-1) ;     BL  = Highest function
  ife POOLSIZE
                mov     dx, 64          ;          DX  = Max bytes waiting
  else
                mov     dx, POOLSIZE*4
  endif
@GetWaiting     LABEL   NEAR            ;          CX  = No. bytes waiting
  ife POOLSIZE
                mov     cx, [FreshCount]
                shr     cx, 3+FRACBITS
  else
                mov     cx, [OutQueue]
  endif
                mov     ax, (__CPU shl 8)+apiOk ;  AH  = Build CPU, AL = Ok
                jmp     @ReturnOk
@GetEstimate    LABEL   NEAR            ; Get Estimated Entropy  (AH=11h)
                movzx   ebx, WORD PTR [OutQueue]
                shl     ebx, 3+FRACBITS
                mov     al, apiOk
  ife __FULLHASH
                movzx   edx, [FreshCount]
                add     ebx, edx        ;          EBX = Estimated bit count
  endif
                mov     cl, FRACBITS    ;          CL  = FRACBITS
                mov     edx, [Counter]  ;          EDX = No. of samples
                jmp     @ReturnOk
  if __AllowAddAPI
@SampleTimer    LABEL   NEAR            ; Sample timer (AL=12h)
                call    Sample
                jmp     SHORT @GetWaiting
@AddSample      LABEL   NEAR            ; Add sample (AL=13h, DX=sample)
                mov     ax, dx
                call    TrackDeltas
                jmp     SHORT @GetWaiting
  else
@SampleTimer    LABEL   NEAR            ; Sample timer (AL=12h)
@AddSample      LABEL   NEAR            ; Add sample (AL=13h)
  endif
@Disabled       LABEL   NEAR
                mov     al, apiDisabled
                jmp     @ReturnErr
@GetFlags       LABEL   NEAR            ; Get flags (AL=14h)
                mov     al, apiOk
                mov     bx, [Flags]     ; BX = flags
                mov     cx, SettableFlagsMask
                jmp     @ReturnOk
@SetFlags       LABEL   NEAR            ; Set flags (AL=15h)
                and     bx, SettableFlagsMask
                and     [Flags], not SettableFlagsMask
                or      [Flags], bx
                jmp     SHORT @GetFlags
@ReadPRNG       LABEL   NEAR            ; Read URANDOM bytes (AL=16h)
                push    cx
                cld
                mov     bx, [BytesAvail] ; CX=Length, ES:[DI]->buffer
                call    Read
                mov     al, apiOk
                pop     cx
                jmp     @ReturnOk
@ReadRAND       LABEL   NEAR            ; Read RANDOM bytes
                mov     al, apiUseErr
                cmp     [UsageFlag], 1
                ja      SHORT @rrReadNothing
  if POOLSIZE                           ; Read bytes from output pool
                mov     ax, [OutQueue]  ; check if pool has any bytes
                test    ax, ax
                jnz     SHORT @rrAboveThresh0
                mov     al, apiEmpty
@rrReadNothing:
                xor     cx, cx
                jmp     @ReturnErr
@rrAboveThresh0:
  else                                  ; Read bytes from hash
                mov     ax, [FreshCount] ; check if pool has entropy
                cmp     ax, [EntropyThreshold]
                ja      SHORT @rrAboveThresh1
                mov     al, apiUseErr
@rrReadNothing:
                xor     cx, cx
                jmp     @ReturnErr
@rrAboveThresh1:
                shr     ax, 3+FRACBITS         ; bytes requested > entropy?
  endif
                cmp     cx, ax
                jna     SHORT @rrEnough
                mov     cx, ax
@rrEnough:
  if POOLSIZE
                sub     [OutQueue], cx
                mov     bx, [OutIndex]
                add     bx, 3
                and     bx, (POOLSIZE*4)-1
                push    cx
                cld
@rrPoolCopyLoop:
                mov     al, bl
                xchg    al, BYTE PTR OutPool[bx]
                dec     bx
@rrr00:         and     bx, (POOLSIZE*4)-1
                stosb
                loop    @rrPoolCopyLoop
                pop     cx
                mov     [OutIndex], bx
  else
                jmp     SHORT @ReadPRNG
  endif
                mov     al, apiOk
                jmp     @ReturnOk

; --------------------------------------------------------------------------
; A hook for Interrupt 15h (for future development)

 if __Sample15
                ibm_isp _Multitask
  if __SamplDrift
                cmp     ah, 83h
                je      @mt15VoidTimer
                cmp     ah, 86h
                je      @mt15VoidTimer
                jmp     SHORT @mt15Exit
@mt15VoidTimer  LABEL   NEAR
                test    BYTE PTR @SpinFlag, 81h
                jnz     SHORT @mt15Exit
                pop     ebx
                popf
                push    ebx
                stc
                retf
  endif
@mt15Exit       LABEL   NEAR
                jmp     DWORD PTR cs:[_Multitask+2]
 endif

; --------------------------------------------------------------------------
; Hook for Interrupt 2Fh (Multiplex Services)


                ibm_isp _MultiplexServ
; Normally we'd call the original handler first, but in this case it
; interferes with values passed to and from orig. handler, so we check
; values passed first then jump.
                pushf

; <---- Add sampling of network (and CD-ROM?) calls to function 11h?

  if __samplcdrom
; Note: This does not work with SONY ATAPI_CD.SYS driver.
;       (Since I am using a SONY CD-ROM, I am unable to test this code)

                cmp     ah, 15h                 ; CD-ROM access (15h)?
                jne     SHORT @NoCD
                pushad                          ; save registers
                push    ds cs                   ; set ds = cs
                pop     ds
                call    Sample
                pop     ds                      ; restore regs
                popad
                jmp     SHORT @QuitMServ
@NoCD           LABEL   NEAR
  endif
                cmp     ah, 16h                 ; Win broadcasts?
                jne     SHORT @QuitMServ

@ToggleWinFLag  LABEL   NEAR
                cmp     al, 8                   ; Check for init/close msgs
                jb      SHORT @QuitMServ
                cmp     al, 9
                ja      SHORT @QuitMServ
                pushad
                push    ds
                xor     BYTE PTR [Flags], WindowsFlag ; toggle flag
                jz      SHORT @NotInWin
@NotInWin       LABEL   NEAR
  if __SamplDrift
                mov     @SpinFlag, 80h
  endif
                call    Sample ; Sample enter/exit times for Windows...
                pop     ds
                popad
@QuitMServ      LABEL   NEAR
                popf
                jmp     DWORD PTR cs:[_MultiplexServ+2]

; --------------------------------------------------------------------------
; A hook for Interrupt 21h (DOS)

  if __samplexec
;@LastExec       LABEL   WORD
;                DW      ?
  endif
  if __DosSpinner
@DosSpinner     LABEL   WORD
                DW      0
@LastDosSpin    LABEL   WORD
                DW      0
  endif
                ibm_isp _NewInt21
  if __DosSpinner
                inc     WORD PTR cs:@DosSpinner
  ; ----- Count the number of calls to DOS between every clock tick
  endif
  if __samplexec
                cmp     ah, 0             ; Old form of exit (still used)
                je      SHORT @SampleExec
                cmp     ah, 4Bh           ; Exec/Load overlay
                je      SHORT @SampleExec
                cmp     ah, 4Ch           ; Terminate process
                je      SHORT @SampleExec
  @OrigDOS:
                jmp     DWORD PTR cs:[_NewInt21+2]
  @SampleExec   LABEL   NEAR
;; What this needs to do is set the InDOS flag?
;                pushf
;                cli
                pushad
                push    ds
                call    Sample
                pop     ds
                popad
  endif
;                popf
                jmp     DWORD PTR cs:[_NewInt21+2]

