/* stirfile.c */



#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>

#include "usuals.h"
#include "randpool.h"

#define BUFFER_SIZE (RANDPOOLBITS/8)
#if defined(__MSDOS__)
#       define assumedRNG_DEVICE "/dev/random$"  
#else
#       define assumedRNG_DEVICE "/dev/random"  
#endif

void main(int argc, char *argv[])
{
  FILE *randstream, *file;
  unsigned int i,bytesread, byteswrit;
  static char buff[BUFFER_SIZE], *ofname, *devrandname;
  clock_t cnow;
  time_t tnow;

  if (argc<2) {
    fprintf(stderr, "usage: stirfile file\n"
      );
    exit(EXIT_FAILURE);
  } else ofname=argv[1];
  devrandname=getenv("RNG_DEVICE");
  if (strcmp(devrandname,"")!=0) devrandname=assumedRNG_DEVICE;
  cnow = clock();
  randPoolAddBytes((byte const *)&cnow, sizeof(cnow));
  tnow = time((time_t *)0);               /* Read slowest clock last */
  randPoolAddBytes((byte const *)&tnow, sizeof(tnow));

  if ((randstream=fopen(devrandname, "rb"))<=0) {
      fprintf(stderr, "error opening %s\n", devrandname);
      exit(EXIT_FAILURE);
  } else if ((file= fopen(ofname, "rb") )<0) {
      fprintf(stderr, "unable to open file %s\n", ofname);
      fclose(randstream);
      exit(EXIT_FAILURE);
  } else {

    bytesread = fread(&buff, 1, BUFFER_SIZE, file);
    if (bytesread) randPoolAddBytes((byte const *)&buff, bytesread);
    else {
      fprintf(stderr, "unable to read from %s\n", ofname);
      exit(EXIT_FAILURE);
    }
    fclose(file);
    randPoolStir();

    bytesread = fread(&buff, 1, BUFFER_SIZE, randstream);
    if (bytesread) randPoolAddBytes((byte const *)&buff, bytesread);
    else {
      fprintf(stderr, "unable to read from rng device\n");
      exit(EXIT_FAILURE);
    }
    randPoolStir();

    randPoolGetBytes(buff, BUFFER_SIZE);
    if ((file=fopen(ofname, "wb"))<0) {
      fprintf(stderr, "unable to open file %s\n", ofname);
      exit(EXIT_FAILURE);
    } else {
      byteswrit=fwrite(&buff, 1, BUFFER_SIZE, file);
      if (!byteswrit) {
        fprintf(stderr, "error writing to file\n");
        exit(EXIT_FAILURE);
      }
      fclose(file);
    }
    memset(&buff, 0, BUFFER_SIZE);
    randPoolStir();
    fclose(randstream);
    exit(EXIT_SUCCESS);
  }
}

