
/* XXX No way of discriminating between different callback objects */

int PySSLeay_verify_callback(ok, xs, xi, depth, error)
     int ok;
     X509 *xs;
     X509 *xi;
     int depth;
     int error;
{
  PyObject *value, *result;
  X509Object *Py_xs, *Py_xi;
  int res;
  
#ifdef DEBUG
  printf("Callback %p %p\n", xs, xi);
#endif  

  if (verify_callback_obj==Py_None)
    {	
#ifdef DEBUG
      printf(" Using fallback callback\n");
#endif
      return (1);  /* XXX fallback callback :) */
    }

  Py_xs=X509_New();
  Py_xi=X509_New();
  if (Py_xs==NULL || Py_xi==NULL)
    {
      Py_XDECREF(Py_xs);
      Py_XDECREF(Py_xi);
      return 0;
    }
  Py_xs->x509=xs; Py_xi->x509=xi;
#ifdef DEBUG
  printf(" Constructing argument tuple\n");
#endif
  value=Py_BuildValue("(iOOii)", ok, Py_xs, Py_xi, depth, error);
#ifdef DEBUG
  printf(" Calling Python callback code\n");
#endif
  result=PyEval_CallObject(verify_callback_obj, value);
  if (result==NULL) return(0);
  if (!PyArg_Parse(result, "i", &res)) return 0;
#ifdef DEBUG
  printf(" X.509 callback: DECREF'ing and returning %i %p\n", res, result);
#endif  
  /*  Py_XDECREF(result);*/
  Py_XDECREF(value);
  /* We don't want to call X509_free on the X509 objects we're given, but we
     still have to destroy the Python objects, so the pointers must be NULL.  */ 
  Py_xs->x509=NULL;  Py_XDECREF(Py_xs);
  Py_xi->x509=NULL;  Py_XDECREF(Py_xi);
  
  return res;
}

int master_getkey_callback(buf,num,verify)
char *buf;
int num;
int verify;
{
 PyObject *value=Py_BuildValue("i", verify), *result;
 char *pybuf;
 int pylen;
 
 result=PyEval_CallObject(verify_callback_obj, value);
 if (result!=NULL)  return 0;
 if (!PyArg_Parse(result, "s#", &pybuf, &pylen)) return 0;
 memcpy(buf, pybuf, pylen);
 return pylen;
}

static PyObject *
SSLeay_newSSLctx_(PyObject *self,PyObject *args)
{
  SSLCTXObject *v;
  if (!PyArg_ParseTuple(args, "")) return NULL;
  v=SSLCTX_New();
  if (v!=NULL) 
	v->SSLctx=SSL_CTX_new();
  return (PyObject *)v;
}


#ifndef NO_DUP

/* Create a SSLeay object from a numeric file description.
   Useful e.g. if stdin is a SSLeay.
   Additional arguments as for SSLeay(). */

static PyObject *
SSLeay_fromfd_(PyObject *self, PyObject *args)
{
  SSLconnObject *s;
  SSLCTXObject *sslctx=NULL;
  int fd, certlen=0, RSAlen=0;
  X509 *cert=NULL;
  RSA *RSAkey=NULL;
  
  if (!PyArg_ParseTuple(args, "i|O!s#s#", &fd, &SSLCTXType, &sslctx,  
			&cert, &certlen,
			&RSAkey, &RSAlen))
    {
      return NULL;
    }
  /* Dup the fd so it and the SSLeay can be closed independently */
  fd = dup(fd);
  if (fd < 0)
    return PySSLeay_Err();
  s = SSLconn_New();
  if (sslctx!=NULL) 
     {
       s->SSL=SSL_new(sslctx->SSLctx);
     }
  else
     {
       SSL_CTX *ctx=SSL_CTX_new();
       s->SSL=SSL_new(ctx);
       SSL_CTX_free(ctx);
     }
  SSL_set_fd(s->SSL, fd);
  SSL_set_verify(s->SSL,SSL_VERIFY_NONE,PySSLeay_verify_callback);
  
  return (PyObject *) s;
}
#endif /* NO_DUP */

static PyObject *
SSLeay_SSL_(PyObject *self, PyObject *args)
{
 return SSLeay_fromfd_(self, args);
}

static PyObject *
SSLeay_set_verify_callback_(PyObject *s, PyObject *args)
{
  PyObject *callback;
  if (!PyArg_ParseTuple(args, "O!", &PyFunction_Type, &callback))
    {
      return NULL;
    }
  Py_XINCREF(callback);
  Py_XDECREF(verify_callback_obj);
  verify_callback_obj=callback;
  Py_INCREF(Py_None);
  return(Py_None);
}

static PyObject *
SSLeay_set_getkey_callback_(PyObject *s, PyObject *args)
{
 PyObject *callback;

 if (!PyArg_ParseTuple(args, "O!", &PyFunction_Type, &callback))
   {
    return NULL;
   } 
 Py_XDECREF(getkey_callback_obj);
 Py_XINCREF(callback);
 getkey_callback_obj=callback;
 /*PEM_set_getkey_callback(master_getkey_callback);*/
 Py_XINCREF(Py_None);
 return (Py_None);
}




