/* A program to proxy SSL for Lynx using SSLeay */
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <arpa/nameser.h>
#include <resolv.h>
#include <netdb.h>
#include "ssl.h"
#include "err.h"

#define XBUFSIZ 16384
static char         xferbuf[XBUFSIZ];
char                goodcerts[128] = "goodcerts";
char                dns[256] = "";
int                 debugflag = 0;

#if 1
#include "shellmat.c"
#else
#define shellexp(x,y) (!strcmp(x,y));
#endif

int certverify(int ok, X509 * subc, X509 * issc, int dep, int err)
{
  char               *cp;
  char                cbuf[255];
  char                cert1line[256];
  FILE               *tmpfd;
  int                 n;

  cp = X509_NAME_oneline(X509_get_subject_name(subc));
  strncpy(cert1line, cp, 255);
  free(cp);
  if (dep == 0) {
    cbuf[0] = 0;	/* goodcert file format is oneline-space-hostname */
    n = strlen(cert1line);
    tmpfd = fopen(goodcerts, "r");
    if (tmpfd != NULL) {
      while (!feof(tmpfd)) {
	fgets(cbuf, 255, tmpfd);
	if (!strncasecmp(cert1line, cbuf, n)
	 && !strncasecmp(dns, &cbuf[n + 1], strlen(dns)))
	  break;
      }
      fclose(tmpfd);
    }
    if (!strncasecmp(cert1line, cbuf, n)
     && !strncasecmp(dns, &cbuf[n + 1], strlen(dns)))
      ok = 1;
    else if (ok) {
      cp = strstr(cert1line, "/CN=");	/* move to common name */
      if (cp != NULL) {
	strcpy(cbuf, &cp[4]);
	if ((cp = strchr(cbuf, '/')))
	  *cp = '\0';
	ok = shellexp(dns, cbuf);
      }
      if (!ok)
	fprintf(stderr, "ERROR: Hostname [%s] != cert [%s]\n", dns, cbuf);
    }
  }
  if (!debugflag && ok == 1 && err < 2)
    return (ok);
  fprintf(stderr, "SSL CERT: ok:%d dep:%d err:%s\n",
	  ok, dep, X509_cert_verify_error_string(err));
  if (issc) {
    cp = X509_NAME_oneline(X509_get_issuer_name(issc));
    fprintf(stderr, "Issuer:\n%s\n", cp);
    free(cp);
  }
  fprintf(stderr, "Subject:\n%s %s\n", cert1line, dns);
  strcpy(cbuf, subc->cert_info->validity->notBefore);
  fprintf(stderr, "Valid From: %2.2s/%2.2s/%2.2s %2.2s:%2.2s:%2.2s %s\n",
	&cbuf[2], &cbuf[4], cbuf, &cbuf[6], &cbuf[8], &cbuf[10], &cbuf[12]);
  strcpy(cbuf, subc->cert_info->validity->notAfter);
  fprintf(stderr, "     Until: %2.2s/%2.2s/%2.2s %2.2s:%2.2s:%2.2s %s\n",
	&cbuf[2], &cbuf[4], cbuf, &cbuf[6], &cbuf[8], &cbuf[10], &cbuf[12]);
  fprintf(stderr, "\n");
  return (ok);
}

int                 main(int argc, char *argv[])
{
  SSL_CTX            *ssl_ctx = NULL;
  SSL                *ssl_conn = NULL;
  char                mycert[128] = "mycert.pem";
  int                 n, m;
  int                 lstn, acpt = -1, rnet = -1;
  int                 snewsflag;
  fd_set              fds;
  struct sockaddr_in  sin, rsin;
  struct hostent     *host;
  FILE               *tmpfd;
  char                tmpbuf[256];
  char                tmpbuf2[512];
  char               *cp, *pp = NULL;
  int                 localport = 5010;

  debugflag = 0;
  tmpfd = fopen(argc > 1 ? argv[1] : "eassl.conf", "r");
  if (tmpfd != NULL) {
    while (!feof(tmpfd)) {
      if (fgets(xferbuf, 255, tmpfd) == NULL)
	break;
      n = sscanf(xferbuf, "%63s %127s", tmpbuf2, tmpbuf);
      if (!strcmp(tmpbuf2, "debug"))
	debugflag = 1;
      else if (!strcmp(tmpbuf2, "mycert"))
	strncpy(mycert, tmpbuf, 128);
      else if (!strcmp(tmpbuf2, "goodcerts"))
	strncpy(goodcerts, tmpbuf, 128);
      else if (!strcmp(tmpbuf2, "localport"))
	localport = atoi(tmpbuf);
    }
    fclose(tmpfd);
  }
  memset((char *) &sin, 0, sizeof(sin));
  sin.sin_family = AF_INET;
  rsin = sin;
  sin.sin_port = htons(localport);
  sin.sin_addr.s_addr = inet_addr("127.0.0.1"); /* change to 0.0.0.0 for all */
  if ((lstn = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    return lstn;
  n = -1;
  if ((n = setsockopt(lstn, SOL_SOCKET, SO_REUSEADDR, &n, sizeof(int))) < 0)
    return n;
  if ((n = bind(lstn, (struct sockaddr *) & sin, sizeof(sin))) < 0)
    return n;
  ssl_ctx = SSL_CTX_new();
  X509_set_default_verify_paths(ssl_ctx->cert);
  SSL_load_error_strings();
  if ((m = listen(lstn, 3)) < 0)
    return m;
  for (;;) {
    close(acpt);
    close(rnet);
    FD_ZERO(&fds);
    FD_SET(lstn, &fds);
    if ((n = select(lstn + 1, &fds, NULL, NULL, NULL)) < 0)
      break;
    n = sizeof(sin);
    acpt = accept(lstn, (struct sockaddr *) & sin, &n);
    if (debugflag)
      fprintf(stderr, "From %s:%u (%d)\n",
       inet_ntoa(sin.sin_addr), htons(sin.sin_port), acpt);
    m = 0;
    do {	/* get entire http header */
      if ((n = read(acpt, &xferbuf[m], XBUFSIZ - m)) < 0)
	break;
      m += n;
      xferbuf[m] = 0;
    } while (!strstr(xferbuf, "\r\n\r\n"));
    if (n < 0)
      continue;
    if (!(cp = strchr(xferbuf, ' ')))	/* point at url */
      continue;
    if (!strncasecmp(++cp, "https://", 8))
      rsin.sin_port = htons(443),
	snewsflag = 0;
    else if (!strncasecmp(cp, "snews://", 8))
      rsin.sin_port = htons(563),
	snewsflag = 1;
    else
      continue;
    cp += 8;
    if ((pp = strchr(cp, '/')) || (pp = strchr(cp, ' '))
     || (pp = strchr(cp, '\r')))
      *pp++ = 0;	/* isolate hostname */
    strncpy(dns, cp, 128);
    cp = dns;
    if ((cp = strchr(cp, ':')))
      *cp++ = 0,
	rsin.sin_port = htons(atoi(cp));
    if (debugflag)
      fprintf(stderr, "Secure proxy to %s:%d\n", dns, htons(rsin.sin_port));
    n = inet_addr(dns);
    if (n != -1)
      memcpy(&rsin.sin_addr, &n, sizeof(n));
    else if ((host = gethostbyname(dns)) != NULL)
      memcpy(&rsin.sin_addr, host->h_addr, host->h_length);
    else
      continue;
    if ((rnet = socket(AF_INET, SOCK_STREAM, 0)) < 0)
      continue;
    n = connect(rnet, (struct sockaddr *) & (rsin), sizeof(sin));
    if (debugflag)
      fprintf(stderr, "(to) %s:%u (%d)\n",
       inet_ntoa(rsin.sin_addr), htons(rsin.sin_port), n);
    if (n < 0)
      continue;
    ssl_conn = SSL_new(ssl_ctx);
    SSL_use_certificate_file(ssl_conn, mycert, SSL_FILETYPE_PEM);
    SSL_use_RSAPrivateKey_file(ssl_conn, mycert, SSL_FILETYPE_PEM);
    SSL_set_fd(ssl_conn, rnet);
    SSL_set_verify(ssl_conn, SSL_VERIFY_PEER, certverify);
    if ((n = SSL_connect(ssl_conn)) < 0) {
      fprintf(stderr, "SSL connection error: %d %s\n",
	      n, ERR_error_string(ERR_get_error(), tmpbuf));
      continue;
    }
    if (debugflag)
      fprintf(stderr, "Using cipher %s to server\n", SSL_get_cipher(ssl_conn));
    if (!snewsflag) {	/* for lynx proxy https, forward edited header */
      cp = strstr(xferbuf, "https://");
      *cp++ = '/';
      strcpy(cp, pp);	/* delete https://x.y.z:p/ */
      SSL_write(ssl_conn, xferbuf, strlen(xferbuf));
    }
    for (;;) {
      FD_ZERO(&fds);
      FD_SET(rnet, &fds);
      FD_SET(acpt, &fds);
      n = select(1 + (rnet > acpt ? rnet : acpt), &fds, NULL, NULL, NULL);
      if (n <= 0)
	break;
      if (FD_ISSET(rnet, &fds)) {
	if ((n = SSL_read(ssl_conn, xferbuf, XBUFSIZ)) <= 0)
	  break;
	if ((n = write(acpt, xferbuf, n)) <= 0)
	  break;
      }
      if (FD_ISSET(acpt, &fds)) {
	if ((n = read(acpt, xferbuf, XBUFSIZ)) <= 0)
	  break;
	if ((n = SSL_write(ssl_conn, xferbuf, n)) <= 0)
	  break;
      }
    }
    SSL_free(ssl_conn);
  }
  return (0);
}
