#ifndef EC_INCL_EPOCKTID_H
#define EC_INCL_EPOCKTID_H
/* beginning of epocktid.h */


	/* ecashlib public headers */
#include "epocktid.fh"

#include "eaccid.fh"
#include "eerrno.fh"

#include "eecdef.h"


	/* debug info headers */

#ifdef DC_DEBUG_INFO
#include "epocktid.ih"
#endif




	/* EC_PocketID functions */

/*
 * Create a new EC_PocketID.
 *
 * parameters:
 *	accID_ptr: the EC_AccountID
 *      base_dir_str: a string pointing to the base directory
 *
 * return values:
 *      pointer to the new EC_PocketID on success, NULL pointer on failure
 */
EC_EXPORT EC_PocketID *EC_pocketID_new(const EC_AccountID *accID_lnk, 
	const char *base_dir_str);


/*
 * Free an EC_PocketID.
 *
 * return values:
 *	standard EC_Errno
 */
EC_EXPORT EC_Errno EC_pocketID_free(EC_PocketID *this_pocketID_ptr);


/*
 * Duplicate an EC_PocketID.
 *
 * return values:
 *      pointer to the new EC_PocketID on success, NULL pointer on failure
 */
EC_EXPORT EC_PocketID *EC_pocketID_dup(const EC_PocketID *this_pocketID_lnk);


/*
 * Get the contents of an EC_PocketID.
 */
EC_EXPORT EC_AccountID *EC_pocketID_get_accID(
	const EC_PocketID *this_pocketID_lnk);

EC_EXPORT char *EC_pocketID_get_base_dir(const EC_PocketID *this_pocketID_lnk);



/* end of epocktid.h */
#endif

