/* t_tcp.h */

#ifndef EC_INCL_TEST_TCP_H
#define EC_INCL_TEST_TCP_H


#include "eecdef.h"


/*
 * In order to make an Ecash(tm) application you need to write
 * some code that does network connectivity.  The t_tcp module
 * is an example, using TCP/IP as its network.  It consists of
 * functions to receive and send EC_Msg's over TCP/IP and 
 * functions to encode IP hostnames into EC_Addresses.
 *
 * It uses DigiCash's in-house portable TCP/IP library, but it 
 * does _not_ use any knowledge of the contents of EC_Msg's.  
 * Read the source code for test_tcp_recv_msg() and
 * test_tcp_send_msg() and you will see that this is just a 
 * generic TCP/IP library integrated with the public Ecash API.
 *
 * If you wanted to do Ecash(tm) via e-mail or some other
 * network substrate, you would write similar functions to 
 * handle the networking and addressing for that particular
 * substrate.
 */

/*
 * In order to use swap_order, define the "LITTLE_ENDIAN" flag or 
 * not as appropriate your platform.
 */
UInt32 swap_order(UInt32 num);


	/* tcp lib includes */
#include "onl_tcp.h"


	/* high level API includes */
#include "emsg.h"



int test_tcp_recv_msg(EC_Msg **msg_ptr_out, struct tcp_conn *conn);
int test_tcp_send_msg(const EC_Msg *msg_lnk, struct tcp_conn *conn);



Char *test_tcp_addr_to_hostname(const EC_Address *addr_lnk);
UInt32 test_tcp_addr_to_portnum(const EC_Address *addr_lnk);

EC_Address *test_hostname_to_addr(const Char *hostname, UInt32 port);

int test_tcp_addr_cmp(const EC_Address *addr_1_lnk, 
	const EC_Address *addr_2_lnk);


#endif

