#include "client.h"

/* Check the balance of an account */
int lucre_balance(EC_W_Wallet wallet)
{
    EC_M_Status		status = NULL;
    int			ret = -1;
    char		amtbuf[80];

    /* Get the status */
    status = EC_W_status_read(wallet);
    CHECK(status_read, !status);

    printf("Account balance for %s:\n", wallet->userrec->username);
    if (wallet->userrec->userID != 0) {
	EC_U_curramt2str(wallet->userrec->currency, status->balance,
	    amtbuf, sizeof(amtbuf));
	printf("At the bank: %12s\n", amtbuf);
    } else {
	printf("This wallet is not linked to a bank account.\n");
    }
    EC_U_curramt2str(wallet->userrec->currency, status->cash,
	amtbuf, sizeof(amtbuf));
    printf("In the wallet: %10s\n", amtbuf);
    printf("\nNote: These amounts may not be accurate unless you just did a "
	    "withdrawal.\n      Doing a withdrawal of 0 is useful to sync "
	    "these numbers.\n");
    ret = 0;

clean:
    EC_M_free_status(status);
    return ret;
}
