#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include "client.h"

static void show_payment_hdr(EC_M_Payment_hdr phdr)
{
    char timestr[40];
    char amtstr[80];
    char *newline;
    
    strcpy(timestr, ctime(&(phdr->timestamp)));
    /* Remove the \n from the ctime string */
    newline = strchr(timestr, '\n');
    if (newline) *newline = '\0';

    /* Get the amount */
    EC_U_curramt2str(phdr->currency, phdr->amount, amtstr, sizeof(amtstr));

    /* Show the payment header */
    printf("%4d. [%s] %s to %s for\n%s\n\n", phdr->seqno, timestr,
	amtstr, phdr->shop_accID, phdr->descr);
}

int lucre_list_payments(EC_W_Wallet wallet, UInt32 from, UInt32 to)
{
    EC_Errno err = EC_ERR_NONE;
    EC_M_Payment_hdr *payhdr = NULL;
    UInt32 numhdrs = 0;
    UInt32 i;

    /* Get the list of payments */
    err = EC_W_paydb_get_all_hdr(wallet, &payhdr, &numhdrs);
    if (err) return -1;

    /* Show them and free them */
    for (i=0;i<numhdrs;++i) {
	UInt32 seqno = payhdr[i]->seqno;
	if (!from || (!to && seqno == from) || (to && from <= seqno
	    && seqno <= to)) {
	    show_payment_hdr(payhdr[i]);
	}
	EC_M_free_payment_hdr(payhdr[i]);
	payhdr[i] = NULL;
    }

    /* Free the array */
    EC_G_free(payhdr);

    return 0;
}

int lucre_cancel_payment(EC_W_Wallet wallet, UInt32 seqno)
{
    EC_M_Msg            msg = NULL;
    EC_M_Payment        payment = NULL;
    int                 ret = -1;

    if (!wallet) return -1;

    /* Create a blank msg */
    msg = EC_M_new_msg();
    CHECK(new_msg, !msg);

    /* Get the payment from the db */
    payment = EC_W_paydb_get(wallet, seqno);
    CHECK(paydb_get, !payment);

    /* Replace the headers with more useful ones */
    payment->payment_hdr->shop_bankID = wallet->userrec->bankID;
    EC_G_free(payment->payment_hdr->shop_accID);
    payment->payment_hdr->shop_accID = EC_G_strdup(wallet->userrec->username);
    EC_M_snap_payment_hdr(payment->payment_hdr);

    /* Deposit the payment */
    ret = lucre_deposit_payment(wallet, msg, &payment, EC_M_DEPFLAGS_CASH);

clean:
    EC_M_free_msg(msg);
    EC_M_free_payment(payment);

    return ret;
}
