# Sample SpecTcl main program for testing GUI

package VPS::simpleAlert;

use VPS;
use Tk;
use Tk::Menu;
use Tk::DialogBox;
use Tk::LabEntry;

use Exporter;

@VPS::simpleAlert::ISA = qw(Exporter);
@VPS::simpleAlert::EXPORT    = qw(simpleAlert input_dialog information_alert);

# interface generated by SpecTcl (Perl enabled) version 1.1 
# from simpleAlert.ui
# For use with Tk402.002, using the grid geometry manager

sub simpleAlert {
    my ($top,$text) = @_;

    return 0 if (VPS::openWindow("simpleAlert"));
    my ($ok, $can) = ('OK', 'Cancel');
    my $ret = $top->Dialog(
		     -title => "VPS $main::VPSversion Alert!",
		     -text => $text,
		     -default_button => $can,
		     -buttons => [$ok, $can],
		     );
    my $result = $ret->Show;
  VPS::closeWindow("simpleAlert");
    return 1 if ($result eq $ok);
    return 0;
}

sub input_dialog {
    my ($top,$message) = @_;

    return 0 if (VPS::openWindow("input_dialog"));
    my $value = "";
    my $ret = $top->DialogBox( -title => "Input Required",
			      -buttons => ["OK", "Cancel"]
			      );
    my $label = $ret->add(LabEntry, 
		       -label => $message,
		       -labelPack => [-side => "left", -anchor => "w"], 
		       -textvariable => \$value)->pack(
						       -side => 'top', 
						       -expand =>0,
						       -fill => 'x');
    my $result = $ret->Show;
  VPS::closeWindow("input_dialog");
    if ($result eq 'OK') {
	my $value = $label->get();
	return (1,$value);
    }
    return (0,'');
}

sub information_alert {
    my ($top,$message) = @_;

    return 0 if (VPS::openWindow("information_alert"));
    my $ret = $top->Dialog( -title => "Message",
			   -text => $message
			   );
    my $result = $ret->Show;
  VPS::closeWindow("information_alert");
    return $result;
}

1;
