/*
The contents of this file contain text and code describing and 
implementing the 'DES' encryption algorithm. Despite the fact 
that this information is freely available overseas, it remains 
a violation of ITAR and/or EAR to export this information 
from inside the US or Canada to outside the US or Canada, or 
to pass it to a non-US or non-Canadian citizen within the US 
or Canada. The US Government evidently defines 'Export' to 
include placing this information on a non-restricted FTP server 
or Web site. Please do not do so, and be sure that any person you
pass this on to is made aware of this restriction.
									Peter Trei
									ptrei@acm.org

 * THIS SOFTWARE IS PROVIDED BY PETER TREI ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.

This software is copyright (c) 1997 Peter Trei (ptrei@acm.org), except for
those portions written by Phil Karn, which retain their
original ownership.

This software may be redistributed freely for use in the RSA DES Challenge,
but please obey the restrictions imposed by the US Government, and make
sure that anyone you pass it to is also aware of them.

This software may not be used for commercial purposes without the written
permission of Peter Trei and the other owners.

Please redistribute only as a complete, unmodified package, including 
source code, and ptrei@acm.org's PGP signature file and key.

 */


/* utility routines */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#ifndef WIN32
#include <time.h>
#endif
#include <sys/timeb.h>
#ifdef WIN32
#include <direct.h> /* for getcwd */
#endif
#include <sys/types.h> /* for _stat */
#include <sys/stat.h>  /* for _stat */

#include "deskr.h"
#include "data.h"

#ifndef WIN32 /* This is exactly opposite of how it should be done */
#define _stat stat
#endif

/* these are used when reading input data from a file. */
#define INPMODE_UNDEF		0
#define INPMODE_CONID		1
#define INPMODE_CIPHER		2
#define INPMODE_STATE		3
#define INPMODE_KEY			4
#define INPMODE_IV			5
#define INPMODE_ASCII		6
#define INPMODE_HEXPLAIN	7
#define INPMODE_HEXCIPHER	8

/* these values are used in rivest_test */
static unsigned char rivest_start[8] =
	{0x94,0x74,0xb8,0xe8,0xc7,0x3b,0xca,0x7d};
static unsigned char rivest_end[8] =
	{0x1b,0x1a,0x2d,0xdb,0x4c,0x64,0x24,0x38};


FILE *filehandle;
unsigned char line[100];
int inp_mode;
char *dir_list[4]; /* used in searching custom paths */
/*********************/
void print_blurb()
{
if (!run_quietly)
	{
printf("DES Key Recovery Engine. Version %s\n",VERSION);
printf("This is an early release - watch for announcement of new versions\n");
printf(" at http://www.ziplink.net/users/trei/crypto.html \n");
printf(" NO WARRANTY OF ANY KIND WHATSOEVER IS GIVEN FOR THIS PROGRAM\n");
printf(" IF IT SCREWS YOU UP, IT'S YOUR PROBLEM! YOU HAVE BEEN WARNED!\n");
printf(" I take no responsibility for bugs, including ones which cause\n");
printf(" you to miss finding the key.\n");
printf(" CHECK THE SOURCE CODE IF YOU'RE WORRIED.\n\n"); 
printf("Copyright (c) 1997 Peter Trei (ptrei@acm.org), January 1997\n");
/* If you adapt or port this program, give yourself credit here.*/
/* printf"Modified by:\n");*/
printf("\n");
printf("WARNING: It's almost certainly a violation of ITAR and/or EAR\n");
printf("to export this program outside the US and Canada (including placing\n");
printf("it on an unrestricted ftp or web server), so\n");
printf("DON'T DO IT!\n\n");
printf("For usage information, type deskr -h\n");
printf("Starting the program without arguments continues search.\n");
printf("or picks a random starting point if no checkpoint file is found.\n");
printf("\n");
	}
}

/*********************/
void put8(cp)
/* this prints an 8 char array as a hex number */
unsigned char *cp;
{
	int i;

	for(i=0;i<8;i++){
		printf("%02x",*cp++ & 0xff);
	}
}

/*********************/
void checkpoint_status()
{
	/*
	This routines checkpoints the status of the search to a file. The 
	goal is to make it possible to restore the search after a mid-chunk
	halt. It does this by storing the index values for b3,b2,b1, and b0,
	and also the chunk being searched. Any half-matches found so far
	are also stored, as is the checksum value up to this point. This 
	should allow us to restore the status and continue the search 
	efficiently.

  format:

	nonce chunk b3 b2 b1 b0 chksum
	halfmatch
	...
	halfmatch
	*/
unsigned int x,y;
FILE *filehandle;

struct _stat buf;
char buf2[100];

filehandle = fopen(chkpnt_tmp,"w");
if (filehandle == NULL) 
	{
	printf("Can't open temp checkpoint file.\n");
	exit(0);
	}

fprintf(filehandle,"%04lx %06lx %02x %02x %02x %02x %08x\n",
	   nonce, sh,b3,b2,b1,b0,checksum);
if (half_matches_found > 0)
	for (x = 0; x< half_matches_found; x++)
		{
		for (y = 0; y < 8; y++)
			fprintf(filehandle,"%02x",half_match[x][y]);
		fprintf(filehandle,"\n");
		}
fclose(filehandle);
unlink(chkpnt_des);
rename(chkpnt_tmp,chkpnt_des);

if (des_share_dir)
	{
	strcpy(buf2,des_share_dir);
	strcat(buf2,STOPNOW);
	if (!_stat(buf2,&buf))
		{
		printf("A file called %s has been created in the DESKRSHARE directory.\n",STOPNOW);
		printf("DESKR won't run while it exists. Probably someone is replacing deskr.exe\n");
		exit(0);
		}
	}
}
/*********************/
int restore_checkpoint()
/* restore status from checkpoint file. This reads
sh (chunk num), b3, b2, b1, b0, and on each remaining
line, half-matches. It also restores the key schedule. */
{
FILE *filehandle;
int x;
filehandle = fopen(chkpnt_des,"r");

if (filehandle == NULL) 
	{
	return(0);
	}
fscanf(filehandle,"%x %x %x %x %x %x %x\n",
	   &nonce, &sh,&b3,&b2,&b1,&b0,&checksum);
half_matches_found = 0;
while (!feof(filehandle))
	{
	for (x = 0; x < 8; x++)
		{
        int temp;
        fscanf(filehandle,"%02x", &temp);
        half_match[half_matches_found][x] = temp;
		/*
		fscanf(filehandle,"%02x",
			&half_match[half_matches_found][x]);*/
		}
	fscanf(filehandle,"%*c"); /* kill the new line char */
	half_matches_found++;
	}
if (half_matches_found) half_matches_found--;
fclose(filehandle);
restore_key_schedule(sh,b3,b2,b1,b0);
return 1;
}
/*********************/
/*
This is Ron Rivest's test for correct DES implementation. It's described
in http://theory.lcs.mit.edu/~rivest/destest.txt. Essentially, you take a
certain starting value (rivest_start), and alternately encrypt and 
decrypt it for a total of 16 steps, at each step using output of the 
previous step as both the input data and the key. If the output of the
final step matches a certain known value (rivest_end), then there is an 
extremely high probability that the DES implementation is correct. 

This routine returns 1 if the test passes, 0 if it fails. Or, you could
uncomment the printf's.
*/
int rivest_test()
	{
	unsigned long th, tl;
	static unsigned long ks[16][2];
	unsigned char data[8];

	int x;
	/* copy the starting value into data */
	for (x=0; x<8; x++) data[x] = rivest_start[x];
	/*data[0]++; *//* spoil the data to see if test is working */
	for (x=0; x<8; x++) /* 8 encrypt & decrypt steps */
		{
		/* encrypt step */
		crunchkey(data,(long *)&th,(long *)&tl);	/* convert key to crunched form */
		deskey3(ks,th,tl,0);		/* generate encrypt key schedule */
		initial_perm(data);			/* initial perm on data */
		do_first_round(ks);			/* first des round */
		do_middle_rounds(ks);		/* 14 middle des rounds */
		do_last_round(ks);			/* final round */
		final_perm(data);			/* final perm on data, convert to array */

		/* decrypt step */
		crunchkey(data,(long *)&th, (long *)&tl);
		deskey3(ks,th,tl,1);		/* generate decrypt key schedule */
		initial_perm(data);
		do_first_round(ks);
		do_middle_rounds(ks);
		do_last_round(ks);
		final_perm(data);
		}
	/* compare final output to expected value */
	for (x=0; x<8; x++)
		{
		if (data[x] != rivest_end[x])
			{
			/*printf("rivest test failed\n");*/
			return 0;
			}
		}
	/*printf("rivest test passed\n");*/
	return 1;
	}				   
/*********************/
void write_solution_file(char *filepath)
{
int x;
	filehandle = fopen(filepath,"a+");
	if (filehandle == NULL) 
		{
		printf("Can't open temp solution.txt file.\n");
		exit(0);
		}
/* required format for a solution: 
challenge: DES
solution: 23 3e ef 79 a4 85 c7 f2
name: Julius Caesar and his pal Brutus
address: Julius Caesar
         Capital Building
         Rome, Italy
email: julius@rome.it
phone: 555-0000
time: Around 10,000 MIPS-years
method: Two people using abacuses
done:
*/
	fprintf(filehandle,"challenge: %s\n",con_id);
	fprintf(filehandle,"solution:");
	for (x=0; x<8; x++)
		fprintf(filehandle," %02x",pkey[x]);
	fprintf(filehandle,"\n");
	fprintf(filehandle,"name: PUT YOUR NAME HERE.\n");
	fprintf(filehandle,"address: PUT YOUR SNAIL MAIL\n");
	fprintf(filehandle,"         ADDRESS HERE. ADD EXTRA\n");
	fprintf(filehandle,"         INDENTED LINES LIKE THIS\n");
	fprintf(filehandle,"         IF NEEDED.\n");
	fprintf(filehandle,"email: PUT YOUR EMAIL ADDRESS HERE.\n");
	fprintf(filehandle,"phone: PUT YOUR TELEPHONE NUMBER HERE.\n");
	fprintf(filehandle,"time: Avg 4000 years on a 100 MHz Pentium.\n");
	fprintf(filehandle,"method: Brute force search. Peter Trei's DESKR.\n");
	fprintf(filehandle,"done:\n\n");
	fprintf(filehandle,"User: %s\n",ident_string);
	fprintf(filehandle,"You need to email this file to crypto-challenge@rsa.com immediatly.\n");
	fprintf(filehandle,"Check http://www.rsa.com to find \n");
	fprintf(filehandle,"the current status of the search.\n");
	fclose(filehandle);

}
/*********************/
void append_to_deskr_out(int status,char *filepath)
{

unsigned int x,y;
filehandle = fopen(filepath,"a+");
if (filehandle == NULL) 
	{
	printf("Can't open results file.\n");
	exit(0);
	}
/*
Output formats.

All output formats start with a 2 digit hex
number which identifies the format for the rest
of the output. This will allow a smart program
to interperet the output from a variety of 
versions of the key search SW.

The following describes format 0.

ver search nonce code ...

  ver: 00

  search: 4 digit hex num identifying which search
		  this result applies to.
  nonce:  4 digit hex num supplied by keyspace server.
	      If chunk is self-assigned, then nonce is 0000.
  code:   NAK - key not found.
          ACK - key found

  For NAKs:
  ... chunk chksum halfmatchcount {halfmatches} ident

  chunk:  6 hex char
  chksum: 8 hex char
  halfmatchcount: decimal number.
  halfmatches: 16 hex char
  ident: double quoted char string.

  For ACKs:
  ... key ident

  key: 16 char hex
  ident: double quoted char string.

*/

/* format 02
02 program-id contest-id nonce code

  program-id: short string identifying version of program used.
	eg: "deskr-a-03" for deskr, assembler version 3
  contest-id: RSA specified identifier for the search.
	eg: "DES-test"
  nonce: 4 hex digit code supplied by keyserver. 0000 if no 
	keyspace server.
	code expands to:
		NAK chunk chksum halfmatchcount ident-string.
			halfmatch 1
			halfmatch 2 
			etc....
		halfmatches are indented with whitespace, one per line.
	OR
		ACK key ident-string
		where key is the answer.
*/
if (status == 0)
	{
	fprintf(filehandle,"02 %s %s %04x ",VERSION,con_id,nonce);
	fprintf(filehandle,"NAK %06lx %08lx %d %s\n",
		sh,checksum,half_matches_found,ident_string);
	if (half_matches_found > 0)
		{
		for (x = 0; x < half_matches_found; x++)
			{
			for (y = 0; y < 8; y++)
				{
				fprintf(filehandle," %02x",half_match[x][y]);
				}
			fprintf(filehandle,"\n");
			}
		}
	fclose(filehandle);
	}
else
	{ /* ACK */
	fprintf(filehandle,"ACK ");
	for (x=0;x<8;x++) fprintf(filehandle,"%02x ",pkey[x]);
	fprintf(filehandle,"%s\n",ident_string);
	fclose(filehandle);
	}

}
/*********************/
void record_output(int status)
{
/* append chunk's data to the output file */
/* NAK: status = 0
   ACK: status = 1*/

FILE *filehandle;
char lockfile_path[100];
char output_path[100];
unsigned int x,paused;
struct _stat buf;

/* first, write to the local files */
strcpy(output_path,des_local_output_dir);
strcat(output_path,DESKROUT);
append_to_deskr_out(status,output_path);
if (status == 1)
	{
	strcpy(output_path,des_local_output_dir);
	strcat(output_path,DESKRSOLUTION);
	write_solution_file(output_path);
	printf("\n\a\a\aYou've found the solution! If this is the real challenge,\n");
	printf("you should email the file solution.txt to RSA immediately,\n");
	}

/* now, write to the shared dir */
if (use_lockfiles)
	{
	x= 0;
	/* does the lockfile exist? */
	strcpy(lockfile_path,des_share_dir);
	strcat(lockfile_path,DESKRLOCK);
	paused = 0;
	/* there ought to be a better way to do a sleep in C, but
	this is a microsoft compiler */
	while (!x)
		{
		x = _stat(lockfile_path,&buf);
		if (!x && (!paused)) 
			{
			paused = 1;
			printf("Pausing due to collision on lock file.\n");
			}
		}
	if (paused)
		{
		printf("Pause ending.\n");
		paused = 0;
		}
	/* create the lockfile */
	filehandle = fopen(lockfile_path,"w");
	fclose(filehandle);
	}
append_to_deskr_out(status,deskr_out);
half_matches_found = 0;

if (use_lockfiles) unlink(lockfile_path);
if (status == 1)
	write_solution_file(deskr_solution);

}
/*********************/
void time_check(int report)

{
	/* estimate the speed of this implementation on this
	machine. This sets rate. A non-zero value for report will
	make it print the rate and the estimated time per chunk. */
	int z,w/*,x*/ ;
	double rate,elapsed;
	int i_rate,i_elapsed;
	unsigned long chunk_size;
	unsigned long normal_sh;
	long seconds, minutes,days, hours;
	struct timeb start,stop;

	set_keydiffs();			/* set up the keydiff tables */
	set_gray8();			/* set up the 8 bit gray code table */

	initial_perm(plain);	
	final_perm_input_left = left;
	final_perm_input_right = right;

	initial_perm(cipher);
	initial_perm_output_left = left;
	initial_perm_output_right = right;
	elapsed = 0;
	i_elapsed = 0;
	normal_sh = sh; /* stash the standard value, since we're
					   munging the global variable. */
	for (z = 0; z < 10; z++)
		{
		sh = 0x00003533; /* wrong target key, crunched */
		sl = 0;

		checksum = 0; /* workfactor check */

		/* deskey3 generates a complete key schedule from the 2 long
		format */
		deskey3(knd,sh,sl,1);

		do_first_round(knd);
		round1_output_left = left;
		round1_output_right = right;
    	
		done = 0; done_lower = 0;
		b0 = 0; b1=0; b2=0; b3 = 0;
#ifdef NOFTIME
		start.time=time(0);
		start.millitm=0;
#else
		ftime(&start);
#endif
#ifdef WIN32
		if (Asmversion)
			w = x86_do_lower_16();
		else
#endif /* WIN32 */
			w = do_lower_16();
#ifdef NOFTIME
		stop.time=time(0);
		stop.millitm=0;
#else
		ftime(&stop);
#endif
		if (w == 1) printf("timer got a half key\n");
		elapsed += 1000*(stop.time - start.time) + (stop.millitm - start.millitm);

	}
	rate = (655360.0/elapsed)*1000.0;
	/* The next line give a compile time warning due to
	the type mismatch, but I can't find a graceful way
	around it. */
	i_rate = rate;
	/* times around outer loop before chkpnt*/
	chkpnttime = (CHKPNTMIN * 60 * i_rate)/65536; 
	/* chkpnttime = 1;  tmp */
	if (report)
		{
		printf("rate = %d keys/sec\n",i_rate);
		chunk_size = 0xFFFFFFFF;
		seconds = chunk_size/i_rate;
		minutes = seconds/60;
		hours = minutes/60;
		days = hours/24;
		minutes -= hours * 60;
		hours -= days * 24;
		printf("Estimated time for a 2^32 key chunk: ");
		if (days > 0) printf("%ld days,",days);
		if (hours > 0) printf(" %ld hours,",hours);
		printf(" %ld minutes.\n",minutes);
		}
	sh = normal_sh;
}

/**************/
void pack_hex_string(char *unpacked,char *packed,int packed_length)
{
/* the unpacked string contains an ascii
representation of a hex number. This routine
packs it into the packed array.*/
int x,z;
char c1, c2;
for (x=0; x< packed_length; x++)
	{
	c1 = tolower(unpacked[x*2]);
	c2 = tolower(unpacked[(x*2)+1]);
	if (isalpha(c1))
		z = 16 * (c1-0x57);
	else
		z = 16 * (c1-0x30);
	if (isalpha(c2))
		z += c2-0x57;
	else
		z += c2-0x30;
	packed[x] = z;
	}
}
/**************/
void pack_spaced_hex_string(char *unpacked,char *packed,int packed_length)
{
/* the unpacked string contains an ascii
representation of a hex number. This routine
packs it into the packed array.*/
int x,z;
char c1, c2;

for (x=0; x< packed_length; x++)
	{
	c1 = tolower(unpacked[x*3]);
	c2 = tolower(unpacked[(x*3)+1]);
	if (isalpha(c1))
		z = 16 * (c1-0x57);
	else
		z = 16 * (c1-0x30);
	if (isalpha(c2))
		z += c2-0x57;
	else
		z += c2-0x30;
	packed[x] = z;
	}
}

/**************/
int read_challenge_data_internally()
{	
/* 
Assumes data is read from data.h
*/
int x;
for (x = 0; x<8; x++)
	{
	cipher[x] = x_ciphertext[x];
	iv[x] = x_iv[x];
	key[x] = x_key[x];
	}
knowntext_len = x_knowntext_len;
ciphertext_len = x_ciphertext_len;
for (x = 0; x<ciphertext_len; x++) full_ciphertext[x] = x_ciphertext[x];
for (x = 0; x<knowntext_len;  x++) full_knowntext[x]  = x_knowntext[x];
strcpy((char *)con_id,(const char *)x_contest_id);
strcpy((char *)cipher_name,(const char *)x_cipher_name);
strcpy((char *)con_state,(const char *)x_con_state);
strcpy((char *)ascii_plaintext,"The unkn");
strcpy((char *)plain,"The unkn");

/* the initial and final perms are complementary. Here, we run
the target plaintext through the initial perm, which is the same
as running it backwards through the final perm. The result, in
left and right, is stashed to be compared to the output of the
des rounds. */
/* extra step here to handle cbc mode */
/*
for (x = 0; x<8; x++)
	plain[x] ^= iv[x];
initial_perm(plain);	
final_perm_input_left = left;	
final_perm_input_right = right;
*/
/* run the ciphertext through the initial perm to get the input
to the des rounds. Stash the result as well, so we don't have to
go through this step again. */
/*
initial_perm(cipher);
initial_perm_output_left = left;
initial_perm_output_right = right;
crunchkey(x_key,&zh,&zl);
*/
return 1;

}
/**************/
void read_hex8(char *field, int y)
{
/* read an 8 byte hex field */
unsigned char unpacked[16];
int x,z;
z = 0;
for (x=0; x<8; x++)
	{
	unpacked[z++] = line[y++];
	unpacked[z++] = line[y++];
	y++;
	}
pack_hex_string((char *)unpacked,field,8);
}
/**************/
int read_hexlong(char *field)
{
int x,z,done;
unsigned long status;
char *c,*d;

done = 0;
x = 0; /* number of characters in packed hex string */
d = field;
while (1)
	{
	status = (unsigned long)fgets((char *)line,100,filehandle);
	/* have we reached the end of the file, or the next field?*/
	if ((!status) || (line[0] == '*') || (strlen(line) < 3)) 
		{
		*d = '\0';
		return (strlen(field));
		}
	/* trim of trailing newline */
	line[strlen((const char *)line)-1] = '\0';
	/* eat leading whitespace */
	c = (char *)line;
	while ((*c == ' ') || (*c == '\t')) c++;
	z = (strlen(c)/3)+1;
	pack_spaced_hex_string(c,d,z);
	d += z;
	}
}
/**************/
int readfield()
{
	unsigned char tag[100];
	int x,y;
	unsigned char *c;

	x = 0;
	/* kill leading whitespace */
	while ((line[x] == '*')||(line[x] == ' ')) x++;
/*	x++;  */
	/* read the tag */
	y = 0;
	while (line[x] != ':') tag[y++] = line[x++];
	tag[y] = '\0';
	/* eat the ': ' at the end of the tag */
	while ((line[x] == ':')||(line[x] == ' ')||(line[x] == '\t')) x++;
	/* figure out which tag this is */
	inp_mode = INPMODE_UNDEF;
	if (!strcmp((const char *)tag,"Contest identifier")) inp_mode = INPMODE_CONID;
	if (!strcmp((const char *)tag,"Cipher")) inp_mode = INPMODE_CIPHER;
	if (!strcmp((const char *)tag,"State of contest")) inp_mode = INPMODE_STATE;
	if (!strcmp((const char *)tag,"Key")) inp_mode = INPMODE_KEY;
	if (!strcmp((const char *)tag,"IV")) inp_mode = INPMODE_IV;
	if (!strcmp((const char *)tag,"ASCII text")) inp_mode = INPMODE_ASCII;
	if (!strcmp((const char *)tag,"Hexadecimal plaintext")) inp_mode = INPMODE_HEXPLAIN;
	if (!strcmp((const char *)tag,"Hexadecimal ciphertext")) inp_mode = INPMODE_HEXCIPHER;
	switch (inp_mode)
		{
		case INPMODE_CONID:
			{
				strcpy((char *)con_id,(const char *)&line[x]);
				line[0] = '\0';
				break;
			}
		case INPMODE_CIPHER:
			{
				strcpy((char *)cipher_name,(const char *)&line[x]);
				line[0] = '\0';
				break;
			}
		case INPMODE_STATE:
			{
				strcpy((char *)con_state,(const char *)&line[x]);
				line[0] = '\0';
				break;
			}
		case INPMODE_ASCII:
			{
				x++; /* kill the leading double quote */
				strcpy((char *)ascii_plaintext,(const char *)&line[x]);
				/* kill the trailing double quote */
				c = (unsigned char *)strrchr((const char *)ascii_plaintext, (int)'"');
				*c = '\0';
				line[0] = '\0';
				ascii_plaintext_len = strlen((const char *)ascii_plaintext);
				break;
			}
		case INPMODE_KEY:
			{
			/*	read_hex8(key,x);	  don't read it in, so we won't step*/
				line[0] = '\0';		 /* on a key read from the command line */
				break;
			}
		case INPMODE_IV:
			{
				read_hex8((char *)iv,x);
				line[0] = '\0';
				break;
			}
		case INPMODE_HEXPLAIN:
			{
				knowntext_len = read_hexlong((char *)full_knowntext);
				break;
			}
		case INPMODE_HEXCIPHER:
			{
			/*	printf("trace 3.1\n");		*/
				ciphertext_len = read_hexlong((char *)full_ciphertext);
			/*	printf("trace 3.2\n");		*/
				break;
			}
		default: line[0] = '\0'; /* unrecognized line */
		}
	return(feof(filehandle));
}	
/**************/
int read_challenge_data_from_file()
{
int status;

filehandle = fopen(deskr_in,"r");
inp_mode = INPMODE_UNDEF;
line[0] = '\0';
if (filehandle == NULL) 
	{
#if 0
	printf("Can't open test data file.\n");
#endif
	return(0);
	}
done = 0;
while (!done)
	{
	if (!line[0])
		status = (int)fgets((char *)line,100,filehandle);
	if (!status)
		done = 1;
	else
		{
		/* printf("* %s",line);*/	  /* trace */
		line[(strlen((char *)line) -1)] = '\0'; /* kill the newline char;*/
		if (strlen(line) > 3)
			done = readfield();
		} 
	}
fclose(filehandle);
return 1;
}
/**************/
int get_test_data()
{
int status,x,y;
/*printf("trace 2.1\n"); */
if (deskr_in[0] != '\0')
	{
	status = read_challenge_data_from_file();

	}
else
	status = read_challenge_data_internally();
/* printf("trace 2.2\n"); */
strcpy((char *)ascii_plaintext,"The unknown message is:");

/* copy first 8 chars of cipher & plaintext to working buffers, and 
   prepare for use in search */
for (x = 0; x<8; x++)
	{
	plain[x] = ascii_plaintext[x];
	cipher[x] = full_ciphertext[x];
	}
/* xor iv into the plaintext */
for (x = 0; x<8; x++)
	plain[x] ^= iv[x];
/* run the xor'd plaintext thru the initial perm. This is the inverse
of the final perm, so we can stash this for later checking, avoiding
having to run the final perm for every key tested. */
initial_perm(plain);	
final_perm_input_left = left;	
final_perm_input_right = right;

/* run the ciphertext through the initial perm to get the input
to the des rounds. Stash the result as well, so we don't have to
go through this step again. */
initial_perm(cipher);
initial_perm_output_left = left;
initial_perm_output_right = right;

if (verbose_flag)
	{
	printf("\nData used in this search:\n");
	/*  plaintext */
	printf("Initial known plaintext: %s\n",ascii_plaintext);
	/* iv */
	printf("IV:");
	for (x = 0; x < 8; x++)
		printf(" %02x",iv[x]);
	printf("\n");
	/* ciphertext */
	printf("Ciphertext: \n");
	y = 0;
	for (x = 0; x<ciphertext_len; x++)
		{
		printf("%02x ",full_ciphertext[x]);
		y++;
		if (y == 16)
			{
			printf("\n");
			y = 0;
			}
		}
	/* searcher id */
	}
return 1;
}
/**************/
int get_ident()
{
FILE *filehandle;
char c;
int done,x;

if (!(deskr_id[0] == '\0'))
	{
	filehandle = fopen(deskr_id,"r");

	if (filehandle == NULL) 
		{
		return(0);
		}
	ident_string[0] = '\0';
	done = 0; x = 0;
	while (!done)
		{
		c = (char)fgetc(filehandle);
		if ((c == '\n') || (feof(filehandle)))
			{
			done = 1;
			ident_string[x] = '\0';
			}
		else
			ident_string[x++]=c;
		}
	fclose(filehandle);
	}
return 1;
}

/*********************/
int find_file_in_path(char *filename, char *blurb)
{
/* search global dir_list dirs in order to find file. 
	Return pointer to first dir which contains file, 
	or null if not found */
int x;
struct _stat buf;
char buf2[100];

for (x = 0; x < 4; x++)
	{
	if (dir_list[x])
		{
		strcpy(buf2,dir_list[x]);
		strcat(buf2,filename);
			if (_stat(deskr_in,&buf)) deskr_in[0] = '\0';  /* why is this here ? */

		if (!_stat(buf2,&buf))
			{
			if (verbose_flag) 
				printf("%s %s found in %s.\n",blurb, filename, dir_list[x]); 
			return x;
			}
		}
	}
return -1;
}
/*********************/
void startup_functions()
{
int x;
struct _stat buf;
char buf2[100];



print_blurb();
srand( (unsigned)time( NULL ) ); /* kick the random number generator*/
/* locate directories for files */

des_cwd_dir[0] = '\0';
des_prog_dir[0] = '\0';

#ifdef WIN32
_getcwd(des_cwd_dir,100);
#else
getcwd(des_cwd_dir,100);
#endif

des_local_dir = getenv("DESKRLOCAL");
des_share_dir = getenv("DESKRSHARE");

/* the backslash stuff will need to be modified for unix*/
des_dir = (char *) &filepath;
/* convert the first argument, which contains the
program name along with a complete filepath, to just
the filepath. When there is no DESKRDIR envar, we'll
use the directory containing deskr program.*/
x = strlen((const char *)firstarg);
#ifdef WIN32
#define PATH_DELIMC '\\'
#define PATH_DELIMS "\\"
#else
#define PATH_DELIMC '/'
#define PATH_DELIMS "/"
#endif
while(firstarg[x] != PATH_DELIMC && x >= 0) /* jim g's fix
while (firstarg[x] != PATH_DELIMC) 						  */
	firstarg[x--] = '\0';

strcpy (des_prog_dir, (const char *)firstarg);
/* if in use, all dirs should have a terminal slash */
if (des_prog_dir[0])
	if (des_prog_dir[strlen(des_prog_dir)-1] != PATH_DELIMC)
		strcat(des_prog_dir,PATH_DELIMS);
if (des_local_dir)
	if (des_local_dir[strlen(des_local_dir)-1] != PATH_DELIMC)
		strcat(des_local_dir,PATH_DELIMS);
if (des_share_dir)
	if (des_share_dir[strlen(des_share_dir)-1] != PATH_DELIMC)
		strcat(des_share_dir,PATH_DELIMS);
if (des_cwd_dir[0])
	if (des_cwd_dir[strlen(des_cwd_dir)-1] != PATH_DELIMC)
		strcat(des_cwd_dir,PATH_DELIMS);

if (verbose_flag)
	{
	printf("Directories and environment variables:\n");
	if (des_share_dir)
		printf("DESKRSHARE envar: %s\n",des_share_dir);
	else
		printf("DESKRSHARE envar is undefined.\n");
	if (des_local_dir)
		printf("DESKRLOCAL envar: %s\n",des_local_dir);
	else
		printf("DESKRLOCAL envar is undefined.\n");
	des_share_dir = getenv("DESKRSHARE");
	printf("Program dir is: %s\n",des_prog_dir);
	printf("Connected dir is: %s\n\n",des_cwd_dir);
	}

/* Make sure DESKRSHARE does not point to the connected or local directory.
   In the case where many machines are running from the same DESKRSHARE,
   this could lead to the checkpoint files being overwritten. */
if (des_share_dir)
	{
	if (des_local_dir)
		{
		if (!stricmp(des_share_dir,des_local_dir))	  /* case insensitive compariscon */
			{
			printf("ERROR: DESKRSHARE is the same as DESLOCALDIR. Please make them different.\n");
			exit(0);
			}
		}
	if (des_cwd_dir)
		{
		if (!stricmp(des_share_dir,des_cwd_dir))
			{
			printf("ERROR: DESKRSHARE points to the connected directory.\n");
			printf("Please run DESKR from a different directory.\n");
			exit(0);
			}
		}
	/* also make sure we aren't trying to shut down everything */
 
		strcpy(buf2,des_share_dir);
		strcat(buf2,STOPNOW);
		if (!_stat(buf2,&buf))
			{
			printf("A file called %s has been found in the DESKRSHARE directory.\n",STOPNOW);
			printf("DESKR won't run while it exists.\n");
			exit(0);
			}
 
  }

/* check for an existing solution file. Stop if it's present. */

dir_list[0] = des_share_dir;
dir_list[1] = des_local_dir;
dir_list[2] = des_prog_dir;
dir_list[3] = des_cwd_dir;
x = find_file_in_path(DESKRSOLUTION,"Solution output file");
if (x >= 0)
	{
	/* we've already got a solution. complain and stop */
	printf("\n\aA solution file has been found:\n");
	printf("%s%s\n",dir_list[x],DESKRSOLUTION);
	printf("If this is the real thing, and you are the first to find it,\n");
	printf("you should email it to crypto-challenge@rsa.com immediately, and\n"); 
	printf("claim your prize.\n");
	printf("If it's left over from a practice run, you should delete it,\n");
	printf("and restart the program.\n");
	exit(0);
	}
else
	{
	/* figure out where to stash a solution file */
	if (des_share_dir)
		{
		strcpy(deskr_solution,des_share_dir);
		if (verbose_flag)
			{
			printf("Solution file %s will be written to DESKRSHARE.\n",DESKRSOLUTION);
			printf("A copy will be written to %s\n",des_local_output_dir);
			}
		}
	else
		{
		if (des_local_dir)
			{
			strcpy(deskr_solution,des_local_dir);
			if (verbose_flag) 
				printf("Solution file %s will be written to DESKRLOCAL.\n",DESKRSOLUTION);
			}
		else
			{
			strcpy(deskr_solution,des_prog_dir);
			if (verbose_flag) 
				printf("Solution file %s will be written to program dir.\n",DESKRSOLUTION);
			}
		}
	strcat(deskr_solution,DESKRSOLUTION);
	}


/* locate checkpoint files */
if (des_local_dir)
	{
	strcpy(chkpnt_tmp,des_local_dir);
	strcpy(chkpnt_des,des_local_dir);
	if (verbose_flag)
		printf("Checkpoint files will be in DESKRLOCAL.\n");
	}
else
	{
	strcpy(chkpnt_tmp,des_cwd_dir);
	strcpy(chkpnt_des,des_cwd_dir);
	if (verbose_flag)
		printf("Checkpoint files will be in connected dir.\n");
	}
strcat(chkpnt_tmp,CHKPNTTMP);
strcat(chkpnt_des,CHKPNTDES);

/* identify the local output directory */
if (des_local_dir)
	strcpy(des_local_output_dir,des_local_dir);
else
	strcpy(des_local_output_dir,des_cwd_dir);
	
/* locate output file */
use_lockfiles = 0;
if (des_share_dir)
	{
	use_lockfiles = 1;
	strcpy(deskr_out,des_share_dir);
	if (verbose_flag) 
		{
		printf("Results file %s will be in DESKRSHARE.\n",DESKROUT);
		printf("A copy will be written to %s\n",des_local_output_dir);
		}
	}
else 
	if (des_local_dir)
		{
		strcpy(deskr_out,des_local_dir);
		if (verbose_flag) printf("Results file %s will be in DESKRLOCAL.\n",DESKROUT);
		}
	else
		{
		strcpy(deskr_out,des_prog_dir);
		if (verbose_flag) printf("Results file %s will be in connected dir.\n",DESKROUT);
		}
strcat(deskr_out,DESKROUT);

/* locate challenge data 
Search for file defined by symbol DESKRIN, in directories in this order:
DESKRSHARE, DESKRLOCAL, des_prog_dir, des_cwd_dir. Set deskr_in to correct
path. If it can't be found in any, leave deskr_in[0] to null - this will be
a flag to use internal data. */


dir_list[0] = des_share_dir;
dir_list[1] = des_local_dir;
dir_list[2] = des_prog_dir;
dir_list[3] = des_cwd_dir;
x = find_file_in_path(DESINPUT,"Challenge data file");
if (x >= 0)
	{
	strcpy(deskr_in,dir_list[x]);
	strcat(deskr_in,DESINPUT);
	}
else
	{
	deskr_in[0] = '\0';
	if (verbose_flag)
		printf("Challenge data file %s not found. Using internal data\n",
			DESINPUT);
	}
/* identity file is searched for in the  order:
   connected dir,DESKRLOCAL,program dir,DESKRSHARE */
deskr_id[0] == '\0';
dir_list[3] = des_share_dir;
dir_list[1] = des_local_dir;
dir_list[2] = des_prog_dir;
dir_list[0] = des_cwd_dir;
x = find_file_in_path(DESKRID,"Searcher identity file");
if (x >= 0)
	{
	strcpy(deskr_id,dir_list[x]);
	strcat(deskr_id,DESKRID);
	}
else
	{
	if (verbose_flag)
		printf("Searcher ID file %s not found. Using UNKNOWN \n",
			DESKRID);
	strcpy((char *)ident_string,"Unknown searcher");
	}
	
nonce = 0;
searchid = 0;

/*strcpy((char *)ident_string,"unknown user");
	printf("Searcher ID file %s not found. Using UNKNOWN \n",
*/
set_keydiffs();			/* set up the keydiff tables */
set_gray8();			/* set up the 8 bit gray code table */
if (rivest_test() == 0)
	{ 
	printf("Rivest test failed\n");
	exit(0);
	}


}

