# Makefile for GNU 386 assembler version under UNIX
CC=gcc
CFLAGS=-O4
certify: descerta des3certa testdata
	./descerta < testdata
	./des3certa < testdata

descerta: descert.o deskey.o desgnu.o desspa.o
	$(CC) -o descerta descert.o deskey.o desgnu.o desspa.o

des3certa: des3cert.o deskey.o des3gnu.o desspa.o
	$(CC) -o des3certa des3cert.o deskey.o des3gnu.o desspa.o

descyclea: descycle.o deskey.o desgnu.o desspa.o
	$(CC) -o descyclea descycle.o deskey.o desgnu.o desspa.o

destimea: unixtime.o deskey.o desgnu.o desspa.o
	$(CC) -o destimea unixtime.o deskey.o desgnu.o desspa.o

des3timea: unixtime3.o deskey.o des3gnu.o desspa.o
	$(CC) -o des3timea unixtime3.o deskey.o des3gnu.o desspa.o

# The SP boxes for the assembler version are left-rotated 3 bits
desspa.c: gensp
	./gensp a > desspa.c

gensp: gensp.c
	$(CC) -O -o gensp gensp.c

# GNU as seems confused by what should be legal comments. Double quotes
# in comments apparently start strings that extend past the end of line,
# and the "# file 1" lines emitted by cpp also seem to confuse it. So
# we strip out all the offending material.
desgnu.o: desgnu.s
	cpp desgnu.s | tr -d '"' | sed -e '/^#/d' | as -o desgnu.o
des3gnu.o: des3gnu.s
	cpp des3gnu.s | tr -d '"' | sed -e '/^#/d' | as -o des3gnu.o

	
