/*rc4.c */
#include "rc4.h"

static unsigned char xyzzy_tmpc;
#define SWAP_BYTE(a,b) xyzzy_tmpc=a; a=b; b=xyzzy_tmpc
void prepare_key(unsigned char *key_data_ptr, int key_data_len, rc4_key *key)
{
    unsigned char index1;
    unsigned char index2;
    unsigned char *state;
    int counter;

    state = &key->state[0];
    for (counter = 0; counter < 256; counter++)
        state[counter] = counter;
    key->x = 0;
    key->y = 0;
    index1 = 0;
    index2 = 0;
    for (counter = 0; counter < 256; counter++) {
        index2 = (key_data_ptr[index1] + state[counter] + index2) % 256;
        SWAP_BYTE(state[counter], state[index2]);
        index1 = (index1 + 1) % key_data_len;
    }
}

void rc4(unsigned char *buffer_ptr, int buffer_len, rc4_key *key)
{
    unsigned char x;
    unsigned char y;
    unsigned char *state;
    int counter;

    x = key->x;
    y = key->y;

    state = &key->state[0];
    for (counter = 0; counter < buffer_len; counter++) {
        x++;
        y += state[x];
        SWAP_BYTE(state[x], state[y]);
        buffer_ptr[counter] ^= state[(state[x] + state[y]) % 256];
    }
    key->x = x;
    key->y = y;
}

#ifdef SIMPLE_DRIVER
#include <stdio.h>
main(int argc, char *argv[])
{
    rc4_key key;
    int len;
    unsigned char buf[8192];
    if (argc < 2) {
        fprintf(stderr, "usage: %s key\n", argv[0]);
        exit(1);
    }
    prepare_key(argv[1], strlen(argv[1]), &key);
    while (len = fread(buf, 1, 8192, stdin)) {
        rc4(buf, len, &key);
        fwrite(buf, 1, len, stdout);
    }
    exit(0);
}

#endif
