/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#include "muttlib.h"

#include <sys/time.h>

static int days_per_month[12] = {
  31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};

#define is_leap_year(x) ((x)%4 == 0 && ((x)%100 != 0))

time_t mutt_gmsecs (int year, int month, int day, int hour, int min, int sec)
{
  time_t t = 0;
  int i;

  for (i=0; i<year; i++)
  {
    t += 365 * 24 * 3600;
    if (is_leap_year (i+EPOCH))
      t += 24 * 3600;
  }
  for (i=0; i<month; i++)
  {
    t += days_per_month[i] * 24 * 3600;
  }
  t += day * 24 * 3600;
  t += hour * 3600;
  t += min * 60;
  t += sec;

  return t;
}

time_t mutt_gmtime (HEADER *h)
{
  time_t t;

  t = mutt_gmsecs (h->year, h->month, h->day, h->hours, h->minutes, h->seconds);

  /* account for timezone */
  if (h->zoccident) /* west of GMT */
  {
    t += h->zhours * 3600;
    t += h->zminutes * 60;
  }
  else /* east of GMT */
  {
    t -= h->zhours * 3600;
    t -= h->zminutes * 60;
  }
  return t;
}
