/*

   A demo program which samples a given number of bytes from the
   /dev/random driver and writes them to a file.

   Added -a option to append data to file, 10 Jan 96
   Fixed bugs with opening /dev/random when driver uninstalled,
     and when a write error occurs with file, 14 Jan 96
   Removed suspicious pointers, fixed for use with /dev/urandom, 15 Jan 96

*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#ifdef __MSDOS__
  #define SIZE 8192             /* size of buffer */
#else
  #define SIZE 1024
#endif

void main(int argc, char *argv[]) {

  FILE *randstream, *ofile;
  unsigned long num;
  int i;
  unsigned int bytesread,needed;
  static char buff[SIZE], *ofname, *filemode, *modetext, *devname;

  if (argc<3) {
    fprintf(stderr, "usage: sample file num [device] [-a]\n"
                  "examples: sample randseed.bin 408\n"
                  "          sample noiz 64 /dev/random -a\n"
                  "Reads num bytes from /dev/urandom and writes to file\n"
                  "  -a   append bytes to existing file\n");
/* -------------------------------------------------------------------------
   WARNING: This doesn't check if a file exists already, so it's very
   possible to overwrite a file out of carelessness!
-------------------------------------------------------------------------- */
  }
  else {
    filemode="wb";
    modetext="create";
    devname="/dev/urandom";

    if (argc>3) for (i=3;i<argc;i++) {
      if (strcmp(argv[i],"-a")==0) {
        filemode="ab"; /* append mode */
        modetext="open";
      } else devname=argv[i];
    }
    ofname=argv[1];
        /* ----- open random stream in binary mode ----- */
    if ((randstream=fopen(devname,"rb"))<=0) {
   /* sometimes if device is not loaded, randstream == 0 */
      fprintf(stderr, "error opening %s\n",devname);
      exit(EXIT_FAILURE);
    } else if ((ofile=fopen(ofname,filemode))<0) { 
        fprintf(stderr, "unable to %s file %s\n", modetext, ofname);
        exit(EXIT_FAILURE);
    } else {
      num=0;
      sscanf(argv[2], "%ld", &num);
#ifdef DEBUG
      fprintf(stderr, "%s file %s of %ld bytes (requested)\n", modetext, ofname, num);
#endif
      do {
        needed=(SIZE>num)?(needed=num):(needed=SIZE);
   /* ----- read bytes from the random stream ----- */
        bytesread=fread(&buff, 1, needed, randstream);
#ifdef DEBUG
        fprintf(stderr, "%d bytes read from device\n", bytesread);
#endif
        if (bytesread)
           num-=((i=fwrite(&buff, 1, bytesread, ofile))>=0)?i:0;
      } while ((num!=0) && (bytesread==needed) && (i==bytesread));
      fclose(ofile);
      exit(EXIT_SUCCESS);
    }
  }
}

