	include	printf.inc ; added v0.4.3

; --------------------------------------------------------------------------
;rInitDevice     PROC    NEAR
;                les     bx, DWORD PTR rrh ; es:[bx] -> random response hdr
;                lea     dx, EndOfDevice
;                mov     WORD PTR es:[bx].ReqHdr.Addr, dx
;                mov     WORD PTR es:[bx].ReqHdr.Addr+2, cs
;                jmp     rFinished
;rInitDevice     ENDP

; --------------------------------------------------------------------------
; Notes: assumes es:[di] -> urandom request hdr
InitDevice	PROC	NEAR
		mov	ax, 1600h	; Check	if in Windows
; We probably don't need this, but it's	better to be on	the safe side
		int	MltplxSvc
		test	al, al		; if al	!= 0, set Windows flag
		jz	SHORT @InDe0
		or	WORD PTR Flags,	WindowsFlag
@InDe0:

		call	DriverInit

		les	bx, DWORD PTR urh ; es:[bx] -> urandom response	hdr
		lea	dx, EndOfDevice
		mov	WORD PTR es:[bx].ReqHdr.Addr, dx
		mov	WORD PTR es:[bx].ReqHdr.Addr+2,	cs
		jmp	Finished
InitDevice	ENDP


; --------------------------------------------------------------------------
; -----	hook interrupts	and print a small message
;	assumes	al=int,	bx=routine (save oldvec	at bx-4)
Install_Int	PROC	NEAR
		pushf		; save vector number and flags
		xor	ah, ah
		push	ax
		cli		; disable interrupt flag
		push	ax
		push	bx
		mov	ah, 35h	; get interrupt	vector and save	it
		int	DOS
		pop	ax
		xchg	ax, bx
		mov	WORD PTR [bx-2], es
		mov	WORD PTR [bx-4], ax
		mov	dx, bx
		pop	ax
		mov	ah, 25h	; set new vector
		int	DOS
		test	WORD PTR UserOptionFlags, ShowTechieInfo
		jz	SHORT @iiNoTechie
		Printf	<OFFSET	@iitext>
		xor	ax, ax		  ; ax == 0, no	error
		popf			  ; restore flags
		ret
@iiRejected:
		mov	ax, -1		  ; ax == -1, an error occurred
		add	sp, 2		  ; restore stack, flags
		popf
		ret
@iiNoTechie:
		xor	ax, ax
		add	sp, 2		  ; restore stack, flags
		popf
		ret
Install_Int	ENDP

@iitext	LABEL	BYTE
	DB	' %2x',0

; --------------------------------------------------------------------------
; We first want	to set flags for selected options, do any diagnostics later

ShowLicenseFlag	equ 8000h  ; Print GPL when installing
ShowTechieInfo	equ 4000h  ; Show interrupts and other stuff when load
InitPoolFlag	equ 2000h  ; Initialize	entropy	pool when installing

FlagSets PROC NEAR
; /A = enable sampling of Audio	card
@EnableAudio:
  ife __samplaudio
	jmp  @DisabledOption
  else
	and  WORD PTR Flags, (not NoAudioFlag)
	clc
	ret
; <----	Allow user to specify base address of sound card
  endif
; /C = enable sampling of Clock	drift
@EnableDrift:
  ife __sampldrift
	jmp  @DisabledOption
  else
	and  WORD PTR Flags, (not NoDriftFlag)
	clc
	ret
  endif
; /I = Initialize entropy pool with random keystrokes
@InitializeOnInstall:
  ife __sample09
	jmp  @DisabledOption
  else
	or   UserOptionFlags, InitPoolFlag
	mov  SeedCount,	(InitSeedCnt shl FRACBITS)
; <----	Allow user to specify the number of bits to sample?
	clc
	ret
  endif
; /K = Keep entropy pool topped	off after hashing
@EnableKeepFull:
  ife __keepfull
	jmp  @DisabledOption
  else
	and  WORD PTR Flags, (not NoKeepFull)
; <----	Allow user to specify a	QualityThreshold level?
	clc
	ret
  endif
; /L = show License
@ShowLicense:
	or   UserOptionFlags, ShowLicenseFlag
	clc
	ret
; /M = enable sampling of mouse	Movement
@EnableMotion:
  ife __samplmouse
	jmp  @DisabledOption
  else
; <----	Add a check to see if mouse-driver is installed	yet
	and  WORD PTR Flags, (not NoMouseFlag)
	clc
	ret
  endif
;; /V =	Verbose	techie info when loading
;@ShowTechie:
;	 or   UserOptionFlags, ShowTechieInfo
;	 clc
;	 ret
@BadOption:
	Printf <ax OFFSET msgIllegalOption>
	stc
	ret
msgIllegalOption LABEL BYTE
        DB LF, "I do not recognize that option ('%c'). Aborting installation.", CR, LF
	DB "Allowable options are:", CR, LF
  if __samplaudio
	DB " /A",TAB,"enable sampling of Audio card", CR, LF
  endif
  if __sampldrift
	DB " /C",TAB,"enable sampling of Clock drift during idle time",	CR, LF
  endif
  if __sample09
	DB " /I",TAB,"Initialize entropy pool with keystrokes when installing",	CR, LF
  endif
  if __keepfull
        DB " /K",TAB,"Keep entropy pool topped off after hashing", CR, LF
  endif
	DB " /L",TAB,"show License", CR, LF
  if __samplmouse
	DB " /M",TAB,"enable sampling of Mouse movement", CR, LF
  ;; during idle-time or periodic timer
  endif
; I'd just assume display this info anyway...
;;	  DB " /V",TAB,"Verbose	techie info when installing", CR, LF
	DB 0
@DisabledOption:
	Printf <ax OFFSET msgDisabledOption>
	stc
	ret
msgDisabledOption:
	DB LF, "Sorry, that option ('%c') is not available in this build."
	DB CR, LF, 0
FlagSets ENDP
UserOptionFlags	LABEL WORD
  DW ShowTechieInfo
ArgTable LABEL BYTE
  DB 'ACIKLM'
NumArgs	equ $ -	ArgTable
ArgHandlr LABEL	DWORD
  DW @EnableAudio
  DW @EnableDrift
  DW @InitializeOnInstall
  DW @EnableKeepFull
  DW @ShowLicense
  DW @EnableMotion

; --------------------------------------------------------------------------
DoOption PROC	NEAR ; al = character to check
; MS-DOS 5.0 will convert to uppercase from CONFIG.SYS,	but some dyanmic
;   loader utilities will not convert the command line options.
	cmp	al, 'a'
	jb	SHORT @doNotLower
	cmp	al, 'z'
	ja	SHORT @doNotLower
	sub	al, 20h
@doNotLower:
	mov	bx, NumArgs
@doLoop:
	cmp	al, ArgTable[bx]
	je	SHORT @doCheck
	dec	bx
	jns	SHORT @doLoop
	jmp	@BadOption
@doCheck:
	add	bx, bx
	lea	bx, ArgHandlr[bx]
	jmp	[bx]
DoOption ENDP

; --------------------------------------------------------------------------
DriverInit	PROC	NEAR	; Initialize the driver
		Printf	<OFFSET	InitMsg> ; Print header
  if __cpu
		call	TestCPU		  ; Check if CPU is Ok to use
		test	ax, ax
		jz	SHORT CorrectCPU
		ret			  ; if not, return(-1)
  CorrectCPU:
  else
    %out I'd hate to see how slow this runs on an 8088...
  endif

		mov	ah, 2
		int	Keyboard
		test	al, 08h		; is Alt key pressed?
		jz	SHORT @diNAbort
		PrintF	<OFFSET	@dimsgAbortQuery>
		xor	ah, ah
		int	Keyboard
		cmp	al, 27
		jne	SHORT @diNAbort
		mov	ax, -1
		ret
  @dimsgAbortQuery LABEL BYTE
    DB LF, "Press <Esc>	to cancel install,"
    DB	   " or	any other key to continue.", CR, LF, 0
  @diNAbort:

; -----	check for command-line arguments passed	to driver (redone v0.4.3)
		les	di, DWORD PTR es:[di+18]
;@diFirstArg:    mov     al, es:[di]
;                cmp     al, ' '      ; find first space
;                je      SHORT @diArgumentLoop
;                cmp     al, CR       ; end of line?
;                je      SHORT @diArgEOL ; done...
;                inc     di
;                jmp     SHORT @diFirstArg
@diArgumentLoop:
		inc	di	     ; increment pointer
		mov	al, es:[di]  ; get character
		cmp	al, CR	     ; end of line?
		je	SHORT @diArgEOL	; done...
                cmp     al, LF       ; OS/2 DOS boxes sometimes end line w/LF
                je      SHORT @diArgEOL
		cmp	al, '/'	     ; SwitchChar?
		jne	SHORT @diArgumentLoop ;	if not,	continue...
		inc	di	     ; increment
		mov	al, es:[di]  ; get character
		cmp	al, CR	     ; end of line? then ignore...
		je	SHORT @diArgEOL
                cmp     al, LF
                je      SHORT @diArgEOL
		call	DoOption     ; check option, set any flags...
		jnc	SHORT @diArgumentLoop ;	if no error, continue...
		mov	ax, -1	     ; return(-1)
		ret
@diArgEOL:
		test	WORD PTR UserOptionFlags, ShowLicenseFlag
		jz	SHORT @diNoShowLic
		Printf	<OFFSET	LicenseText>
@diNoShowLic:
		test	WORD PTR UserOptionFlags, ShowTechieInfo
		jz	SHORT @diNoTechie
		Printf	<OFFSET	rheader	cs OFFSET StartInstall>
@diNoTechie:
; --------------------------------------------------------------------------
  if  __sample08
;;		  test	  UserOptionFlags, EnablePeriod
;;		  jz	  SHORT	@diNoEnablePeriod
    if	__samplmouse
; ---- Nasty bug: if no	mouse driver is	present, the test for a	mouse driver
;      may still pass, causing the system to crash and burn unpleasantly!
		xor	ax, ax	   ; check if mouse installed (0.3.6)
		int	33h
		test	ax, ax
		jz	SHORT @diMouseDrvInst
		or	Flags, NoMouseFlag
; -----	Print an error message and abort?
;;                jmp     SHORT @diMouseEPE
@diMouseDrvInst:

@diMouseEPE:
    endif
		InstallSampler 8, _timerlatch
;;  @diNoEnablePeriod:
  endif
  if __sample09
		InstallSampler 9, _keysample
  endif
  if __sample13
		InstallSampler 13h, _dsksample
  endif
  if __samplkeys
		InstallSampler Keyboard, _KeyboardHook
  endif
  if __sample28
		InstallSampler 28h, _idlewait
  endif
		InstallSampler MltplxSvc, _MultiplexServ
		Printf	<OFFSET	NewLine>

  if __samplaudio
                test    WORD PTR Flags, NoAudioFlag
                jnz     SHORT @diNoAudioMsg
                Printf  <sbPort OFFSET AudioMsg>
@diNoAudioMsg:
  endif

  if (initseedcnt ne 0)	and (__sample09	ne 0) ;; initialize pool w/keystrks
; --------------------------------------------------------------------------
		mov	ax, WORD PTR SeedCount ; seedcount set to 0?
		test	ax, ax
		jz	SHORT @NoSample
		Printf	<OFFSET	SeedMessage>	 ; if not, sample...
@Seedlings:
		mov	ax, SeedCount	       ; get count
		sub	ax, FreshCount	       ; compate to entropy (v0.4.3)
                js      SHORT @Seeded          ; if count==0, done
  if FRACBITS
		shr	ax, FRACBITS
  endif
		Printf	<ax OFFSET DigitCount> ; output	bits needed
		xor	ah, ah		       ; get keyboard character
		int	Keyboard
  ife __samplkeys
;; Why not add keyboard	scan codes to the pool as well?
		cmp	ax, WORD PTR LastCode  ; ignore	if triplets
		je	SHORT @IgnoreCode
		cmp	ax, WORD PTR LastCode+2
		je	SHORT @IgnoreCode
		shl	DWORD PTR LastCode, 16 ; set last keys pressed
		mov	WORD PTR LastCode, ax
                call    TrackDeltas            ; add code to pool
@IgnoreCode:
  endif
		jmp	SHORT @Seedlings
@Seeded:
		Printf	<OFFSET	OkMessage>
@NoSample:
  endif
		xor	ax, ax	     ; return 0	= ok
		ret
DriverInit	endp

  if initseedcnt
SeedCount LABEL	WORD
    DW	0
LastCode LABEL WORD
    DW	2 DUP (?)
SeedMessage LABEL BYTE
    DB CR, LF
    DB "We are going to seed the entropy pool with some truly random bits by", CR, LF
    DB "timing your keystrokes.  Please type until the counter reaches zero: ", 0
DigitCount LABEL BYTE
    DB "%4d", 4	DUP (BackSpace), 0
OkMessage LABEL	BYTE
    DB 6 DUP (' '), CR, LF, LF, "That's enough. Thank you.", CR, LF, 0
  endif



		include	cpuid.inc    ; TestCPU routine

; --------------------------------------------------------------------------
InitMsg	label byte  ; ----- Initial text messages and other stuff
	db CR, LF
	db drvname, ' v', drvver, ' a random-noise device driver for DOS'
  ifdef	??date
	db ' ',	??date
  endif
	db CR, LF
        db 'by Robert Rothenburg Walking-Owl. Portions by Colin Plumb.'
	db CR, LF, 'Copyright (C) 1995-96, All Rights Reserved.', CR, LF
	db 0
; -----	This section is	for displaying warnings	when debug options enabled
NewLine	LABEL BYTE
  if (NOHASH+NOMIX)
	db  CR,	LF, "WARNING: "
  endif
  if NOHASH
        db "Hashing is disabled. "
  endif
  if NOMIX
	db "Mixing is disabled.	"
  endif
; -----	End warnings -----
	db CR, LF, 0
StartInstall LABEL   BYTE
        DB LF, "Loaded at %4x:%4x "
	DB "Hooking interrupts:", 0
  if __samplaudio
AudioMsg LABEL BYTE
        DB "Using audio card port %x", CR, LF, 0
  endif
; --------------------------------------------------------------------------
LicenseText: ; accidentally used wrong text, fixed v0.3.4
     DB	LF
     DB	'    This program is free software; you	can redistribute it and/or modify', CR,	LF
     DB	'    it	under the terms	of the GNU General Public License as published by', CR,	LF
     DB	'    the Free Software Foundation.', CR, LF
     DB	LF
     DB	'    This program is distributed in the	hope that it will be useful,', CR, LF
     DB	'    but WITHOUT ANY WARRANTY; without even the	implied	warranty of', CR, LF
     DB	'    MERCHANTABILITY or	FITNESS	FOR A PARTICULAR PURPOSE.  See the', CR, LF
     DB	'    GNU General Public	License	for more details.', CR,	LF
     DB	LF
     DB	'    You should	have received a	copy of	the GNU	General	Public License', CR, LF
     DB	'    along with	this program; if not, write to the Free	Software', CR, LF
     DB	'    Foundation, Inc., 675 Mass	Ave, Cambridge,	MA 02139, USA.', CR, LF
     DB	0
