#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pc.h>
#include <keys.h>
#include <ctype.h>
#include "dstypes.h"
/*
 * the file dstypes defines things like un16 is unsigned 16 bit word you
 * folks will have to write you on to match mine not to hard
 */
#define T16L   (65536)
#define EPE    (15)
/*
 * for the truely alert I created a mapping table based on remainder table
 * rtb but I did not use technique described in post since that is slower
 * than molasses on a PC, but the resulting tables are the same. Also not rtb
 * has more bits than needed for a complete mapping but it is a hell of a lot
 * more easier to use
 */
un16            rt[T16L], ft[T16L], bt[T16L];
char            fin[100], fout[100];
void            rem_tab16(un16 *, un16 *, un16 *);
FILE           *fp1, *fp2, *fp3, *fpran;
static un16     qq;
un16            ran[2];
char            ans[4] = "yes";
char           *cp;
int             i, j, k;
int             option = 0;
void            goXexit(void);
void            goKey(void);
void            goEnc(void);
void            goDec(void);
void            getables(void);
void            doEnce(un16 *, un32);
void            doDece(un16 *, un32);
void            Paul(un16 *, un32);

/*
 * 0x1 =set if padding to be used
 * 0x2 =set if ran file can be updated
 * 0x4 =set if pass phrase entered
 * 0x8 =set if keyraw.key exists
 * 0x10=set if keyenc.key exists
 * 0x20=set if keyout.key exists
 * 0x40=set if tables built for doing encryption and decryption
 */

void
main()
{
   for (;;) {
      printf(" Welcome to SCOTT16U encryption decrytption program \n ");
      printf(" Enter K for key creating and maintaining information \n ");
      printf(" Enter E for encryption where 16 bits of random data add to file \n ");
      printf(" Enter D to decrypt a file encrypted with E \n ");
      printf(" Enter EP for encryption where no random data add to file \n ");
      printf(" Enter DP to decrypt a file encrypted with EP \n ");
      printf(" Enter X to exit program \n ");
      scanf(" %2s%*[^\n]s", ans);
      *ans = toupper(*ans);
      *(ans + 1) = toupper(*(ans + 1));
      option &= 0xfe;
      if ((!(option & 0x40)) && ((*ans == 'E') || (*ans == 'D')))
	 getables();
      if (ans[1] != 'P') {
	 if ((option & 0x3) == 0) {
	    if ((fpran = fopen("rankey.key", "rb")) == NULL) {
	       printf("**no rankey file using zero as random data** \n");
	       for (i = 0; i < 2; i++)
		  ran[i] = 0;
	    } else {
	       i = fread((char *) ran, 1, 4, fpran);
	       if (i != 4) {
		  printf("** fatal error on read of file 'rankey.key'** \n");
		  exit(1);
	       }
	       fclose(fpran);
	    }
	 }
	 option |= 0x1;
      }
      if (*ans == 'E')
	 goEnc();
      if (*ans == 'D')
	 goDec();
      if (*ans == 'X')
	 goXexit();
      if (*ans == 'K')
	 goKey();
   }
}

void
goEnc()
{
   char           *p, *p1, *p2;
   un16           *p16;
   void           *pv;
   un32            i, j, k;
   printf(" enter name of file to be Encrypted. \n");
   scanf(" %s%*[^\n]s", fin);
   if ((fp1 = fopen(fin, "rb")) == NULL) {
      printf(" **could not open file %s ** \n", fin);
      return;
   }
   /* get input file into virtual memmory */
   if (fseek(fp1, 0L, 2)) {
      printf("\n **fseek failed in file %s ** \n", fin);
      exit(1);
   }
   j = ftell(fp1);
   if (fseek(fp1, 0L, 0)) {
      printf("\n **fseek failed in file %s ** \n", fin);
      exit(1);
   }
   printf(" input file is %u 0x%x bytes long \n", j, j);
   p = (char *) malloc((size_t) j + 10);
   /*
    * this works even for a 25meg test file on a 486 with 4 megs of memory
    * because the gnu djgpp version of C handles virtual memory
    */
   if (p == NULL) {
      printf(" file to big fatal memory allacation error \n");
      exit(1);
   }
   pv = p + 5;
   p16 = pv;
   p1 = pv;
   i = fread(p1, 1, j, fp1);
   if (i != j) {
      printf(" fatal read on %s\n", fin);
      exit(1);
   }
   fclose(fp1);
   printf(" enter output name of new Encrypted file to be written \n");
   scanf(" %s%*[^\n]s", fout);
   if ((fp2 = fopen(fout, "wb")) == NULL) {
      printf(" **could not open file %s ** \n", fout);
      free(p);
      return;
   }
   if (option & 1 == 1) {
      i += 4;
      p16 -= 2;
      p16[0] = ran[0];
      p16[1] = ran[1];
   }
   doEnce(p16, i);
   if (option & 1 == 1) {
      ran[0] = p16[0];
      ran[1] = p16[1];
      option |= 0x2;
   }
   j = fwrite((char *) p16, 1, i, fp2);
   if (i != j) {
      printf(" fatal write to file %s \n", fout);
      exit(1);
   }
   fclose(fp2);
   free(p);
}
void
goDec()
{
   char           *p, *p1, *p2;
   un16           *p16;
   void           *pv;
   un32            i, j, k;
   printf(" enter name of file to be Decrypted. \n");
   scanf(" %s%*[^\n]s", fin);
   if ((fp1 = fopen(fin, "rb")) == NULL) {
      printf(" **could not open file %s ** \n", fin);
      return;
   }
   /* get input file into virtual memmory */
   if (fseek(fp1, 0L, 2)) {
      printf("\n **fseek failed in file %s ** \n", fin);
      exit(1);
   }
   j = ftell(fp1);
   if (fseek(fp1, 0L, 0)) {
      printf("\n **fseek failed in file %s ** \n", fin);
      exit(1);
   }
   printf(" input file is %u 0x%x bytes long \n", j, j);
   p = (char *) malloc((size_t) j + 10);
   /*
    * this works even for a 25meg test file on a 486 with 4 megs of memory
    * because the gnu djgpp version of C handles virtual memory
    */
   if (p == NULL) {
      printf(" file to big fatal memory allacation error \n");
      exit(1);
   }
   pv = p + 5;
   p16 = pv;
   p1 = pv;
   i = fread(p1, 1, j, fp1);
   if (i != j) {
      printf(" fatal read on %s %u %u\n", fin, i, j);
      exit(1);
   }
   fclose(fp1);

   printf(" enter output name of new Decrypted file to be written \n");
   scanf(" %s%*[^\n]s", fout);
   if ((fp2 = fopen(fout, "wb")) == NULL) {
      printf(" **could not open file %s ** \n", fout);
      free(p);
      return;
   }
   doDece(p16, i);
   if (option & 1 == 1) {
      i -= 4;
      p16 += 2;
   }
   j = fwrite((char *) p16, 1, i, fp2);
   if (i != j) {
      printf(" fatal write to file %s \n", fout);
      exit(1);
   }
   fclose(fp2);
   free(p);
}

void
getables()
{
   int             i, j, k;
   char           *cp, *cp1;
   void           *vp;
   char            ans[3] = "yes";
   FILE           *fpraw, *fpenc, *fpout;
   if (option & 0x4)
      return;
   printf("** working with 128k files so be patient** \n");
   option |= 0x38;
   if (access("keyraw.key", F_OK))
      option ^= 0x8;
   else
      printf(" *note keyraw.key exposed on hard drive* \n");
   if (access("keyenc.key", F_OK))
      option ^= 0x10;
   if (access("keyout.key", F_OK))
      option ^= 0x20;
   else
      printf(" *note keyout.key exposed on hard drive* \n");
   if ((option & 0x18) == 0) {
      printf(" Sorry program needs either a 'keyraw.key' or a 'keyenc.key' file\n");
      printf("  to run. If not sure what to do start with a easy to reproduce\n");
      printf("  file and copy it to 'keyraw.key'.\n");
      printf("  however type in a line of text and it will go to 'keyraw.key'\n");
      printf("  then restart this program to use it.\n");
      if ((fp1 = fopen("keyraw.key", "wb")) == NULL) {
	 printf(" *fatal error trying to open 'keyraw.key'** \n");
	 exit(1);
      }
      vp = rt;
      cp = vp;
      scanf(" %[^\n]s", (char *) rt);
      for (i = 0; i < 2 * T16L; i++)
	 if (*(cp + i) == 0)
	    break;
      j = fwrite((char *) rt, 1, i, fp1);
      if (i != j)
	 printf(" error writing to 'keyraw.key'\n");
      fclose(fp1);
      exit(0);
   }
   if ((option & 0x10) == 0) {
      /* means a 'keyraw.key' exists but a 'keyenc.key' does not */
      for (;;) {
	 printf(" **note the raw 'keyraw.key' on hard drive for some one to steal** \n");
	 printf(" you are using the raw file 'keyraw.key' do you wish to protect it \n");
	 printf("  with a pass phrase y for yes or n for no\n");
	 scanf(" %1s%*[^\n]s", ans);
	 *ans = toupper(*ans);
	 if ((*ans == 'Y') || (*ans == 'N'))
	    break;
      }
      if (*ans == 'N') {
	 /* the 'keyraw.key' is the one being used */
	 if ((fpraw = fopen("keyraw.key", "rb")) == NULL) {
	    printf(" **failed to open 'keyraw.key' fatal error** \n");

	 }
	 i = fread((char *) rt, 1, T16L + T16L, fpraw);
	 if ((i < 1) || (i > (T16L + T16L))) {
	    printf("**failure reading 'keyraw.key' error** \n");
	    exit(0);
	 }
	 cp = (char *) rt;
	 cp1 = cp;
	 for (cp += i, j = 0; j < (2 * T16L - i); j++, cp++)
	    *cp = cp1[j];
	 rem_tab16(rt, ft, bt);
	 option ^= 0x40;
	 fclose(fpraw);
	 return;
	 /* tables built */
      }
      printf(" enter key notice invisible end with enter \n");
      j = 0;
      cp = (char *) rt;
      cp1 = cp;
      for (i = 0; i < (2 * T16L); i++) {
	 k = getkey();
	 if (k == 13)
	    break;
	 j = (un16) ((3 * j) ^ k);
	 *cp++ = k;
      }
      printf(" hex check on phrase=%04hx \n", (un16) j);
      printf("** Make sure you know your hex check word** \n");
      printf(" at this point you have to enter pharse exactly again \n");
      cp = cp1;
      for (j = 0; j < i + 1; j++) {
	 k = getkey();
	 if (k == 13)
	    break;
	 if (*cp++ != (char) k)
	    break;
      }
      if ((i != j) || (k != 13)) {
	 printf(" *string not the same fatal error*\n");
	 exit(1);
      }
      printf(" **wait building tables and updating files** \n");
      cp = cp1;
      for (cp += i, j = 0; j < (2 * T16L - i); j++, cp++)
	 *cp = cp1[j];
      rem_tab16(rt, ft, bt);
      option ^= 0x40;

      if ((fpraw = fopen("keyraw.key", "rb")) == NULL) {
	 printf(" **failed to open 'keyraw.key' fatal error** \n");

      }
      i = fread((char *) rt, 1, T16L + T16L, fpraw);
      if ((i < 1) || (i > (T16L + T16L))) {
	 printf("**failure reading 'keyraw.key' error** \n");
	 exit(0);
      }
      fclose(fpraw);
      cp = cp1;
      for (cp += i, j = 0; j < (2 * T16L - i); j++, cp++)
	 *cp = cp1[j];
      /* write to keyout and encrytpt the file */
      if (!(option & 0x20)) {
	 if ((fpout = fopen("keyout.key", "wb")) == NULL) {
	    printf(" failure to open 'keyout.key' file\n");
	    exit(1);
	 }
	 j = fwrite((char *) rt, 1, i, fpout);
	 if (i != j) {
	    printf(" failure to write to 'keyout.key' file\n");
	    exit(1);
	 }
	 option ^= 0x20;
	 fclose(fpout);
      } else
	 printf(" *no file 'keyout.key' made since it alreayd exists\n");

      for (i = 0; i < T16L; i++)
	 bt[i] = rt[i];

      doEnce(bt, (un32) T16L + T16L);

      if ((fpenc = fopen("keyenc.key", "wb")) == NULL) {
	 printf(" failure to open 'keyenc.key' file\n");
	 exit(1);
      }
      i = fwrite((char *) bt, 1, T16L + T16L, fpenc);
      if (i != 2 * T16L) {
	 printf(" failure to write to 'keyenc.key' file\n");
	 exit(1);
      }
      fclose(fpenc);
      rem_tab16(rt, ft, bt);

      option |= 0x7c;
      return;

      /* tables built */

   }
   /*
    * 'keyenc.key' file exists
    */
   printf(" enter key notice invisible end with enter \n");
   j = 0;
   cp = (char *) rt;
   cp1 = cp;
   for (i = 0; i < (2 * T16L); i++) {
      k = getkey();
      if (k == 13)
	 break;
      j = (un16) ((3 * j) ^ k);
      *cp++ = k;
   }
   printf(" hex check on phrase=%04hx \n", (un16) j);
   cp = cp1;
   for (cp += i, j = 0; j < (2 * T16L - i); j++, cp++)
      *cp = cp1[j];
   printf(" if correct hex check word enter 'y' to go on \n");
   printf(" anything else cause an exit \n");
   scanf(" %2s%*[^\n]s", ans);
   *ans = toupper(*ans);
   if (*ans != 'Y')
      exit(0);
   printf("** wait building tables and such** \n");
   rem_tab16(rt, ft, bt);
   /* get file 'keyenc.key' */

   if ((fpenc = fopen("keyenc.key", "rb")) == NULL) {
      printf(" failure to open 'keyenc.key' file\n");
      exit(1);
   }
   i = fread((char *) rt, 1, T16L + T16L, fpenc);
   if (i != 2 * T16L) {
      printf(" failure to read  'keyenc.key' file\n");
      exit(1);
   }
   fclose(fpenc);
   doDece(rt, (un32) T16L + T16L);
   rem_tab16(rt, ft, bt);
   if ((option & 0x8) && (!(option & 0x20))) {
      if ((fpout = fopen("keyout.key", "wb")) == NULL) {
	 printf(" failure to open 'keyout.key' file\n");
	 exit(1);
      }
      j = fwrite((char *) rt, 1, T16L + T16L, fpout);
      if (j != T16L + T16L) {
	 printf(" failure to write to 'keyout.key' file\n");
	 exit(1);
      }
      option |= 0x20;
      fclose(fpout);
   }
   option |= 0x4;
   /* tables built */
   return;
}


void
goKey()
{
   printf("There are 4 files that are used to control the program. \n");
   printf(" 'keyraw.key' This file contains the raw key that is used to do \n");
   printf("  the encrypting and decrypting. It is really the only one\n");
   printf("  that you need but it must contain something if you use it\n");
   printf("  and if you lose this file you have to recreate it if you \n");
   printf("  want to decrypt your files.\n");
   printf(" 'keyenc.key' This file is all you need to do the encrypting and\n");
   printf("  decrypting but you also need a pass phrase and have to remmber\n");
   printf("  a checksum number to see if pass phrase the same since program\n");
   printf("  does not save or check to see if pass phrase valid.\n");
   printf(" 'keyout.key' This file's only real purpose is to give a friend \n");
   printf("  a copy of your 'keyraw.key' when you only have 'keyenc.key'\n");
   printf("  to create it from your 'keyenc.key' it does this automacally\n");
   printf("  from your 'keyenc.key' when it does not exist and a dummy file\n");
   printf("  called 'keyraw.key' does exist.\n");
   printf(" 'rankey.key' automaically created and updated file for random\n");
   printf("  padding of the encrypted files.\n");
   printf(" **warning messages are printed to screen if 'keyout.key' or \n");
   printf(" 'keyraw.key' exist letting you know they are prime for stealing.\n");
   printf(" HIT RETURN TO CONTINUE\n");
   getkey();
   printf("There is no encoding anywhere to save pass phrase in this program.\n");
   printf("If you have a file 'keyraw.key' but not 'keyenc.key' it will used\n");
   printf(" to encrypt and decrypt you will be asked if you want to protect \n");
   printf(" it with a pass phrase, if you do, you have to enter the pass phrase\n");
   printf(" 2 times and a hex check word is shown. If you like the pass phrase \n");
   printf(" and say yes a file 'keyenc.key' will be written and used for\n");
   printf(" encryption and decryption, but remember the hex check word.\n");
   printf("If you have file 'keyraw.key', 'keyenc.key' but not 'keyout.key'\n");
   printf(" the program will write a normalized file out to 'keyout.key' so \n");
   printf(" this file could be used as 'keyraw.key' since maps to same tables\n");
   printf(" but it will be 128k bytes in length and 'keyraw.key' can be any\n");
   printf(" non zero length. SO if you have a friend it may be easyier to Email\n");
   printf(" the file 'keyraw.key' but you don't have to save this file at all.\n");
   printf(" HIT RETURN TO CONTINUE\n");
   getkey();
   printf("You need either 'keyraw.key' or 'keyenc.key' to run.\n");
   printf("If you want to change pass phase and you only have the 'keyenc.key' you\n");
   printf(" have to cause program to write out the normalized file copy it to\n");
   printf(" 'keyraw.key' and delete 'keyenc.key' and start over, or if it is for\n");
   printf(" own use you can just change the pass phrase and remember new hex word\n");
   printf(" since any change in pass phrase would cause a different key being used.\n");
   printf(" HIT RETURN TO CONTINUE BACK TO MENU\n");
   getkey();
}

void
goXexit()
{
   /* check to see if random used and updated */
   if ((option & 0x2) == 0)
      exit(0);
   if ((fpran = fopen("rankey.key", "wb")) == NULL)
      printf(" Error in trying to up date rankey file\n");
   else if (fwrite(ran, 2, 2, fpran) != 2)
      printf(" Error in writting to rankey file\n");
   printf(" rankey.key updated \n");
   fclose(fpran);
   exit(0);
}

/****************************/
void
rem_tab16(un16 * prtb, un16 * pftb, un16 * pbtb)
{
   /*
    * this code builds the S table for a 16 bit look up table the
    * lookup take with proper choice of remainder values can be one
    * of any complete cycle mappings of the 16 bit wide look up
    * table. since 65536 number of slots zero can map to 65535
    * values  say it maps to x then the mapping of x next it can map
    * to only 65534 values and so on. This means I am using
    * 65535! mappings instead of 65536!  this is still an effective
    * key of over 900,000 bits I have just eliminated the multipy
    * cycle mappings.
    */

   /*
    * input   prtb pointer to remainder table
    * output  pftb pointer to forward lookup table
    * output  pbtb pointer to reverse look up table
    */

   unsigned int    i, j;
   un16           *pt, *pw;
   /* set up pbtb as work table first */
   for (i = 0; i < T16L; i++)
      pbtb[i] = i;
   /* now build lookup table */
   pt = pftb;
   pw = pbtb;
   for (i = T16L - 1; i > 1; i--) {
      *prtb = *prtb % i;
      *pftb = *(++pw + *prtb);	/* forward table */
      *(pw + *prtb++) = *pw;
      pftb = pt + *pftb;
   }
   *pftb = *++pw;
   *(pt + *pftb) = 0;
   /* forward table done */
   /* checking for single cycle while makeing reverse table */
   for (i = pt[0], j = 1; j < T16L; j++) {
      if (i == 0) {
	 printf(" table build FAILURE \n");
	 exit(1);
      }
      pbtb[pt[i]] = i;
      i = pt[i];
   }
   pbtb[pt[0]] = 0;
   if (i != 0) {
      printf(" table BUILD FAILURE\n");
      exit(1);
   }
}


void
doEnce(un16 * a, un32 x)
{
   /* encrypts a file using 16 bit words */
   int             i, j;
   un16           *b, *e;
   un8            *c;
   void           *v;
   if (x < 5) {
      printf(" this method for 5 or more characters only \n");
      exit(1);
   }
   Paul(a, x);
   v = a;
   c = v;
   c = c - 1;
   v = c;
   b = v;			/* b offset 1 byte back from a */
   if ((x % 2) == 1)
      e = b;			/* for end of file odd length */
   else
      e = a;			/* for end of file even case */
   x += 1;
   x = x / 2;
   for (i = 0; i < EPE; i++) {
      b[0] = ft[(un16) ((e[x - 1] ^ a[0]) + a[1])];
      e[x] = b[0];
      b[1] = ft[(un16) ((b[0] ^ a[1]) + a[2])];
      if (e == b)
	 e[1 + x] = b[1];
      for (j = 2; (un32) j < x; j++) {
	 b[j] = ft[(un16) ((b[j - 1] ^ a[j]) + a[j + 1])];
      }
      if (e == a)
	 b[x] = b[0];
   }
   Paul(a, 2 * x);
}
void
doDece(un16 * a, un32 x)
{
   /* decrypts a file using 16 bit words */
   int             i, j;
   un16           *b, *e;
   un8            *c;
   void           *v;
   if (x < 5) {
      printf(" this method for 5 or more characters only \n");
      exit(1);
   }
   Paul(a, x);
   v = a;
   c = v;
   c = c - 1;
   v = c;
   b = v;			/* b offset 1 byte back from a */
   if ((x % 2) == 1)
      e = b;			/* for end of file odd length */
   else
      e = a;			/* for end of file even case */
   x += 1;
   x = x / 2;
   for (i = 0; i < EPE; i++) {
      if (e == b) {
	 a[x - 1] = b[x - 2] ^ (bt[b[x - 1]] - a[0]);
	 a[-1] = a[x - 1];
	 a[x - 2] = b[x - 3] ^ (bt[b[x - 2]] - a[x - 1]);
	 a[-2] = a[x - 2];
      } else {
	 a[x] = a[0];
	 b[0] = b[x];
	 a[x - 1] = b[x - 2] ^ (bt[b[x - 1]] - b[x]);
	 b[-1] = a[x - 1];
	 a[x - 2] = b[x - 3] ^ (bt[b[x - 2]] - a[x - 1]);
      }
      for (j = x - 3; j > -1; j--)
	 a[j] = b[j - 1] ^ (bt[b[j]] - a[j + 1]);
   }
   Paul(a, 2 * x);
}

void
Paul(un16 * a, un32 x)
{
   un16           *i;
   un16            j;
   i = a + (x + 1) / 2;
   /*
    This no tears routine added to defeat Paul Onion style
   of attack. So that a single cycle lookup table secure from
   a choosen plain text type of attack. Note XOR of a 16 bit
   number wiht a constant could be described as a 16 bit lookup
   table composed of only 2 cycle components. The single cycle
   lookup table will not ever decompose to an XOR type of transform
    */
   /*
    I am using a reverse cycle so that one would have to guess
   the entire table to get a constant vaule to first round.
   I am also doing the last round since maybe a reverse plain
   text attack is legal in to days circle of things. That is
   if the choosen enciphered text attack is allowed where
   enemy gives a phone encoded message and looks at the deoded
   results. As before this is for method where the file length
   is not changed. If more security needed or a large number
   of small files in use. USE the method with padding
   */

   for (j = ft[*a] ^ ft[ft[*a]]; --i != a; j = ft[j]) {
      *i ^= j;
   }
}
/*
 * I started at back of file and used ft instead of bt since bt does not
 * always exist and tried to save some memory. The j=ft[*a]^ft[ft[*a]] was
 * done so that the revese cycle would start at different places in cycle
 * less information for some types of attack.
 */
