/*
 *  SecuDE Release 4.3 (GMD)
 */
/********************************************************************
 * Copyright (C) 1994, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "pem.h"

/***************************************************************
 *
 * Procedure aux_free_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_OctetString(
	OctetString	**ostr
)

#else

void aux_free_OctetString(
	ostr
)
OctetString	**ostr;

#endif

{
	char	 * proc = "aux_free_OctetString";

	if (ostr && *ostr) {
		if((*ostr)->octets && (*ostr)->noctets) free((*ostr)->octets);
		(*ostr)->octets = (char *)0;
		(*ostr)->noctets = 0;
		free(*ostr);
		*ostr = NULLOCTETSTRING;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_OctetString
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_OctetString(
	OctetString	 *ostr
)

#else

void aux_free2_OctetString(
	ostr
)
OctetString	 *ostr;

#endif

{
	char	 * proc = "aux_free2_OctetString";

	if (ostr) {
		if(ostr->noctets && ostr->octets) free(ostr->octets);
		ostr->octets = (char *)0;
		ostr->noctets = 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_BitString
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_BitString(
	BitString	**bstr
)

#else

void aux_free_BitString(
	bstr
)
BitString	**bstr;

#endif

{
	char	 * proc = "aux_free_BitString";

	if (bstr && *bstr) {
		if((*bstr)->nbits && (*bstr)->bits) free((*bstr)->bits);
		(*bstr)->bits = (char *)0;
		(*bstr)->nbits = 0;
		free(*bstr);
		*bstr = NULLBITSTRING;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_BitString
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_BitString(
	BitString	 *bstr
)

#else

void aux_free2_BitString(
	bstr
)
BitString	 *bstr;

#endif

{
	char	 * proc = "aux_free2_BitString";

	if (bstr) {
		if(bstr->nbits && bstr->bits) free(bstr->bits);
		bstr->bits = (char *)0;
		bstr->nbits = 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_ObjId(
	ObjId	**oid
)

#else

void aux_free_ObjId(
	oid
)
ObjId	**oid;

#endif

{
	char	 * proc = "aux_free_ObjId";

	if (oid && *oid) {
		if ((*oid)->oid_elements)
			free((*oid)->oid_elements);
		free(*oid), *oid = NULLOBJID;
	}
	return;
}

/***************************************************************
 *
 * Procedure aux_free2_ObjId
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_ObjId(
	ObjId	 *oid
)

#else

void aux_free2_ObjId(
	oid
)
ObjId	 *oid;

#endif

{
	char	 * proc = "aux_free2_ObjId";

	if (oid) {
		if (oid->oid_elements)
			free(oid->oid_elements);
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_KeyInfo(
	register KeyInfo	 *p
)

#else

void aux_free2_KeyInfo(
	p
)
register KeyInfo	 *p;

#endif

{
	char	 * proc = "aux_free2_KeyInfo";

	if (p) {
		if (p->subjectAI)
			aux_free_AlgId(&(p->subjectAI));
		if (p->subjectkey.nbits && p->subjectkey.bits) {
			bzero(p->subjectkey.bits, p->subjectkey.nbits / 8);
			free(p->subjectkey.bits);
			p->subjectkey.bits = (char *)0;
		}
	}
	return;
}

/***************************************************************
 *
 * Procedure aux_free2_Signature
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_Signature(
	register Signature	 *p
)

#else

void aux_free2_Signature(
	p
)
register Signature	 *p;

#endif

{
	char	 * proc = "aux_free2_Signature";

	if (p) {
		if (p->signAI)
			aux_free_AlgId(&(p->signAI));
		if (p->signature.nbits && p->signature.bits) {
			bzero(p->signature.bits, p->signature.nbits / 8);
			free(p->signature.bits);
			p->signature.bits = (char *)0;
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_KeyInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_KeyInfo(
	KeyInfo	**keyinfo
)

#else

void aux_free_KeyInfo(
	keyinfo
)
KeyInfo	**keyinfo;

#endif

{
	char	 * proc = "aux_free_KeyInfo";

	if (keyinfo && *keyinfo) {
		aux_free2_KeyInfo(*keyinfo);
		free(*keyinfo);
		*keyinfo = (KeyInfo * ) 0;
	}
	return;
}

/***************************************************************
 *
 * Procedure aux_free_Signature
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_Signature(
	Signature	**signature
)

#else

void aux_free_Signature(
	signature
)
Signature	**signature;

#endif

{
	char	 * proc = "aux_free_Signature";

	if (signature && *signature) {
		aux_free2_Signature(*signature);
		free(*signature);
		*signature = (Signature * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_DigestInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_DigestInfo(
	register DigestInfo	 *p
)

#else

void aux_free2_DigestInfo(
	p
)
register DigestInfo	 *p;

#endif

{
	char	 * proc = "aux_free2_DigestInfo";

	if (p) {
		if (p->digestAI)
			aux_free_AlgId(&(p->digestAI));
		aux_free2_OctetString(&(p->digest));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_DigestInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_DigestInfo(
	DigestInfo	**digestinfo
)

#else

void aux_free_DigestInfo(
	digestinfo
)
DigestInfo	**digestinfo;

#endif

{
	char	 * proc = "aux_free_DigestInfo";

	if (digestinfo && *digestinfo) {
		aux_free2_DigestInfo(*digestinfo);
		free(*digestinfo);
		*digestinfo = (DigestInfo * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_EncryptedKey
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_EncryptedKey(
	register EncryptedKey	 *enki
)

#else

void aux_free2_EncryptedKey(
	enki
)
register EncryptedKey	 *enki;

#endif

{
	char	 * proc = "aux_free2_EncryptedKey";

	if (enki) {
		if (enki->encryptionAI)
			aux_free_AlgId(&(enki->encryptionAI));
		if (enki->subjectAI)
			aux_free_AlgId(&(enki->subjectAI));
		aux_free2_BitString(&(enki->subjectkey));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_EncryptedKey
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_EncryptedKey(
	EncryptedKey	**enki
)

#else

void aux_free_EncryptedKey(
	enki
)
EncryptedKey	**enki;

#endif

{
	char	 * proc = "aux_free_EncryptedKey";

	if (enki && *enki) {
		aux_free2_EncryptedKey(*enki);
		free(*enki);
		*enki = (EncryptedKey * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_KeyBits(
	KeyBits	**keybits
)

#else

void aux_free_KeyBits(
	keybits
)
KeyBits	**keybits;

#endif

{
	register KeyBits * p;
	char	         * proc = "aux_free_KeyBits";

	if (keybits && (p = *keybits)) {
		aux_free2_OctetString(&(p->part1));
		aux_free2_OctetString(&(p->part2));
		aux_free2_OctetString(&(p->part3));
		aux_free2_OctetString(&(p->part4));
		free(p);
		*keybits = (KeyBits * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_KeyBits
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_KeyBits(
	register KeyBits	 *p
)

#else

void aux_free2_KeyBits(
	p
)
register KeyBits	 *p;

#endif

{
	char	 * proc = "aux_free2_KeyBits";

	if (p) {
		aux_free2_OctetString(&(p->part1));
		aux_free2_OctetString(&(p->part2));
		aux_free2_OctetString(&(p->part3));
		aux_free2_OctetString(&(p->part4));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_AlgId(
	AlgId	**algid
)

#else

void aux_free_AlgId(
	algid
)
AlgId	**algid;

#endif

{
	KeyBits     * kbits;
	OctetString * ostr;
	char	    * proc = "aux_free_AlgId";

	if (algid && *algid) {
		if ((*algid)->param) {
			switch (aux_ObjId2ParmType((*algid)->objid)) {
				case PARM_OctetString:
					ostr = (OctetString * )(*algid)->param;
					aux_free_OctetString(&ostr);
					break;
				case PARM_KeyBits:
					kbits = (KeyBits * )(*algid)->param;
					aux_free_KeyBits(&kbits);
					break;
			}
			(*algid)->param = CNULL;
		}
		if ((*algid)->objid) aux_free_ObjId(&((*algid)->objid));
		free(*algid);
		*algid = NULLALGID;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_PSEToc
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_PSEToc(
	register PSEToc	 *p
)

#else

void aux_free2_PSEToc(
	p
)
register PSEToc	 *p;

#endif

{
	register struct PSE_Objects * o, * o1;
	char	                    * proc = "aux_free2_PSEToc";

	if (p) {
		if (p->owner) free(p->owner);
		if (p->create) free(p->create);
		if (p->update) free(p->update);
		o = p->obj;
		while (o) {
			o1 = o;
			if (o->name) free(o->name);
			if (o->create) free(o->create);
			if (o->update) free(o->update);
			o = o->next;
			free(o1);
		}
	}
	return;
}

/***************************************************************
 *
 * Procedure aux_free2_PSESel
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_PSESel(
	register PSESel	 *p
)

#else

void aux_free2_PSESel(
	p
)
register PSESel	 *p;

#endif

{
	char	 *proc = "aux_free2_PSESel";
	char     *pp;
	Boolean  is_key_pool();

	if (p && is_key_pool(p) == FALSE) {
		if (p->app_name) {
			free(p->app_name);
			p->app_name = CNULL;
		}
		if (p->pin) {

			pp = p->pin;
			while(*pp) *pp++ = '\0';

			free(p->pin);
			p->pin = CNULL;
		}	
		if (p->object.name) {
			free(p->object.name);
			p->object.name = CNULL;
		}
		if (p->object.pin) {

			pp = p->object.pin;
			while(*pp) *pp++ = '\0';

			free(p->object.pin);
			p->object.pin = CNULL;
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_PSEToc
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PSEToc(
	PSEToc	**psetoc
)

#else

void aux_free_PSEToc(
	psetoc
)
PSEToc	**psetoc;

#endif

{
	char	 * proc = "aux_free_PSEToc";

	if (psetoc && *psetoc) {
		aux_free2_PSEToc(*psetoc);
		free(*psetoc);
		*psetoc = (PSEToc * ) 0;
	}
	return;
}

/***************************************************************
 *
 * Procedure aux_free_PSESel
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PSESel(
	PSESel	**psesel
)

#else

void aux_free_PSESel(
	psesel
)
PSESel	**psesel;

#endif

{
	char	 * proc = "aux_free_PSESel";
	Boolean is_key_pool();

	if (psesel && *psesel && is_key_pool(*psesel) == FALSE) {
		aux_free2_PSESel(*psesel);
		if(*psesel) free(*psesel);
		*psesel = (PSESel * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_AlgId
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_AlgId(
	register AlgId	 *algid
)

#else

void aux_free2_AlgId(
	algid
)
register AlgId	 *algid;

#endif

{
	char	 * proc = "aux_free2_AlgId";

	if (algid) {
		if (algid->objid)
			aux_free_ObjId(&(algid->objid));
		if (algid->param)
			free(algid->param);
	}
	return;
}


/***************************************************************
 *
 * Procedure RDName_comp_free
 *
 ***************************************************************/
#ifdef __STDC__

void RDName_comp_free(
	RDName	 *rdn
)

#else

void RDName_comp_free(
	rdn
)
RDName	 *rdn;

#endif

{
	char	 * proc = "RDName_comp_free";

	aux_free_ObjId((ObjId **) & ((rdn->member_IF_0->element_IF_0)) );
	pe_free(rdn->member_IF_0->element_IF_1);
	free ((char *) rdn->member_IF_0);
	free ((char *) rdn);
}


/***************************************************************
 *
 * Procedure aux_free2_RDName
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_RDName(
	RDName	 *rdn
)

#else

void aux_free2_RDName(
	rdn
)
RDName	 *rdn;

#endif

{
	register RDName * eptr;
	register RDName * next;
	char	        * proc = "aux_free2_RDName";

	for (eptr = rdn; eptr != NULLRDNAME; eptr = next) {
		next = eptr->next;
		RDName_comp_free (eptr);
	}
}


/***************************************************************
 *
 * Procedure aux_free_RDName
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_RDName(
	RDName	**rdn
)

#else

void aux_free_RDName(
	rdn
)
RDName	**rdn;

#endif

{
	char	 * proc = "aux_free_RDName";

	if (rdn && * rdn) aux_free2_RDName(* rdn);
	return;
}


/***************************************************************
 *
 * Procedure DName_comp_free
 *
 ***************************************************************/
#ifdef __STDC__

void DName_comp_free(
	DName	 *dn
)

#else

void DName_comp_free(
	dn
)
DName	 *dn;

#endif

{
	char	 * proc = "DName_comp_free";

	aux_free2_RDName (dn->element_IF_2);
}


/***************************************************************
 *
 * Procedure aux_free2_DName
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_DName(
	register DName	 *dn
)

#else

void aux_free2_DName(
	dn
)
register DName	 *dn;

#endif

{
	register DName * eptr;
	register DName * next;
	char	       * proc = "aux_free2_DName";

	for (eptr = dn; eptr != NULLDNAME; eptr = next) {
		next = eptr->next;
		DName_comp_free (eptr);
		free ((char *) eptr);
		eptr = NULLDNAME;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_DName
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_DName(
	DName	**dn
)

#else

void aux_free_DName(
	dn
)
DName	**dn;

#endif

{
	char	 * proc = "aux_free_DName";

	if (dn && *dn) aux_free2_DName(*dn);
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_ToBeSigned
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_ToBeSigned(
	register ToBeSigned	 *tbs
)

#else

void aux_free2_ToBeSigned(
	tbs
)
register ToBeSigned	 *tbs;

#endif

{
	char	 * proc = "aux_free2_ToBeSigned";

	if (tbs) {
		aux_free_AlgId( &(tbs->signatureAI) );
		if (tbs->serialnumber) 
			aux_free_OctetString(&(tbs->serialnumber));
		if (tbs->issuer) 
			aux_free_DName(&(tbs->issuer));
		if (tbs->valid) 
			aux_free_Validity(&(tbs->valid));
		if (tbs->subject) 
			aux_free_DName(&(tbs->subject));
		aux_free_KeyInfo( &(tbs->subjectPK) );
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_ToBeSigned
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_ToBeSigned(
	ToBeSigned	**tbs
)

#else

void aux_free_ToBeSigned(
	tbs
)
ToBeSigned	**tbs;

#endif

{
	char	 * proc = "aux_free_ToBeSigned";

	if (tbs && *tbs) {
		aux_free2_ToBeSigned(*tbs);
		free(*tbs);
		*tbs = (ToBeSigned * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_Certificate(
	register Certificate	 *cert
)

#else

void aux_free2_Certificate(
	cert
)
register Certificate	 *cert;

#endif

{
	char	 * proc = "aux_free2_Certificate";

	if (cert) {
		if (cert->tbs_DERcode) 
			aux_free_OctetString(&(cert->tbs_DERcode));
		aux_free_ToBeSigned(&(cert->tbs));
		if(cert->sig) aux_free_Signature(& ((cert->sig)));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_Certificate
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_Certificate(
	Certificate	**cert
)

#else

void aux_free_Certificate(
	cert
)
Certificate	**cert;

#endif

{
	char	 * proc = "aux_free_Certificate";

	if (cert && *cert) {
		aux_free2_Certificate(*cert);
		free(*cert);
		*cert = (Certificate * ) 0;
	}
	return;
}

/***************************************************************
 *
 * Procedure aux_free_RecpList
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_RecpList(
	RecpList	**recp
)

#else

void aux_free_RecpList(
	recp
)
RecpList	**recp;

#endif

{
	char	 * proc = "aux_free_RecpList";

	if (recp && *recp) {
		aux_free_Certificate(&(*recp)->recpcert);
		aux_free_OctetString(&(*recp)->key);
		aux_free_RecpList(&(*recp)->next);
		free(*recp);
		*recp = (RecpList * ) 0;
	}
	return;
}

/***************************************************************
 *
 * Procedure aux_free2_Key
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_Key(
	register Key	 *key
)

#else

void aux_free2_Key(
	key
)
register Key	 *key;

#endif

{
	char	 * proc = "aux_free2_Key";

	if (key) {
		aux_free_KeyInfo(&(key->key));
		aux_free_PSESel(&(key->pse_sel));
		aux_free_AlgId(&(key->alg));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_PemInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_PemInfo(
	register PemInfo	 *info
)

#else

void aux_free2_PemInfo(
	info
)
register PemInfo	 *info;

#endif

{
	char	 * proc = "aux_free2_PemInfo";

	if (info) {
		aux_free_Key(&(info->encryptKEY));
		aux_free_Certificates( &(info->origcert) );
		aux_free_AlgId( &(info->signAI) );
		aux_free_RecpList( &(info->recplist) );
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_PemInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemInfo(
	PemInfo	**info
)

#else

void aux_free_PemInfo(
	info
)
PemInfo	**info;

#endif

{
	char	 * proc = "aux_free_PemInfo";

	if (info && *info) {
		aux_free2_PemInfo(*info);
		free(*info);
		*info = (PemInfo * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_Key
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_Key(
	Key	**key
)

#else

void aux_free_Key(
	key
)
Key	**key;

#endif

{
	char	 * proc = "aux_free_Key";

	if (key && *key) {
		aux_free2_Key(*key);
		free(*key);
		*key = (Key * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CertificateSet
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CertificateSet(
	SET_OF_Certificate	**certset
)

#else

void aux_free_CertificateSet(
	certset
)
SET_OF_Certificate	**certset;

#endif

{
	SET_OF_Certificate * save_certset;
	char	           * proc = "aux_free_CertificateSet";

	if (certset && *certset) {
		while (*certset) {
			save_certset = *certset;
			*certset = save_certset->next;
			aux_free_Certificate(&(save_certset->element));
			free(save_certset);
			save_certset = (SET_OF_Certificate *)0;
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_CertificatePair(
	register CertificatePair	 *cpair
)

#else

void aux_free2_CertificatePair(
	cpair
)
register CertificatePair	 *cpair;

#endif

{
	char	 * proc = "aux_free2_CertificatePair";

	if (cpair) {
		if (cpair->forward) 
			aux_free_Certificate(&cpair->forward);
		if (cpair->reverse) 
			aux_free_Certificate(&cpair->reverse);
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CertificatePair(
	CertificatePair	**cpair
)

#else

void aux_free_CertificatePair(
	cpair
)
CertificatePair	**cpair;

#endif

{
	char	 * proc = "aux_free_CertificatePair";

	if (cpair && *cpair) {
		aux_free2_CertificatePair(*cpair);
		free(*cpair);
		*cpair = (CertificatePair * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CertificatePairSet
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CertificatePairSet(
	SET_OF_CertificatePair	**cpairset
)

#else

void aux_free_CertificatePairSet(
	cpairset
)
SET_OF_CertificatePair	**cpairset;

#endif

{
	SET_OF_CertificatePair * savecpairset;
	char		       * proc = "aux_free_CertificatePairSet";

	if (cpairset) {
		while (*cpairset) {
			savecpairset = *cpairset;
			*cpairset = savecpairset->next;
			aux_free_CertificatePair(&(savecpairset->element));
			free(savecpairset);
			savecpairset = (SET_OF_CertificatePair *)0;
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CrossCertificates
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CrossCertificates(
	CrossCertificates	**ccerts
)

#else

void aux_free_CrossCertificates(
	ccerts
)
CrossCertificates	**ccerts;

#endif

{
	char	 * proc = "aux_free_CrossCertificates";

	if (ccerts && *ccerts) {
		aux_free2_CrossCertificates(*ccerts);
		free(*ccerts);
		*ccerts = (CrossCertificates * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_CrossCertificates
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_CrossCertificates(
	register CrossCertificates	 *ccerts
)

#else

void aux_free2_CrossCertificates(
	ccerts
)
register CrossCertificates	 *ccerts;

#endif

{
	register CrossCertificates * c, * c1;
	char			   * proc = "aux_free2_CrossCertificates";

	if (ccerts) {
		aux_free_Certificate( &(ccerts->element) );
		c = ccerts->next;
		while (c) {
			c1 = c;
			aux_free_Certificate( &(c->element) );
			c = c->next;
			free(c1);
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_FCPath
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_FCPath(
	FCPath	**path
)

#else

void aux_free_FCPath(
	path
)
FCPath	**path;

#endif

{
	register FCPath * p, * p1;
	char	        * proc = "aux_free_FCPath";

	if (path && *path) {
		aux_free_CrossCertificates( &((*path)->liste) );
		p = (*path)->next_forwardpath;
		while (p) {
			p1 = p;
			aux_free_CrossCertificates( &(p->liste) );
			p = p->next_forwardpath;
			free(p1);
		}
		free(*path);
		*path = (FCPath * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_Certificates
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_Certificates(
	Certificates	**certs
)

#else

void aux_free_Certificates(
	certs
)
Certificates	**certs;

#endif

{
	char	 * proc = "aux_free_Certificates";

	if (certs && *certs) {
		if ( (*certs)->usercertificate )
			aux_free_Certificate( &((*certs)->usercertificate) );
		if ( (*certs)->forwardpath )
			aux_free_FCPath( &((*certs)->forwardpath) );
		free(*certs);
		*certs = (Certificates * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CRLWithCertificates(
	CRLWithCertificates	**crlwithcerts
)

#else

void aux_free_CRLWithCertificates(
	crlwithcerts
)
CRLWithCertificates	**crlwithcerts;

#endif

{
	char	 * proc = "aux_free_CRLWithCertificates";

	if (crlwithcerts && * crlwithcerts) {
		if ( (* crlwithcerts)->crl )
			aux_free_CRL( &((* crlwithcerts)->crl) );
		if ( (* crlwithcerts)->certificates )
			aux_free_Certificates( &((* crlwithcerts)->certificates) );

		free(* crlwithcerts);
		* crlwithcerts = (CRLWithCertificates * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_SET_OF_CRLWithCertificates
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_CRLWithCertificates(
	SET_OF_CRLWithCertificates	**set
)

#else

void aux_free_SET_OF_CRLWithCertificates(
	set
)
SET_OF_CRLWithCertificates	**set;

#endif

{
	SET_OF_CRLWithCertificates * save_set;
	char	               * proc = "aux_free_SET_OF_CRLWithCertificates";

	if (set && *set) {
		while (* set) {
			save_set = * set;
			* set = save_set->next;
			aux_free_CRLWithCertificates(&save_set->element);
			free(save_set);
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CertificationPath
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CertificationPath(
	CertificationPath	**certpath
)

#else

void aux_free_CertificationPath(
	certpath
)
CertificationPath	**certpath;

#endif

{
	char	 * proc = "aux_free_CertificationPath";

	if(certpath && * certpath) {
		if((* certpath)->userCertificate)
			aux_free_Certificate(&((*certpath)->userCertificate));
		if((* certpath)->theCACertificates)
			aux_free_CertificatePairs(&((* certpath)->theCACertificates));

		free(* certpath);
		* certpath = (CertificationPath * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CertificatePairs
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CertificatePairs(
	CertificatePairs	**pairs
)

#else

void aux_free_CertificatePairs(
	pairs
)
CertificatePairs	**pairs;

#endif

{
	char * proc = "aux_free_CertificatePairs";

	if (pairs && * pairs) {
		aux_free_SEQUENCE_OF_CertificatePair(&((* pairs)->liste));
		aux_free_CertificatePairs(&((* pairs)->superior));
	
		free(* pairs);
		* pairs = (CertificatePairs * ) 0;	
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_SEQUENCE_OF_CertificatePair
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SEQUENCE_OF_CertificatePair(
	SEQUENCE_OF_CertificatePair	**seq
)

#else

void aux_free_SEQUENCE_OF_CertificatePair(
	seq
)
SEQUENCE_OF_CertificatePair	**seq;

#endif

{
	register SEQUENCE_OF_CertificatePair * eptr;
	register SEQUENCE_OF_CertificatePair * next;

	char * proc = "aux_free_SEQUENCE_OF_CertificatePair";

	if(seq && * seq){
		for(eptr = * seq; eptr != (SEQUENCE_OF_CertificatePair * )0; eptr = next){
			next = eptr->next;
			aux_free_CertificatePair(&(eptr->element));
			free((char * )eptr);
			eptr = (SEQUENCE_OF_CertificatePair * )0;
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_PKRoot
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PKRoot(
	register PKRoot	**pkroot
)

#else

void aux_free_PKRoot(
	pkroot
)
register PKRoot	**pkroot;

#endif

{
	char	 * proc = "aux_free_PKRoot";

	if (pkroot && *pkroot) {
		if ((*pkroot)->ca)
			aux_free_DName(&((*pkroot)->ca));
		if ((*pkroot)->newkey)
			aux_free_RootInfo(&((*pkroot)->newkey));
		if ((*pkroot)->oldkey)
			aux_free_RootInfo(&((*pkroot)->oldkey));
		free(* pkroot);
		* pkroot = (PKRoot * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_RootInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_RootInfo(
	register Serial	 *rootinfo
)

#else

void aux_free2_RootInfo(
	rootinfo
)
register Serial	 *rootinfo;

#endif

{
	char	 * proc = "aux_free2_RootInfo";

	if (rootinfo) {
		if (rootinfo->serial)
			aux_free_OctetString(&(rootinfo->serial));
		if (rootinfo->key)
			aux_free_KeyInfo(&(rootinfo->key));
		if (rootinfo->valid)
			aux_free_Validity(&(rootinfo->valid));
		if (rootinfo->sig)
			aux_free_KeyInfo((KeyInfo **) &(rootinfo->sig));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_RootInfo
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_RootInfo(
	Serial	**rootinfo
)

#else

void aux_free_RootInfo(
	rootinfo
)
Serial	**rootinfo;

#endif

{
	char	 * proc = "aux_free_RootInfo";

	if (rootinfo && *rootinfo) {
		aux_free2_RootInfo(*rootinfo);
		free(*rootinfo);
		*rootinfo = (Serial * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_PKList
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PKList(
	PKList	**pklist
)

#else

void aux_free_PKList(
	pklist
)
PKList	**pklist;

#endif

{
	register PKList * pkl;
	char	        * proc = "aux_free_PKList";

	if(pklist && *pklist) {
		while (*pklist) {
			pkl = *pklist;
			aux_free2_ToBeSigned(pkl->element);
			*pklist = pkl->next;
			free(pkl);
			pkl = (PKList *)0;
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_error
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_error(
)

#else

void aux_free_error(
)

#endif

{
	register struct ErrStack * err;
	char		         * proc = "aux_free_error";

	while (err_stack) {
		err = err_stack;
		if(err->e_addr) switch (err->e_addrtype) {

			case    char_n:
					free(err->e_addr);
					break;
			case 	Certificate_n:
					aux_free_Certificate((Certificate **) &err->e_addr);
					break;
			case 	CertificatePair_n:
					aux_free_CertificatePair((CertificatePair **) &err->e_addr);
					break;
			case 	Certificates_n:
					aux_free_Certificates((Certificates **) &err->e_addr);
					break;
			case 	PKList_n:
					aux_free_PKList((PKList **) &err->e_addr);
					break;
			case 	OctetString_n:
					aux_free_OctetString((OctetString **) &err->e_addr);
					break;
			case 	BitString_n:
					aux_free_BitString((BitString **) &err->e_addr);
					break;
			case 	SET_OF_Certificate_n:
					aux_free_CertificateSet((SET_OF_Certificate **) &err->e_addr);
					break;
			case 	SET_OF_CertificatePair_n:
					aux_free_CertificatePairSet((SET_OF_CertificatePair **) &err->e_addr);
					break;
			case 	OCList_n:
					aux_free_OCList((OCList **) &err->e_addr);
					break;
			case 	AlgId_n:
					aux_free_AlgId((AlgId **) &err->e_addr);
					break;
			case    PemInfo_n:
					aux_free_PemInfo((PemInfo **) &err->e_addr);
					break;
			case    KeyInfo_n:
					aux_free_KeyInfo((KeyInfo **) &err->e_addr);
					break;
			case 	FCPath_n:
					aux_free_FCPath((FCPath **) &err->e_addr);
					break;
  			case 	PKRoot_n:
					aux_free_PKRoot((PKRoot **) &err->e_addr);
					break;
			case 	ToBeSigned_n:
					aux_free_ToBeSigned((ToBeSigned **) &err->e_addr);
					break;
			case 	ObjId_n:
					aux_free_ObjId((ObjId **) &err->e_addr);
					break;
			case 	KeyBits_n:
					aux_free_KeyBits((KeyBits **) &err->e_addr);
					break;
			case 	PSEToc_n:
					aux_free_PSEToc((PSEToc **) &err->e_addr);
					break;
			case 	PSESel_n:
					aux_free_PSESel((PSESel **) &err->e_addr);
					break;
		}
		if(err->e_text) free(err->e_text);
		err_stack = err->next;
		free(err);
	}
	err_malloc.e_number = 0;
	err_malloc.e_text = CNULL;
	err_malloc.e_addr = CNULL;
	err_malloc.e_proc = CNULL;
	err_malloc.next = (struct ErrStack * ) 0;
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_Crl
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_Crl(
	register Crl	 *crlpse
)

#else

void aux_free2_Crl(
	crlpse
)
register Crl	 *crlpse;

#endif

{
	char	   * proc = "aux_free2_Crl";

	if (crlpse) {
		if (crlpse->issuer) 
			aux_free_DName(&(crlpse->issuer));
		if (crlpse->nextUpdate) 
			free (crlpse->nextUpdate);
		if(crlpse->revcerts)
			aux_free_SEQUENCE_OF_CRLEntry(&(crlpse->revcerts));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_Crl
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_Crl(
	Crl	**crlpse
)

#else

void aux_free_Crl(
	crlpse
)
Crl	**crlpse;

#endif

{
	char	 * proc = "aux_free_Crl";

	if (crlpse && *crlpse) {
		aux_free2_Crl(*crlpse);
		free(*crlpse);
		*crlpse = (Crl * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CrlSet
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CrlSet(
	CrlSet	**crlset
)

#else

void aux_free_CrlSet(
	crlset
)
CrlSet	**crlset;

#endif

{
	CrlSet     * save_crlset;
	char	   * proc = "aux_free_CrlSet";

	if (crlset) {
		while (*crlset) {
			save_crlset = *crlset;
			*crlset = save_crlset->next;
			aux_free_Crl(&save_crlset->element);
			free(save_crlset);
			save_crlset = (CrlSet *)0;
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_CRLEntry(
	register CRLEntry	 *crlentry
)

#else

void aux_free2_CRLEntry(
	crlentry
)
register CRLEntry	 *crlentry;

#endif

{
	char	 * proc = "aux_free2_CRLEntry";

	if (crlentry) {
		if (crlentry->revocationDate)
			free(crlentry->revocationDate);
		if (crlentry->serialnumber)
			aux_free_OctetString(&(crlentry->serialnumber));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CRLEntry(
	CRLEntry	**crlentry
)

#else

void aux_free_CRLEntry(
	crlentry
)
CRLEntry	**crlentry;

#endif

{
	char	 * proc = "aux_free_CRLEntry";

	if (crlentry && *crlentry) {
		aux_free2_CRLEntry(*crlentry);
		free(*crlentry);
		*crlentry = (CRLEntry * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_SEQUENCE_OF_CRLEntry
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SEQUENCE_OF_CRLEntry(
	SEQUENCE_OF_CRLEntry	**seq
)

#else

void aux_free_SEQUENCE_OF_CRLEntry(
	seq
)
SEQUENCE_OF_CRLEntry	**seq;

#endif

{
	SEQUENCE_OF_CRLEntry  * save_seq;
	char	 		* proc = "aux_free_SEQUENCE_OF_CRLEntry";

	if (seq) {
		while (*seq) {
			save_seq = *seq;
			*seq = save_seq->next;
			aux_free_CRLEntry(&(save_seq->element));
			free(save_seq);
			save_seq = (SEQUENCE_OF_CRLEntry *)0;
		}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_CRLTBS
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_CRLTBS(
	register CRLTBS	 *tbs
)

#else

void aux_free2_CRLTBS(
	tbs
)
register CRLTBS	 *tbs;

#endif

{
	char	 * proc = "aux_free2_CRLTBS";

	if (tbs) {
		if(tbs->signatureAI)
			aux_free_AlgId(&(tbs->signatureAI));
		if (tbs->issuer)
			aux_free_DName(&(tbs->issuer));
		if (tbs->lastUpdate)
			free(tbs->lastUpdate);
		if (tbs->nextUpdate)
			free(tbs->nextUpdate);
		if (tbs->revokedCertificates)
			aux_free_SEQUENCE_OF_CRLEntry( &(tbs->revokedCertificates) );
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CRLTBS
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CRLTBS(
	CRLTBS	**tbs
)

#else

void aux_free_CRLTBS(
	tbs
)
CRLTBS	**tbs;

#endif

{
	char	 * proc = "aux_free_CRLTBS";

	if (tbs && *tbs) {
		aux_free2_CRLTBS(*tbs);
		free(*tbs);
		*tbs = (CRLTBS * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_CRL
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_CRL(
	register CRL	 *crl
)

#else

void aux_free2_CRL(
	crl
)
register CRL	 *crl;

#endif

{
	char	 * proc = "aux_free2_CRL";

	if (crl) {
		/*if (crl->tbs_DERcode)
		    aux_free_OctetString( &(crl->tbs_DERcode) );*/
		aux_free_CRLTBS( &(crl->tbs) );
		aux_free_KeyInfo((KeyInfo **) & ((crl->sig)) );
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_CRL
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_CRL(
	CRL	**crl
)

#else

void aux_free_CRL(
	crl
)
CRL	**crl;

#endif

{
	char	 * proc = "aux_free_CRL";

	if (crl && *crl) {
		aux_free2_CRL(*crl);
		free(*crl);
		*crl = (CRL * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_OCList
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_OCList(
	OCList	**ocl
)

#else

void aux_free_OCList(
	ocl
)
OCList	**ocl;

#endif

{
	char	 * proc = "aux_free_OCList";

	OCList *saveocl;

	if (ocl) {
		while (*ocl) {
			saveocl = *ocl;
			*ocl = saveocl->next;
			if(saveocl->ccert)
				aux_free_Certificate(&(saveocl->ccert));
			if(saveocl->serialnumber)
				aux_free_OctetString(&(saveocl->serialnumber));
			free(saveocl);
			saveocl = (OCList *)0;
			}
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_IssuedCertificate(
	register IssuedCertificate	 *isscert
)

#else

void aux_free2_IssuedCertificate(
	isscert
)
register IssuedCertificate	 *isscert;

#endif

{
	char	 * proc = "aux_free2_IssuedCertificate";

	if (isscert) {
		if (isscert->date_of_issue)
			free(isscert->date_of_issue);
		if (isscert->serial)
			aux_free_OctetString(&(isscert->serial));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_IssuedCertificate(
	IssuedCertificate	**isscert
)

#else

void aux_free_IssuedCertificate(
	isscert
)
IssuedCertificate	**isscert;

#endif

{
	if (isscert && *isscert) {
		aux_free2_IssuedCertificate(*isscert);
		free(*isscert);
		*isscert = (IssuedCertificate * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_SET_OF_IssuedCertificate
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_IssuedCertificate(
	SET_OF_IssuedCertificate	**isscertset
)

#else

void aux_free_SET_OF_IssuedCertificate(
	isscertset
)
SET_OF_IssuedCertificate	**isscertset;

#endif

{
	SET_OF_IssuedCertificate * save_isscertset;
	if (isscertset) {
		while (*isscertset) {
			save_isscertset = *isscertset;
			*isscertset = save_isscertset->next;
			aux_free_IssuedCertificate(&save_isscertset->element);
			free(save_isscertset);
			save_isscertset = (SET_OF_IssuedCertificate *)0;
		}
	}
	return;
}



/***************************************************************
 *
 * Procedure aux_free_VerificationStep
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_VerificationStep(
	VerificationStep	**verstep
)

#else

void aux_free_VerificationStep(
	verstep
)
VerificationStep	**verstep;

#endif

{
	char	 * proc = "aux_free_VerificationStep";

	if (verstep && * verstep) {
		if ( (* verstep)->cert )
			aux_free_Certificate(&((* verstep)->cert));
		if ( (* verstep)->date )
			free((* verstep)->date);
		if ( (* verstep)->valid )
			aux_free_Validity(&((* verstep)->valid));
		free(* verstep);
		* verstep = (VerificationStep * ) 0;
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free2_VerificationResult
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_VerificationResult(
	register VerificationResult	 *verres
)

#else

void aux_free2_VerificationResult(
	verres
)
register VerificationResult	 *verres;

#endif

{
	int	   index = 0;
	char	 * proc = "aux_free2_VerificationResult";

	if (verres) {
		if (verres->verifstep) {
			while ((verres->verifstep)[index]) {	
				aux_free_VerificationStep(&((verres->verifstep)[index]));
				index++;
			}
			free(verres->verifstep);
		}
		if(verres->top_name) 
			free(verres->top_name);
		if(verres->valid) 
			aux_free_Validity(&verres->valid);
		if(verres->top_serial) 
			aux_free_OctetString(&(verres->top_serial));
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_VerificationResult
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_VerificationResult(
	VerificationResult	**verres
)

#else

void aux_free_VerificationResult(
	verres
)
VerificationResult	**verres;

#endif

{
	char  * proc = "aux_free_VerificationResult";

	if (verres && *verres) {
		aux_free2_VerificationResult(*verres);
		free(*verres);
		*verres = (VerificationResult * ) 0;
	}
	return;
}



/***************************************************************
 *
 * Procedure aux_free2_Validity
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free2_Validity(
	register Validity	 *valid
)

#else

void aux_free2_Validity(
	valid
)
register Validity	 *valid;

#endif

{
	char	 * proc = "aux_free2_Validity";

	if (valid) {
		if (valid->notbefore) 
			free (valid->notbefore);
		if (valid->notafter) 
			free (valid->notafter);
	}
	return;
}


/***************************************************************
 *
 * Procedure aux_free_Validity
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_Validity(
	Validity	**valid
)

#else

void aux_free_Validity(
	valid
)
Validity	**valid;

#endif

{
	char	 * proc = "aux_free_Validity";

	if (valid && *valid) {
		aux_free2_Validity(*valid);
		free(*valid);
		*valid = (Validity * ) 0;
	}
	return;
}



/***************************************************************
 *
 * Procedure aux_free_SET_OF_PemMessageCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_PemMessageCanon(
	SET_OF_PemMessageCanon	**obj
)

#else

void aux_free_SET_OF_PemMessageCanon(
	obj
)
SET_OF_PemMessageCanon	**obj;

#endif

{
	SET_OF_PemMessageCanon *obj2;
	if(obj) 
	while(*obj){
		aux_free_PemMessageCanon(&((*obj)->element));
		obj2 = *obj;
		*obj = (*obj)->next;
		free(obj2);
	}
}


/***************************************************************
 *
 * Procedure aux_free_PemMessageCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemMessageCanon(
	PemMessageCanon	**obj
)

#else

void aux_free_PemMessageCanon(
	obj
)
PemMessageCanon	**obj;

#endif

{
	if(obj && *obj) {
		aux_free_PemHeaderCanon(&((*obj)->header));
		if((*obj)->body) 	free((*obj)->body);

		free(*obj);
		*obj = (PemMessageCanon *)0;
	}
}
/***************************************************************
 *
 * Procedure aux_free_PemHeaderCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemHeaderCanon(
	PemHeaderCanon	**obj
)

#else

void aux_free_PemHeaderCanon(
	obj
)
PemHeaderCanon	**obj;

#endif

{
	if(obj && *obj) {
		if((*obj)->rfc_version) 	free((*obj)->rfc_version);
		if((*obj)->proctype) 	free((*obj)->proctype);
		if((*obj)->content_domain) 	free((*obj)->content_domain);
		aux_free_PemDekCanon(&((*obj)->dek_fields));
		aux_free_PemOriginatorCanon(&((*obj)->orig_fields));
		aux_free_SET_OF_Name(&((*obj)->issuer_fields));
		aux_free_PemMicCanon(&((*obj)->mic_fields));
		aux_free_SET_OF_PemCrlCanon(&((*obj)->crl_fields));
		aux_free_SET_OF_Name(&((*obj)->crl_rr_fields));

		free(*obj);
		*obj = (PemHeaderCanon *)0;
	}
}

/***************************************************************
 *
 * Procedure aux_free_PemDekCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemDekCanon(
	PemDekCanon	**obj
)

#else

void aux_free_PemDekCanon(
	obj
)
PemDekCanon	**obj;

#endif

{
	if(obj && *obj) {
		if((*obj)->dekinfo_enc_alg) 	free((*obj)->dekinfo_enc_alg);
		if((*obj)->dekinfo_param) 	free((*obj)->dekinfo_param);
		if((*obj)->keyinfo_enc_alg) 	free((*obj)->keyinfo_enc_alg);
		if((*obj)->keyinfo_dek) 	free((*obj)->keyinfo_dek);
		aux_free_SET_OF_PemRecCanon(&((*obj)->recipients));
		free(*obj);
		*obj = (PemDekCanon *)0;
	}
}
/***************************************************************
 *
 * Procedure aux_free_SET_OF_PemRecCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_PemRecCanon(
	SET_OF_PemRecCanon	**obj
)

#else

void aux_free_SET_OF_PemRecCanon(
	obj
)
SET_OF_PemRecCanon	**obj;

#endif

{
	SET_OF_PemRecCanon *obj2;
	if(obj) 
	while(*obj){
		aux_free_PemRecCanon(&((*obj)->element));
		obj2 = *obj;
		*obj = (*obj)->next;
		free(obj2);
	}
}
/***************************************************************
 *
 * Procedure aux_free_SET_OF_PemCrlCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_PemCrlCanon(
	SET_OF_PemCrlCanon	**obj
)

#else

void aux_free_SET_OF_PemCrlCanon(
	obj
)
SET_OF_PemCrlCanon	**obj;

#endif

{
	SET_OF_PemCrlCanon *obj2;
	if(obj) 
	while(*obj){
		aux_free_PemCrlCanon(&((*obj)->element));
		obj2 = *obj;
		*obj = (*obj)->next;
		free(obj2);
	}
}
/***************************************************************
 *
 * Procedure aux_free_SET_OF_Name
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_Name(
	SET_OF_Name	**obj
)

#else

void aux_free_SET_OF_Name(
	obj
)
SET_OF_Name	**obj;

#endif

{
	SET_OF_Name *obj2;
	if(obj) 
	while(*obj){
		if((*obj)->element) 	free((*obj)->element);
		obj2 = *obj;
		*obj = (*obj)->next;
		free(obj2);
	}
}

/***************************************************************
 *
 * Procedure aux_free_PemRecCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemRecCanon(
	PemRecCanon	**obj
)

#else

void aux_free_PemRecCanon(
	obj
)
PemRecCanon	**obj;

#endif

{
	if(obj && *obj) {
		if((*obj)->enc_alg) 	free((*obj)->enc_alg);
		if((*obj)->dek) 	free((*obj)->dek);
		if((*obj)->issuer) 	free((*obj)->issuer);
		if((*obj)->serialnumber) 	free((*obj)->serialnumber);
		free(*obj);
		*obj = (PemRecCanon *)0;
	}
}

/***************************************************************
 *
 * Procedure aux_free_PemOriginatorCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemOriginatorCanon(
	PemOriginatorCanon	**obj
)

#else

void aux_free_PemOriginatorCanon(
	obj
)
PemOriginatorCanon	**obj;

#endif

{
	if(obj && *obj) {
		if((*obj)->certificate) 	free((*obj)->certificate);
		if((*obj)->issuer) 	free((*obj)->issuer);
		if((*obj)->serialnumber) 	free((*obj)->serialnumber);
		free(*obj);
		*obj = (PemOriginatorCanon *)0;
	}
}

/***************************************************************
 *
 * Procedure aux_free_PemMicCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemMicCanon(
	PemMicCanon	**obj
)

#else

void aux_free_PemMicCanon(
	obj
)
PemMicCanon	**obj;

#endif

{
	if(obj && *obj) {
		if((*obj)->mic_alg) 	free((*obj)->mic_alg);
		if((*obj)->micenc_alg) 	free((*obj)->micenc_alg);
		if((*obj)->mic) 	free((*obj)->mic);
		free(*obj);
		*obj = (PemMicCanon *)0;
	}
}

/***************************************************************
 *
 * Procedure aux_free_PemCrlCanon
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemCrlCanon(
	PemCrlCanon	**obj
)

#else

void aux_free_PemCrlCanon(
	obj
)
PemCrlCanon	**obj;

#endif

{
	if(obj && *obj) {
		if((*obj)->crl) 	free((*obj)->crl);
		if((*obj)->certificate) 	free((*obj)->certificate);
		aux_free_SET_OF_Name(&((*obj)->issuer_certificate));
		free(*obj);
		*obj = (PemCrlCanon *)0;
	}
}

/***************************************************************
 *
 * Procedure aux_free_PemHeaderLocal
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemHeaderLocal(
	PemHeaderLocal	**obj
)

#else

void aux_free_PemHeaderLocal(
	obj
)
PemHeaderLocal	**obj;

#endif

{
	if(obj && *obj) {
		aux_free_PemDekLocal(&((*obj)->dek_fields));
		aux_free_Certificates(&((*obj)->certificates));
		aux_free_Certificate(&((*obj)->root_certificate));
		aux_free_PemMicLocal(&((*obj)->mic_fields));
		aux_free_SET_OF_CRLWithCertificates(&((*obj)->crl_fields));
		aux_free_SET_OF_DName(&((*obj)->crl_rr_fields));

		free(*obj);
		*obj = (PemHeaderLocal *)0;
	}
}

/***************************************************************
 *
 * Procedure aux_free_PemDekLocal
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemDekLocal(
	PemDekLocal	**obj
)

#else

void aux_free_PemDekLocal(
	obj
)
PemDekLocal	**obj;

#endif

{
	if(obj && *obj) {
		aux_free_AlgId(&((*obj)->dekinfo_enc_alg));
		aux_free_AlgId(&((*obj)->keyinfo_enc_alg));
		aux_free_BitString(&((*obj)->keyinfo_dek));
		aux_free_SET_OF_PemRecLocal(&((*obj)->recipients));

		free(*obj);
		*obj = (PemDekLocal *)0;
	}
}

/***************************************************************
 *
 * Procedure aux_free_PemMicLocal
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemMicLocal(
	PemMicLocal	**obj
)

#else

void aux_free_PemMicLocal(
	obj
)
PemMicLocal	**obj;

#endif

{
	if(obj && *obj) {
		aux_free_AlgId(&((*obj)->signAI));
		aux_free_BitString(&((*obj)->mic));

		free(*obj);
		*obj = (PemMicLocal *)0;
	}
}


/***************************************************************
 *
 * Procedure aux_free_SET_OF_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_PemRecLocal(
	SET_OF_PemRecLocal	**obj
)

#else

void aux_free_SET_OF_PemRecLocal(
	obj
)
SET_OF_PemRecLocal	**obj;

#endif

{
	SET_OF_PemRecLocal *obj2;
	if(obj) 
	while(*obj){
		aux_free_PemRecLocal(&((*obj)->element));
		obj2 = *obj;
		*obj = (*obj)->next;
		free(obj2);
	}
}
/***************************************************************
 *
 * Procedure aux_free_SET_OF_DName
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_DName(
	SET_OF_DName	**obj
)

#else

void aux_free_SET_OF_DName(
	obj
)
SET_OF_DName	**obj;

#endif

{
	SET_OF_DName *obj2;
	if(obj) 
	while(*obj){
		aux_free_DName(&((*obj)->element));
		obj2 = *obj;
		*obj = (*obj)->next;
		free(obj2);
	}
}
/***************************************************************
 *
 * Procedure aux_free_NAME
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_NAME(
	NAME	**obj
)

#else

void aux_free_NAME(
	obj
)
NAME	**obj;

#endif

{
	if(obj && *obj) {
		if((*obj)->alias) 	free((*obj)->alias);
		if((*obj)->name) 	free((*obj)->name);
		if((*obj)->dname) 	free((*obj)->dname);
		free(*obj);
		*obj = (NAME *)0;
	}
}
/***************************************************************
 *
 * Procedure aux_free_SET_OF_NAME
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_NAME(
	SET_OF_NAME	**obj
)

#else

void aux_free_SET_OF_NAME(
	obj
)
SET_OF_NAME	**obj;

#endif

{
	SET_OF_NAME *obj2;
	if(obj) 
	while(*obj){
		aux_free_NAME(&((*obj)->element));
		obj2 = *obj;
		*obj = (*obj)->next;
		free(obj2);
	}
}
/***************************************************************
 *
 * Procedure aux_free_SET_OF_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_SET_OF_PemMessageLocal(
	SET_OF_PemMessageLocal	**obj
)

#else

void aux_free_SET_OF_PemMessageLocal(
	obj
)
SET_OF_PemMessageLocal	**obj;

#endif

{
	SET_OF_PemMessageLocal *obj2;
	if(obj) 
	while(*obj){
		aux_free_PemMessageLocal(&((*obj)->element));
		obj2 = *obj;
		*obj = (*obj)->next;
		free(obj2);
	}
}
/***************************************************************
 *
 * Procedure aux_free_PemMessageLocal
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemMessageLocal(
	PemMessageLocal	**obj
)

#else

void aux_free_PemMessageLocal(
	obj
)
PemMessageLocal	**obj;

#endif

{
	if(obj && *obj) {
		aux_free_PemHeaderLocal(&((*obj)->header));
		aux_free_OctetString(&((*obj)->body));
		aux_free_VerificationResult(&((*obj)->validation_result));
		if((*obj)->comment) {
			free((*obj)->comment);
			(*obj)->comment = CNULL;
		}
		if((*obj)->error) {
			free((*obj)->error);
			(*obj)->error = CNULL;
		}

		free(*obj);
		*obj = (PemMessageLocal *)0;
	}
}
/***************************************************************
 *
 * Procedure aux_free_PemRecLocal
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_PemRecLocal(
	PemRecLocal	**obj
)

#else

void aux_free_PemRecLocal(
	obj
)
PemRecLocal	**obj;

#endif

{
	if(obj && *obj) {
		aux_free_AlgId(&((*obj)->enc_alg));
		aux_free_BitString(&((*obj)->dek));
		aux_free_Certificate(&((*obj)->certificate));

		free(*obj);
		*obj = (PemRecLocal *)0;
	}
}


/*
 *	free temporary alias list, e.g. returned by e_AliasList(),
 *	that cannot be accessed by alias maintenance functions
 */

/***************************************************************
 *
 * Procedure aux_free_AliasList
 *
 ***************************************************************/
#ifdef __STDC__

void aux_free_AliasList(
	AliasList	**alist
)

#else

void aux_free_AliasList(
	alist
)
AliasList	**alist;

#endif

{

	register Aliases *aliasmember, *am;
	register AliasList *aa, *bb;
	char	*proc = "aux_free_AliasList";

        
        /*
         *  free alist
         */

        if(!alist || ! *alist) return;
        aa = *alist;
        while (aa) {
                aliasmember = aa->a;
                while (aliasmember) {
                        free(aliasmember->aname);
                        am = aliasmember->next;
                        free(aliasmember);
                        aliasmember = am;
                }
                free(aa->dname);
                bb = aa->next;
                free(aa);
                aa = bb;
        }
	*alist = (AliasList *) 0;
}



