/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef	_BBUF_
#define	_BBUF_

#define NULLBB		(struct bbuf *)0

#define INNER 0x01		/* inner sig_alg (within tobesigned) */
#define OUTER 0x02		/* outer sig_alg (within data) */

/*
 * There are two cases that determine whether a certificate is valid.
 *
 * 1. If the status field has only the BNOTOK bit set, meaning all other
 *    bits are off, then the certificate is valid.
 *
 * 2. If the BNOTOK bit is off, then the certificate is valid by
 *    declaration, irrespective of any other bit setting.
 */
#define CERTOK(s)	(((s) == BNOTOK || ! ((s) & BNOTOK)) ? OK : NOTOK)

#define FREE_BBUF(x)	if ((x) != NULLBB) { \
			    (void) free_bbuf(x); \
			    (x) = NULLBB; \
			} \
			else

#define FREE_BBUFS(x)	if ((x) != NULLBB) { \
			    (void) free_bbufs(x); \
			    (x) = NULLBB; \
			} \
			else

struct bbuf {
    short length;		/* number of octets in data */
    short blength;		/* no. of unused leading bits in first octet */
    short status;		/* return code */

    unsigned char *data;	/* octet sequence */

    struct bbuf *next;
    struct bbuf *prev;
};

extern struct bbuf *alloc_bbuf(), *bbufcat(), *dup_bbuf(), *hex2bin();

#endif	/* not _BBUF_ */
