/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef	_CERT_
#define _CERT_

#include "algid.h"
#include "bbuf.h"

struct valid {
    long begin;			/* begin validity in UTC time */
    long end;			/* end validity in UTC time */
};

struct tobesigned {
    int version;		/* version number */

#define VERSION_DEFAULT_1988	0

    struct bbuf  *serial;	/* serial number */
    struct algid *sig_alg;	/* inner signature algorithm */
    struct bbuf  *issuer;	/* issuer name */
    struct valid *valid;	/* validity period */
    struct bbuf  *subject;	/* subject name */
    struct bbuf  *public;	/* public key */
};

struct certificate {
    struct tobesigned *tobesigned; /* certificate */
    struct algid      *sig_alg;	   /* outer signature algorithm */
    struct bbuf       *sig;	   /* signature */
    int               status;	   /* status of this certificate */
};

#define NULL_CERT		(struct certificate *)0
#define NULL_TOBESIGNED		(struct tobesigned *)0
#define NULL_VALID		(struct valid *)0

#define FREE_CERT(x)     	if ((x) != NULL_CERT) { \
				    (void) free_cert(x); \
				    (x) = NULL_CERT; \
				} \
				else

#define FREE_TOBESIGNED(x)	if ((x) != NULL_TOBESIGNED) { \
				    (void) free_tobesigned_cert(x); \
				    (x) = NULL_TOBESIGNED; \
				} \
				else

#define FREE_VALID(x)		if ((x) != NULL_VALID) { \
				    (void) free_valid_cert(x); \
				    (x) = NULL_VALID; \
				} \
				else

/* functions with non-integer return values */

extern struct bbuf		*make_isnkey();
extern struct certificate	*dup_cert(), *dup_certs();
extern struct tobesigned	*alloc_tobesigned_cert(),
				*dup_tobesigned_cert();
extern struct valid		*alloc_valid_cert(), *dup_valid_cert();

#endif	/* not _CERT_ */
