/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef	_CONFIG_
#define	_CONFIG_

#define PACKAGE         moss_package()
#define VERSION		moss_version()
#define COPYRIGHT	moss_copyright()

/* Categorize the OS as System V or Berkeley derived.
 * In addition define any operating specific patches
 */

/* Sun Systems */

#ifdef	SUNOS4
#ifndef	BSD43
#define BSD43
#endif	/* not BSD43 */
#include <fcntl.h>
#endif	/* SUNOS4 */

#ifdef	SUNOS3
#ifndef	BSD42
#define	BSD42
#endif	/* not BSD42 */
#endif	/* SUNOS3 */


/* OSF/1 on 80x86 */

#ifdef  OSF1
#include <fcntl.h>
#define _BSD_
#endif  /* OSF1 */


/* Berkeley Systems */

#ifdef	BSD43
#ifndef	BSD42
#define	BSD42
#endif	/* not BSD42 */
#endif	/* BSD43 */

#ifdef	BSD42
#include <sys/time.h>
#ifndef	_BSD_
#define	_BSD_
#endif	/* not _BSD_ */
#else	/* not BSD42 */
#include <time.h>
#endif	/* BSD42 */


/* NeXT Systems */

#ifdef	NeXT
#ifndef	MACH
#define	MACH
#endif	/* not MACH */
#endif	/* NeXT */


/* SYS5 Systems */

#ifdef	SYS5
#ifndef	_SYS5_
#define	_SYS5_
#endif	/* not _SYS5_ */
#endif	/* SYS5 */


/* MACH (on NeXT) */

#ifdef	MACH

#define	const
#define	volatile

#include <sys/malloc.h>
#include <libc.h>

#ifndef	_BSD_
#define	_BSD_
#endif	/* not _BSD_ */

#endif	/* MACH */


/* MSDOS */

#ifdef DOS
#ifndef _BSD_
#define _BSD_
#endif
#ifndef PC
#define PC
#endif
#endif


/* Machintosh */

#ifdef _MAC_
#ifndef PC 
#define PC
#endif
#endif

/* Things needed for Berkeley derived systems in general */

#ifdef	_BSD_

/* MACH/MAC/DOS peculiarities */

#ifndef	MACH
#ifndef _MAC_
#include <malloc.h>
#ifndef DOS
extern char *calloc();
#endif  /* DOS */
#endif  /* _MAC_ */
#endif	/* not MACH */

#ifndef _MAC_
#include <sys/types.h>
#include <sys/file.h>
#include <sys/wait.h>
#define BCMP(b1,b2,length)	bcmp((char *)(b1), (char *)(b2), (int)length)
#define BCOPY(b1,b2,length)	bcopy((char *)(b1), (char *)(b2), (int)length)
#define BZERO(b,length)		bzero((char *)(b), (int)length)
#define WAIT()			wait((union wait *)0)
#else /* MAC */
#define BCMP(b1,b2,length)      memcmp((char *)(b1), (char *)(b2), (int)length)
#define BCOPY(b1,b2,length)     memcpy((char *)(b2), (char *)(b1), (int)length)
#define BZERO(b,length)         memset((char *)(b), 0, (int)length)
#endif  /* !_MAC_ */

extern time_t time();
#define TIME()			(long) time((time_t *)0)

#ifndef PC
#include <strings.h>
#define INDEX(s, c)             index((char *)s, (int)c)
#define RINDEX(s, c)            rindex((char *)s, (int)c)
extern char *sprintf();
#else /*  PC */
#include <string.h>
#define INDEX(s, c)     strchr(s, c)
#define RINDEX(s,c)     strrchr(s, c)
#endif /* !PC */

extern off_t lseek();

#endif	/* _BSD_ */


/* Things needed for System V derived systems in general */
#ifdef	_SYS5_

#include <sys/types.h>
#include <fcntl.h>

#define _IOSTRG			0100
#define VSPRINTF

extern off_t lseek();

extern long time();
#define TIME()			(long) time((long *)0)

#define WAIT()			wait((int *)0)

#include <memory.h>
#define BCMP(b1,b2,length)	memcmp((char *)(b1), (char *)(b2), (int)length)
#define BCOPY(b1,b2,length)     memcpy((char *)(b2), (char *)(b1), (int)length)
#define BZERO(b,length)         memset((char *)(b), 0, (int)length)

#include <string.h>
#define INDEX(s, c)		strchr((char *)s, (int)c)
#define RINDEX(s, c)		strrchr((char *)s, (int)c)

extern struct passwd		*getpwuid();

#ifndef __bsdi__
extern char *calloc();
extern char *malloc();
extern char *realloc();
#endif /* __bsdi__ */

#endif	/* _SYS5_ */


#ifndef PC              /* NON-PC (NON-DOS/MAC) stuff */

#define RD_RAW (O_RDONLY)
#define WR_RAW (O_WRONLY)
#define F_R "r"
#define F_RB "r"
#define F_W "w"
#define F_WB "w"
#define PATH_SEP '/'
#define PATH_SEP_STRING "/"

#else  /* PC Stuff */

#ifdef _MAC_ 
#include <unix.h>
#define PATH_SEP ':'
#define PATH_SEP_STRING ":"
#endif

#ifdef DOS     
#define PATH_SEP '\\'
#define PATH_SEP_STRING "\\"
#endif /* DOS */

#include <fcntl.h>
#define RD_RAW (O_RDONLY|O_BINARY)
#define WR_RAW (O_WRONLY|O_BINARY)
#define F_R "r"
#define F_RB "rb"
#define F_W "w"
#define F_WB "wb"
#define YYSTACKSIZE 50

#endif /* PC */


#endif	/* not _CONFIG_ */
