/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/****************************************************************************
 * msg.h
 ****************************************************************************/

#ifndef _MSG_
#define _MSG_

#include <stdio.h>

#include "bbuf.h"
#include "userlist.h"

struct msg{
    char		**services,	/* Proc-Type */
    			**comment,	/* Content-Type */
			**unkheader,	/* unknown headers */
    			*sigalg,	/* Signature algorithm */
    			*dekalg;	/* DEK algorithm */

    struct bbuf		*dekinfo,	/* DEK-Info structure */
    			*signature,	/* MIC-Info structure */
    			*recipkey,	/* Recipient Key-Info */
    			*keyalg,	/* Key algorithm */
    			*origkey;	/* Originator Key-Info */

    struct user_list    *origusers,      /* Originator users */
                        *recipusers;     /* Recipient users */

    struct msg	 	*next;		/* next enhanced message */
};

#define NULL_MSG		(struct msg *)0

#define FREE_MSG(x)     	if ((x) != NULL_MSG) { \
				    (void) free_msg(x); \
				    (x) = NULL_MSG; \
				} \
				else

struct msg		*alloc_msg();

extern struct bbuf	*hdr2bbuf();

#endif	/* _MSG_ */

