/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <stdio.h>
#include "general.h"

#include "asn1.h"

#define	UNYEAR(y)	((y) < 1900 || (y) > 1999 ? (y) : (y) - 1900)

extern int dm_size[];

#define DM_SIZE(y)	((y)->tm_mon == 1 && !((y)->tm_year%4) \
			? 29 : dm_size[tm->tm_mon])

#define	dysize(y)	\
	(((y) % 4) ? 365 : (((y) % 100) ? 366 : (((y) % 400) ? 365 : 366)))

#define	YEAR(y)		((y) >= 100 ? (y) : (y) + 1900)


static  int makewkday (ut)
UTC     ut;
{
    int     d,
	    mon,
	    year;

    mon = ut -> ut_mon;
    year = YEAR (ut -> ut_year);
    d = 4 + year + (year + 3) / 4;

    if (year > 1800) {
	d -= (year - 1701) / 100;
	d += (year - 1601) / 400;
    }
    if (year > 1752)
	d += 3;
    if (dysize (year) == 366 && mon > 3)
	d++;
    while (--mon)
	d += dm_size[mon - 1];
    d += ut -> ut_mday - 1;

    return (d % 7);
}


struct tm *ut2tm (ut)
UTC	ut;
{
    static struct tm   tms;
    struct tm *tm = &tms;

    BZERO(tm, sizeof *tm);

    if (ut == (UTC)0)
	return(tm);

    tm -> tm_sec = ut -> ut_sec;
    tm -> tm_min = ut -> ut_min;
    tm -> tm_hour = ut -> ut_hour;
    tm -> tm_mday = ut -> ut_mday;
    tm -> tm_mon = ut -> ut_mon - 1;
    tm -> tm_year = UNYEAR (ut -> ut_year);
    tm -> tm_wday = makewkday (ut);
    tm -> tm_yday = tm -> tm_isdst = 0;

    tm -> tm_hour -= ut -> ut_zone / 60, tm -> tm_min -= ut -> ut_zone % 60;
    if (tm -> tm_min < 0)
	tm -> tm_hour--, tm -> tm_min += 60;
    else
	if (tm -> tm_min > 59)
	    tm -> tm_hour++, tm -> tm_min -= 60;

    if (tm -> tm_hour < 0) {
	tm -> tm_mday--, tm -> tm_hour += 24;
	if (tm -> tm_mday < 1) {
	    tm -> tm_mon--;
	    tm -> tm_mday = DM_SIZE(tm);
	    if (tm -> tm_mon < 0)
		tm -> tm_year--, tm -> tm_mon = 11;
	}
    }
    else if (tm -> tm_hour > 23) {
	tm -> tm_mday++, tm -> tm_hour -= 24;
	
	if (tm -> tm_mday > DM_SIZE(tm)) {
	    tm -> tm_mon++, tm -> tm_mday = 1;
	    if (tm -> tm_mon > 11)
		tm -> tm_year++, tm -> tm_mon = 0;
	}
	    
    }

    return tm;
}
