/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "cbio.h"
#include "bbuf.h"
#include "util.h"


int readblock(inputcb, blocksize, block)
struct bbuf *(*inputcb)();
int blocksize;
unsigned char *block;
{
    static struct bbuf *buf = NULLBB;
    static int bufptr = 0;

    int blocklen = 0;
    int needed, have, chunk;

    while (blocklen < blocksize) {
        if (buf != NULLBB) {
            if (buf->length == 0) {
                FREE_BBUF(buf);
                bufptr = 0;
                return(blocklen);
            }
            needed = blocksize - blocklen;
            have = buf->length - bufptr;
            chunk = have > needed ? needed : have;
            BCOPY(&(buf->data[bufptr]), &(block[blocklen]), chunk);
            bufptr += chunk;
            blocklen += chunk;
            if (bufptr == buf->length) 
                FREE_BBUF (buf);
        }
        else {                  /* buf == NULLBB */
            bufptr = 0;
            if ((buf = inputcb()) == NULLBB)
                return (blocklen);
        }
    }
    return (blocklen);
}




