/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cert.h"
#include "util.h"

serial_cert(ecert, serial, mode)
struct bbuf **ecert;
struct bbuf **serial;
int mode;
{
    struct certificate *cert= NULL_CERT;

    if (ecert == (struct bbuf **)0) {
        return(NOTOK);
    }
    if (serial == (struct bbuf **)0) {
	return(NOTOK);
    }
    if (decode_cert(*ecert, &cert) != OK) {
        return(NOTOK);
    }

    switch (mode) {
    case READ:
	FREE_BBUF(*serial);

	if (cert -> tobesigned == (struct tobesigned *)0) {
	    return(NOTOK);
	}

	if (cert->tobesigned->serial != NULLBB)
	    if ((*serial = dup_bbuf(cert->tobesigned->serial)) == NULLBB) {
		return(NOTOK);
	    }

	break;

    case WRITE:
	if (cert -> tobesigned == (struct tobesigned *)0) 
	    cert -> tobesigned = alloc_tobesigned_cert();

	if (*serial != NULLBB)
	    if ((cert->tobesigned->serial = dup_bbuf(*serial)) == NULLBB) {
		return(NOTOK);
	    }
        if (encode_cert(cert, ecert) != OK) {
            return(NOTOK);
        }

	break;

    default:
	return(NOTOK);
    }

    return(OK);
}
