/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crl.h"
#include "util.h"

sig_crl(crl, sig, length, mode)
struct bbuf  **crl;
unsigned char **sig;
int *length;
int mode;
{
    struct crl  *dcrl= NULL_CRL;
    int		ret= NOTOK;

    if (crl == (struct bbuf **)0 || *crl == NULLBB) 
	goto cleanup;

    if (sig == (unsigned char **)0) 
	goto cleanup;

    if (length == (int *)0) 
	goto cleanup;

    if (decode_crl(*crl, &dcrl) != OK) 
	goto cleanup;

    switch (mode) {
    case READ:
	FREE_UCHAR(*sig);
	*length = 0;
	if (dcrl->sig != NULLBB && dcrl->sig->length) {
	    *sig = alloc_uchar(dcrl->sig->length);
	    *length = dcrl->sig->length;
	    BCOPY(dcrl->sig->data, *sig, *length);
	}
	ret = OK;
	break;

    case WRITE:
	FREE_BBUF(dcrl->sig);

	if (*sig != NULLUCP && *length) {
	    dcrl->sig = alloc_bbuf();
	    dcrl->sig->data  = alloc_uchar(*length);
	    dcrl->sig->length = *length;
	    BCOPY(*sig, dcrl->sig->data, *length);
	}
        ret = encode_crl(dcrl, crl);
	break;

    default:

	goto cleanup;
    }

 cleanup:

    FREE_CRL(dcrl);
    return(ret);
}
