/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/****************************************************************************
 * getalgent.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "oid.h"
#include "util.h"

/****************************************************************************/

struct algent *getalgcode(table, code, type)
struct algent table[];
int code;
int type;
{
    int i;

    if (table == NULL_ALGENT || code == 0) 
	return(NULL_ALGENT);

    for (i = 0; table[i].code; i++)
	if (code == table[i].code && (!type || (type & table[i].type)))
	    break;
    if (!table[i].code)
	return(NULL_ALGENT);
    return(&table[i]);
}

/****************************************************************************/

struct algent *getalgstr(table, str, type)
struct algent table[];
char *str;
int type;
{
    int i;

    if (table == NULL_ALGENT || str == NULLCP) 
	return(NULL_ALGENT);

    for (i = 0; table[i].code; i++)
	if (table[i].str != NULLCP && !strcasecmp(str, table[i].str) &&
	    (!type || (type & table[i].type)))
	        break;
    if (!table[i].code)
	return(NULL_ALGENT);
    return(&table[i]);
}

/****************************************************************************/

struct algent *getalghdrstr(table, hdrstr, type)
struct algent table[];
char *hdrstr;
int type;
{
    int i;

    if (table == NULL_ALGENT || hdrstr == NULLCP)
	return(NULL_ALGENT);

    for (i = 0; table[i].code; i++)
	if (table[i].hdrstr != NULLCP && !strcmp(hdrstr, table[i].hdrstr) && 
	    (!type || (type & table[i].type)))
	        break;
    if (!table[i].code)
	return(NULL_ALGENT);
    return(&table[i]);
}

/****************************************************************************/

struct algent *getalgoidstr(table, oidstr, type)
struct algent table[];
char *oidstr;
int type;
{
    int i;

    if (table == NULL_ALGENT || oidstr == NULLCP) 
	return(NULL_ALGENT);

    for (i = 0; table[i].code; i++)
	if (table[i].oidstr != NULLCP && !strcmp(oidstr,table[i].oidstr) &&
	    (!type || (type & table[i].type)))
	    break;
    if (!table[i].code)
	return(NULL_ALGENT);
    return(&table[i]);
}

/****************************************************************************/

struct algent *getalgoid(table, oid, type)
struct algent table[];
OID oid;
int type;
{
    int i;

    if (table == NULL_ALGENT || oid == NULLOID)
	return(NULL_ALGENT);

    for (i = 0; table[i].code; i++)
	if (!oid_cmp(oid,str2oid(table[i].oidstr)) &&
	    (!type || (type & table[i].type)))
	        break;
    if (!table[i].code)
	return(NULL_ALGENT);
    return(&table[i]);
}

