/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 * desdata2bbuf.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int desdata2bbuf(dek, dekbb)
struct key *dek;
struct bbuf **dekbb;
{
    int r, alg;
    struct bbuf *data;

    if (dek == NULL_KEY || dekbb == (struct bbuf **)0 ||
	dek->algid == NULL_ALGID) 
	return(NOTOK);

    alg = dek->algid->alg;

    switch(alg) {
    case DES:
    case DES_CBC:
	if (dek->data == NULLBB)
	    return(NOTOK);
	data = dek->data;
	if ((r = decode_deskeydata(data, dekbb)) != OK)
	    return(r);
	break;

    case DES_ECB:
    case DES_EDE:
	break;

    default:
	return(NOTOK);
    }

    return(OK);
}

