/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 * encode_deskey.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "util.h"


/****************************************************************************
 * encode_deskeyparms()
 *---------------------------------------------------------------------------
 * ASN.1 encode DES key parameters (i.e., IV) as OCTET STRING
 ****************************************************************************/

int encode_deskeyparms(iv,parms)
struct bbuf *iv;
struct bbuf **parms;
{
    int r = OK;

    /* CHECK PARAMETERS */
    if (iv == NULLBB || parms == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*parms);

    /* ENCODE THE KEY PARAMETERS */
    r = encode_octs(iv, parms);

    return(r);
}

/*****************************************************************************
 * encode_deskeydata()
 *---------------------------------------------------------------------------
 * ASN.1 encode DES key data (i.e., key) as OCTET STRING
 ****************************************************************************/

int encode_deskeydata(key,data)
struct bbuf *key;
struct bbuf **data;
{
    int r = OK;

    /* CHECK PARAMETERS */
    if (key == NULLBB || data == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*data);

    /* ENCODE THE KEY DATA */
    r = encode_octs(key, data);

    return(r);
}


