/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include <stdio.h>

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

disp_key(ekey, out)
struct bbuf *ekey;
char ***out;
{
    int ret = NOTOK;
    struct ccbent *ce = NULL_CCBENT;
    struct key *key= NULL_KEY;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (out == (char ***)0) 
	return(NOTOK);

    /* CHECK FOR NULL KEY */
    if (ekey == NULLBB) {
	*out = add2av(*out, add2cp(NULLCP, "NULL"));
	return(OK);
    }

    /* DECODE KEY */
    if (decode_key(ekey, &key) != OK) 
	return(NOTOK);

    /* DISPLAY KEY_DATA.ALGID */
    if (disp_algid(key->algid, out) != OK || key->algid == NULL_ALGID)
	goto cleanup;

    /* DISPLAY KEY_DATA.DATA */
    if ((ce = getccbcode(callbacks, key->algid->alg)) == NULL_CCBENT) 
        goto cleanup;

    if (ce->disp_Xkeydata == NULL_FUNC) 
	goto cleanup;

    ret = (*(ce->disp_Xkeydata))(key->algid->alg, key->data, out);

 cleanup:

    return(ret);
}

