/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "key.h"
#include "util.h"

#include "./global.h"
#include "./md5.h"

int gen_md5(dummy, data, md5)
struct key *dummy;		/* ignored */
struct bbuf *data;
struct bbuf **md5;
{
    MD5_CTX mdContext;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */

    if (data == NULLBB || md5 == (struct bbuf **)0)
	return(NOTOK);

    /* Allocate bbuf for digest */

    FREE_BBUF(*md5);
    *md5 = alloc_bbuf();
    (*md5)->data = alloc_uchar(MD5BLKLEN);
    (*md5)->length = MD5BLKLEN;

    /* Compute digest using MD5 routines */

    MD5Init(&mdContext);
    MD5Update(&mdContext, data->data, (unsigned int)data->length);
    MD5Final((*md5)->data, &mdContext);

    return(OK);
}
