/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/****************************************************************************
 * decode_mic.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "algid.h"
#include "asn1.h"
#include "bbuf.h"
#include "crypto.h"
#include "util.h"

int decode_mic(emic, dmic, aid)
struct bbuf *emic;
struct bbuf **dmic;
struct algid **aid;
{
    int r;
    struct bbuf *bb;
    int len, llen;
    int dp, pl;
	
    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (emic == NULLBB ||dmic == (struct bbuf **)0 || 
	aid == (struct algid **)0)
	return(NOTOK);

    FREE_BBUF(*dmic);
    FREE_ALGID(*aid);

    /* CHECK FOR TAG & LENGTH */
    if (emic->length < 2) 
	return(ASN1_ERR01);

    /* CHECK FOR UNIVERSAL CONSTRUCTED SEQUENCE */
    if (emic->data[0] != (CLASS_UNIV|FORM_CONS|CONS_SEQ)) 
	return(ASN1_ERR02);

    /* DECODE THE LENGTH */
    r = decode_len(&(emic->data[1]), emic->length-1, &len, &llen);
    if (r != OK) return(r);

    /* CHECK FOR NULL */
    if (!len)
	return(OK);

    /* ALLOCATE TEMPORARY BBUF */
    bb = alloc_bbuf();

    /* DECODE ALGID */
    dp = 1 + llen;
    bb->data = &(emic->data[dp]);
    bb->length = 1 + llen + len - dp;
    if ((r = decode_algid(bb, aid, &pl)) != OK)
	goto cleanup;

    /* DECODE MIC AS OCTET STRING */
    dp += pl;
    bb->data = &(emic->data[dp]);
    bb->length = 1 + llen + len - dp;
    if ((r = decode_octs(bb, dmic, &pl)) != OK)
	goto cleanup;

 cleanup:

    if (r != OK) {
	FREE_BBUF(*dmic);
	FREE_ALGID(*aid);
    }

    bb->data = NULLUCP;
    FREE_BBUF(bb);

    return(r);
}


