/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "cert.h"
#include "dname.h"
#include "util.h"

char **explode_cert(certv)
char *certv;			/* printably, ASN.1 encoded certificate */
{
    char **pairs = NULLVP;	/* tag/value pairs derived from cert */

    char  *string = NULLCP;

    struct bbuf  ecert;
    struct bbuf *dcert = NULLBB;
    struct bbuf *bbuf = NULLBB;

    if (certv == NULLCP || *certv == NULLC)
	return NULLVP;

    ecert.data = (unsigned char *)certv;
    ecert.length = strlen(certv);
    if (bdecode(&ecert, &dcert) != OK)
	return NULLVP;

    pairs = add2av(pairs, add2cp(NULLCP, "certificate"));
    pairs = add2av(pairs, add2cp(NULLCP, certv));
  
    if (key_cert(&dcert, &bbuf, READ) == OK) {
	pairs = add2av(pairs, add2cp(NULLCP, "public-key"));
	if ((string = addencbb2cp(string, bbuf)) == NULLCP)
	    goto cleanup;
	pairs = add2av(pairs, string);
	string = NULLCP;
    }

    if (issuer_cert(&dcert, &bbuf, READ) == OK) {
	pairs = add2av(pairs, add2cp(NULLCP, "issuer-name"));
	if ((string = dn2str(bbuf)) == NULLCP)
	    goto cleanup;
	pairs = add2av(pairs, string);
	string = NULLCP;
    }

    if (serial_cert(&dcert, &bbuf, READ) == OK) {
	pairs = add2av(pairs, add2cp(NULLCP, "serial-number"));
	if ((string = addhex2cp(string, bbuf->data, bbuf->length)) == NULLCP)
	    goto cleanup;
	pairs = add2av(pairs, string);
	string = NULLCP;
    }
    
    if (subject_cert(&dcert, &bbuf, READ) == OK) {
	pairs = add2av(pairs, add2cp(NULLCP, "subject-name"));
	if ((string = dn2str(bbuf)) == NULLCP)
	    goto cleanup;
	pairs = add2av(pairs, string);
	string = NULLCP;
    }
  
 cleanup: 

    FREE(string);

    FREE_BBUF(bbuf);
    FREE_BBUF(dcert);

    return pairs;
}
