/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



/* get_tvt_user - return a pointer to the next user record containing
 * at least the set of indicated tag/value pairs.
 */

#include "config.h"
#include "general.h"

#include "new.h"
#include "util.h"

char **get_tvt_user(template)
char **template;
{
    char **user, **tagptr = NULLVP;

    if (template == NULLVP || *template == NULLCP || *(template+1) == NULLCP)
	return NULLVP;
 
    while ((user = get_tv_user(*template, *(template+1))) != NULLVP) {
	int match = 1;

        for (tagptr = template + 2;
	     *tagptr != NULLCP && *(tagptr + 1) != NULLCP;
	     tagptr += 2)
	    if (tagval_user(user, *tagptr, *(tagptr+1)) == NULLVP) {
		match = 0;
		break;
	    }

	if (match)
	    return user;

	FREE_AV(user);
    }

    return NULLVP;
}
