/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



/* dncmp(dn1,dn2) - canonocalize dn1 and dn2 and return:
	-1: canon(dn2) is subordinate to canon(dn1) ie
	    dn1 is a subset of dn2
	 0: canon(dn1) == canon(dn2)
	 1: canon(dn1) != canon(dn2)
*/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "dname.h"
#include "util.h"

dncmp(dn1, dn2)
struct bbuf *dn1;
struct bbuf *dn2;
{
    struct bbuf *cdn1= NULLBB, *cdn2= NULLBB,
                *crdns1= NULLBB, *crdns2= NULLBB,
                *ptr1, *ptr2;
    int ret= 1;

    if ((dn1 == NULLBB) || (dn2 == NULLBB))
	ret = bbufcmp(dn1, dn2);
    else if (!bbufcmp(dn1, dn2)
	     || !bbufcmp(cdn1 = canon_dn(dn1), cdn2 = canon_dn(dn2)))
	ret = 0;
    else {
	/* Check for subordination */
	if ((rdns_dname(cdn1, &crdns1, READ) != OK)
	    || (rdns_dname(cdn2, &crdns2, READ) != OK))
	    goto cleanup;
	for (ptr1 = crdns1, ptr2 = crdns2; ptr1 != NULLBB && ptr2 != NULLBB;
	     ptr1 = ptr1->next, ptr2 = ptr2->next)
	    if (bbufcmp(ptr1, ptr2))
	        goto cleanup;
	if (ptr1 == NULLBB)
	    ret = -1;
    }

 cleanup:
    FREE_BBUF(cdn1);
    FREE_BBUF(cdn2);
    FREE_BBUFS(crdns1);
    FREE_BBUFS(crdns2);

    return(ret);
}
