/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "new.h"
#include "util.h"

int moss_sign(orig_user, iocbs)
char **orig_user;
struct cbstruct *iocbs;
{
    struct bbuf *mic = NULLBB;
    struct bbuf *emic = NULLBB;
    struct bbuf *smic = NULLBB;
    struct bbuf *encsig = NULLBB;
    struct bbuf *pubkey = NULLBB;
    struct bbuf *privkey = NULLBB;
    struct bbuf bb;
    struct algid *mic_aid = NULL_ALGID;
    struct algent *mic_ae = NULL_ALGENT;
    struct algent *sig_ae = NULL_ALGENT;
    char **av = NULLVP;
    char *cp = NULLCP;
    int r = NOTOK;

    if (orig_user == NULLVP || iocbs == NULL_IOCBS
   	|| iocbs->in_data == NULL_INCB || iocbs->out_hdrs == NULL_OUTCB)
	goto cleanup;

    /* Hash the input data */

    if ((av = tag_user(user_tailor, "mic-alg")) == NULLVP) {
	(void) cp2cb(iocbs->out_errs, "Unable to determine mic-alg.\n");
	goto cleanup;
    }

    if ((mic_ae = getalgstr(algorithms, *(av+1), MIC)) == NULL_ALGENT) {
	cp = add2cp(NULLCP, "mic-alg contains an invalid algorithm \"");
	cp = add2cp(cp, *(av+1));
	cp = add2cp(cp, "\".\n");
	(void) cp2cb(iocbs->out_errs, cp);
	FREE(cp);
	goto cleanup;
    }

    cbgen_mic(mic_ae->code, NULLBB, iocbs->in_data, &mic);

    /* ASN.1 encode the MIC and MIC algid */

    mic_aid = alloc_algid();
    mic_aid->alg = mic_ae->code;
    if (encode_mic(mic, mic_aid, &emic) != OK) {
	(void) cp2cb(iocbs->out_errs, "Unable to construct computed MIC.\n");
	goto cleanup;
    }
    FREE_ALGID(mic_aid);
    FREE_BBUF(mic);

    /* get the private key */

    if (moss_getkey(orig_user, &privkey, iocbs) != OK)
	goto cleanup;

    if (set_key(privkey) != OK) {
	cp2cb(iocbs->out_errs, "Unable to use signer's private key.\n");
	goto cleanup;
    }

    /* Encrypt the MIC to produce the signature */

    if (sign(emic, &smic) != OK)
	goto cleanup;

    (void) cp2cb(iocbs->out_hdrs, "Version: 5\n");

    /* Construct Orignator-ID header */

    (void) cp2cb(iocbs->out_hdrs, "Originator-ID: ");
    cp = id_user(orig_user, 1, 0);
    (void) cp2cb(iocbs->out_hdrs, cp);
    FREE(cp);
    (void) cp2cb(iocbs->out_hdrs, "\n");

    /* Construct MIC-Info: header */

    cp = key_user(orig_user);
    bb.data = (unsigned char *)cp;
    bb.length = strlen(cp);
    cp = NULLCP;
    bdecode(&bb, &pubkey);
    FREE_UCHAR(bb.data);

    if (algid_key(&pubkey, &mic_aid, READ) != OK) {
	(void) cp2cb(iocbs->out_errs, "Unable to decode your public key");
	goto cleanup;
    }

    sig_ae = getalgcode(algorithms, mic_aid->alg, ANY);
    (void) cp2cb(iocbs->out_hdrs, "MIC-Info: ");
    (void) cp2cb(iocbs->out_hdrs, mic_ae->hdrstr); 
    (void) cp2cb(iocbs->out_hdrs, ",");
    (void) cp2cb(iocbs->out_hdrs, sig_ae->hdrstr);
    (void) cp2cb(iocbs->out_hdrs, ",");
    (void) bencode(smic, &encsig);
    iocbs->out_hdrs(encsig);
    (void) cp2cb(iocbs->out_hdrs, "\n");
  
    r = OK;

 cleanup:

    FREE_BBUF(encsig);
    FREE_BBUF(smic);
    FREE_BBUF(mic);
    FREE_BBUF(privkey);
    FREE_BBUF(pubkey);
    FREE_ALGID(mic_aid);
 
    return(r);
}
