/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*
 * algidcmp(algid1, algid2) 
 *
 * RETURNS
 *   zero or non-zero as to whether algid1 is equal or non-equal to algid2.
 *
 */


#include "config.h"
#include "general.h"

#include "algid.h"
#include "util.h"

algidcmp(algid1, algid2)
struct algid *algid1, *algid2;
{
    if (algid1 == NULL_ALGID && algid2 == NULL_ALGID)
	return(0);
    if (algid1 == NULL_ALGID || algid2 == NULL_ALGID)
	return(1);

    return (!(algid1->alg == algid2->alg && !bbufcmp(algid1->parms,algid2->parms)));
}



