/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "dname.h"
#include "util.h"

/* convert an octal string to a number */

static unsigned char _aotoi(str)
char *str;
{
    int i, ret= 0, factor= 1;
    for (i=strlen(str); i>0; factor*=8) 
	ret += (str[--i]-'0')*factor;
    return((unsigned char)ret);
}

str2t61(str, length, data)
char *str;
int *length;
unsigned char **data;
{
    int i, j, ret= NOTOK;
    char numstr[T61CHARLEN];
    unsigned char  datastr[BUFSIZ];

    if (str == NULLCP || length == (int *)0 || data == (unsigned char **)0)
        return(ret);

    BZERO(datastr, sizeof(datastr));

    for (i = *length = 0; i < strlen(str);) {
	if ((str[i] == DN_ESCAPE_CHAR) && (i <= strlen(str) - T61CHARLEN)) {
	    BZERO(numstr, sizeof(numstr));
	    for (j=0; j<T61CHARLEN && isdigit(str[++i]); j++) 
		numstr[j] = str[i];
	    datastr[*length] = _aotoi(numstr);
	}
	else 
	    datastr[*length] = (unsigned char)str[i++];

	(*length)++;
    }

    FREE_UCHAR(*data);
    if (*length)
	*data=alloc_uchar(*length);
    BCOPY(datastr, *data, *length);
    ret = OK;

    return(ret);
}
