/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include <stdio.h>

main (argc, argv)

int argc;
char **argv;

{
    int rc;

    if (argc > 2 ||
	(argc > 1 && (strcmp(argv[1], "-qp") && strcmp(argv[1], "-b64")))) {
	fprintf (stderr, "\nUsage: %s [-b64 | -qp]\n\n", argv[0]);
	fprintf(stderr, 
		"%s converts the MIME quoted-printable or Base64\n",
		argv[0]);
	fprintf(stderr, 
		"input on standard input to its original form on standard\n");
	fprintf(stderr,
		"output.  Base64 is the default.\n");
	exit(1);
    }

    if (argc == 1 || !strcmp(argv[1], "-b64"))
	rc = b64decode(stdin, stdout);
    else
	rc = qpdecode(stdin, stdout);
    exit(rc);
}



qpdecode(fin, fout)

FILE *fin, *fout;

{
    int ch, newch, wasequal = 0, wasspace = 0;

    while ((ch = getc(fin)) != EOF) {

	if (!wasequal)  {
	    if (ch == ' ')
		wasspace++;
	    else {
		if (ch == '\n')
		    wasspace = 0;
		else
		    for (;wasspace;wasspace--)
			putc(' ', fout);
		if (ch == '=')
		    wasequal = 1;
		else
		    putc(ch, fout);
	    }
	}
	else {
	    if ((ch >= '0' && ch <= '9') || (ch >= 'A' && ch <= 'F') ||
		(ch >= 'a' && ch <= 'f')) {
		if (ch >= '0' && ch <= '9')
		    newch = 16 * (ch - '0');
		else
		    newch = 16 * (toupper(ch) - 'A' + 10);
		ch = getc(fin);
		if (ch >= '0' && ch <= '9')
		    newch += (ch - '0');
		else if ((ch >= 'A' && ch <= 'F') || (ch >= 'a' && ch <= 'f'))
		    newch += (toupper(ch) - 'A' + 10);
		else 
		    return(1);
		putc(newch, fout);
	    }
	    else {
		while (ch == ' ')
		    ch = getc(fin);
		if (ch != '\n' && ch != EOF)
		    return(1);
	    }
	    wasequal = 0;
	}
    }
    return(0);
}



unsigned char rev_table[256] = {
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,   62,  255,  255,  255,   63,
	  52,   53,   54,   55,   56,   57,   58,   59,
	  60,   61,  255,  255,  255,  255,  255,  255,
	 255,    0,    1,    2,    3,    4,    5,    6,
	   7,    8,    9,   10,   11,   12,   13,   14,
	  15,   16,   17,   18,   19,   20,   21,   22,
	  23,   24,   25,  255,  255,  255,  255,  255,
	 255,   26,   27,   28,   29,   30,   31,   32,
	  33,   34,   35,   36,   37,   38,   39,   40,
	  41,   42,   43,   44,   45,   46,   47,   48,
	  49,   50,   51,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255,
	 255,  255,  255,  255,  255,  255,  255,  255};

#define octet_one(p)	(((p)[0] << 2) | (((p)[1] >> 4) & 0x3))
#define octet_two(p)	((((p)[1] << 4) & 0xf0) | (((p)[2] >> 2) & 0xf))
#define octet_three(p)	(((((p)[2]) & 0x3) << 6) | ((p)[3]))

b64decode(fin, fout)

FILE *fin, *fout;

{
    unsigned char buf[4];
    char in [8];
    int ch, incount = 0;

    while ((ch = getc(fin)) != EOF) {
	
	if (isspace(ch))
	    continue;

	in[incount++ % 8] = ch;

	if (incount % 4 == 0 && incount > 4) {
	    buf[0] = rev_table[in[(incount - 8) % 8]];
	    buf[1] = rev_table[in[(incount - 7) % 8]];
	    buf[2] = rev_table[in[(incount - 6) % 8]];
	    buf[3] = rev_table[in[(incount - 5) % 8]];
	    if ((buf[0] | buf[1] | buf[2] | buf[3]) == 255)
		return(1);
	    putc(octet_one(buf), fout);
	    putc(octet_two(buf), fout);
	    putc(octet_three(buf), fout);
	}
    }

    /* DECODE THE LAST 4 BYTES */
    if (incount % 4 == 0) {
	buf[0] = rev_table[in[(incount - 4) % 8]];
	buf[1] = rev_table[in[(incount - 3) % 8]];
	if ((buf[0] | buf[1]) == 255)
	    return(1);
	putc(octet_one(buf), fout);
	if (in[(incount - 2) % 8] != '=') {
	    buf[2] = rev_table[in[(incount - 2) % 8]];
	    if (buf[2] == 255)
		return(1);
	    putc(octet_two(buf), fout);
	    if (in[(incount - 1) % 8] != '=') {
		buf[3] = rev_table[in[(incount - 1) % 8]];
		if (buf[3] == 255)
		    return(1);
		putc(octet_three(buf), fout);
	    }
	}
    }
    else
	return(1);
    return(0);
}


