/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include <stdio.h>

main (argc, argv)

int argc;
char **argv;

{
    int rc;

    if (argc > 2 ||
        (argc > 1 && (strcmp(argv[1], "-qp") && strcmp(argv[1], "-b64")))) {
        fprintf (stderr, "\nUsage: %s [-b64 | -qp]\n\n", argv[0]);
        fprintf(stderr, 
                "%s converts the input on standard input to MIME\n", argv[0]);
	fprintf(stderr, 
		"quoted-printable or Base64 on standard output.  Base64 is\n");
        fprintf(stderr, "the default.\n");
        exit(1);
    }

    if (argc == 1 || !strcmp(argv[1], "-b64"))
        rc = b64encode(stdin, stdout);
    else
        rc = qpencode(stdin, stdout);
    exit(rc);
}


    
qpencode(fin, fout)

FILE *fin, *fout;

{
    int ch, count = 0, wasspace = 0;
    static char *hex = "0123456789ABCDEF";

    while ((ch = getc(fin)) != EOF) {
	if (ch != '\n') {
	    if (wasspace) {
		putc(' ', fout);
		count++;
	    }
	    wasspace = (ch == ' ');
	    if (!wasspace) 
		if (isprint(ch) && ch != '=') {
		    putc(ch, fout);
		    count++;
		}
		else {
		    putc('=', fout);
		    putc(hex[ch/16], fout);
		    putc(hex[ch%16], fout);
		    count +=3;
		}
	}
	else { /* ch == '\n' */
	    if (wasspace) {
		putc('=', fout);
		putc('2', fout);
		putc('0', fout);
		wasspace = 0;
	    }
	    putc(ch, fout);
	    count = 0;
	}
	if (count > 72) {
	    putc('=', fout);
	    putc('\n', fout);
	    count = 0;
	}
    }
}



b64encode(fin, fout)

FILE *fin, *fout;

{

#define sextet_one(p)	((((p)[0]) >> 2) & 0x3f)
#define sextet_two(p)	(((((p)[0]) & 0x3) << 4) | ((((p)[1]) & 0xf0) >> 4))
#define sextet_three(p)	(((((p)[1]) & 0xf) << 2) | ((((p)[2]) >> 6) & 0x3))
#define sextet_four(p)	(((p)[2]) & 0x3f)

#define sextet_two_last(p)   ((((p)[0]) & 0x3) << 4)
#define sextet_three_last(p) ((((p)[1]) & 0xf) << 2)

    static char *code_table =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    int ch, incount = 0;
    long outcount = 0;
    char in[3];

    while ((ch = getc(fin)) != EOF) {
	in[incount++] = ch;
	if (incount == 3) {
	    putc(code_table[sextet_one(in)], fout);
	    putc(code_table[sextet_two(in)], fout);
	    putc(code_table[sextet_three(in)], fout);
	    putc(code_table[sextet_four(in)], fout);
	    incount = 0;
	    outcount++;
	    if (outcount % 19 == 0) 
		putc('\n', fout);
	}
    }
    if (incount) {
	putc(code_table[sextet_one(in)], fout);
	if (incount == 1) {
	    putc(code_table[sextet_two_last(in)], fout);
	    putc('=', fout);
	}
	else { /* incount == 2 */
	    putc(code_table[sextet_two(in)], fout);
	    putc(code_table[sextet_three_last(in)], fout);
	}
	putc('=', fout);
    }
    if (incount || outcount % 19 != 0)
	putc('\n', fout);
}
