/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)SlotParse.h	1.11 96/08/09"

#ifndef SLOTPARSE_H
#define SLOTPARSE_H

#include "Bigint.h"
#include "Bstream.h"
#include "SkipCert.h"
#include "LL.h"

#define SLOT_SOFT	1
#define	SLOT_CARD	2
#define	SLOT_MANUAL	3

#define	SLOT_SKIP_CONF	4	// fake slot type for parsing skip.conf

class SlotParse {
public:
	int type;		// SLOT_SOFT, SLOT_CARD, SLOT_MANUAL
	u_char nsid;
	Bstream mkid;
	Bigint secret;
	SkipCert *cert;
	Bigint g,p;

	int enable_cdp;
	int enable_certd;
	int require_cdp_cookie;
	LL<char*> cdp_resolvers;
	int cdp_max_retry;
	int cdp_retry_time;
	int max_cdp_queue;
	int serve_only_local;
	int disallow_cdp_put;
	int max_certdb_size;
	int rng_dev_audio;

	SlotParse();
	~SlotParse();
	void clear();
	void print(int=0, int=0);
	int load(char *filename, int default_type = 0);

private:
	void load_cert(char *filename);
	void load_secret(char *filename);
	int sanity_check();
};

struct raw_key {
	u_char		r_nsid;		// remote nsid
        Bstream		r_keyid;	// remote mkid
	u_char		l_nsid;		// local nsid
        Bstream		l_keyid;	// local mkid
	Bstream		e_kp;		// encryption key
	Bstream		a_kp;		// authentication key
};

raw_key*
find_raw_key(u_char r_nsid, const Bstream& r_keyid,
			u_char l_nsid, const Bstream& l_keyid);

void load_raw(char *filename);

#endif /* SLOTPARSE_H */
