/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)cdp.h	1.7 96/04/30"

#ifndef CDP_H
#define CDP_H

#include <sys/types.h>
#include "SkipCert.h"
#include "CertInfo.h"
#include "CertInfoList.h"
#include "Bstream.h"
#include "LL.h"


// Responses that are sent by the certd.  LOCALERR is for local consumtion
// only.

#define CDP_STATUS_LOCALERR	-1
#define CDP_STATUS_OK		0
#define	CDP_STATUS_ERROR	1
#define	CDP_STATUS_NOTFOUND	2
#define CDP_STATUS_NONSID	3


#define	CDP_PORT_INITIATOR		((u_short)1639)
#define	CDP_PORT_RESPONDER		((u_short)1640)

#define	CDP_NAME_NONE			( (u_char)0 )
#define	CDP_NAME_SKIP			( (u_char)1 )
#define	CDP_NAME_PGP_STRING		( (u_char)2 )
#define	CDP_NAME_PGP_KEYID		( (u_char)3 )
#define	CDP_NAME_DNS			( (u_char)4 )
#define	CDP_NAME_RFC822			( (u_char)5 )
#define	CDP_NAME_X509			( (u_char)6 )

#define	CDP_CERT_X509			( (u_char) SKIP_CERT_X509)
#define	CDP_CERT_PGP			( (u_char) SKIP_CERT_PGP)
#define	CDP_CERT_DNS			( (u_char) SKIP_CERT_DNS)
#define	CDP_CERT_DH_PUBLIC		( (u_char) SKIP_DH_PUBLIC)

#define	CDP_STATUS_LOCALERR		-1
#define	CDP_STATUS_OK			0	// All is well
#define	CDP_STATUS_ERROR		1	// Unknown Error
#define	CDP_STATUS_UNKNOWN_NAME		2	// Couldn't find the cert
#define	CDP_STATUS_UNSUP_NAME_TYPE	3	// Unsupported Name Type
#define	CDP_STATUS_UNSUP_CERT_TYPE	4	// Unsupported certificate type
#define	CDP_STATUS_COOKIE_REQUIRED	5	// Cookie Required
#define	CDP_STATUS_TOO_BIG		6	// Couldn't send all responses


//	Certificate Discovery Protocol (CDP) format:
//
//	0                   1                   2                   3
//	0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
//	
//	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	| Version       | Action/Status | #-of-recs     | Reserved      |
//	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	|              Initiator Cookie (if I bit is set)               |
//	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	|              Responder Cookie (if R bit is set)               |
//	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


//  Action/Status:

#define	CDP_INITIATE		0	// CDP request
#define	CDP_RESPONSE		1	// CDP response
#define	CDP_COOKIE_REQUIRED	2	// resend request with responder cookie
#define	CDP_TOOBIG		3	// answer doesn't fit in a UDP packet


//	followed by #-of-recs of the following:
//
//	0                   1                   2                   3
//	0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
//	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	| Action/Status | Name Type     | Name Length   | Name          ~
//	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
//	| CERT-Type     | CERT-Length                   |  Certificate  ~
//	+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


//  Action/Status:

#define	CDP_REC_GET		1	// ask for a certificate
#define	CDP_REC_PUT		2	// here is a certificate

#define	CDP_REC_GETOK		100	// successful response to a GET
#define	CDP_REC_GETFAIL		101	// get failed
#define	CDP_REC_PUTOK		102	// PUT acknowledged
#define	CDP_REC_PUTFAIL		103	// PUT failed or rejected

// For SKIP:
//	Name Type = CDP_NAME_SKIP
//	Name = nsid + mkid


class cdp_rec {
public:
	u_char	action;		// Action/Status
	CertInfo ci;		// name and certificate

	char *get_info_str();
};


class cdp {
public:
	u_char version;
 	u_char action;
	u_char n_of_recs;
	u_char reserved;	// unused
	u_long icookie;
	u_long rcookie;

	LL<cdp_rec> recs;


	cdp();
	cdp(u_char a);
	~cdp();

	void cdp_getok(const CertInfo& c);
	void cdp_getfail(u_char nsid, const Bstream& mkid);
	void cdp_get(u_char nsid, const Bstream& mkid);
	void cdp_put(const CertInfo& c);
	void cdp_putok(u_char nsid, const Bstream& mkid);
	void cdp_putfail(u_char nsid, const Bstream& mkid);

	Bstream encode();
	decode(Bstream &);

	void print();
	void clear();
};

#endif /* CDP_H */
