/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_keymgr.h	1.41 96/10/14"
 
#ifndef SKIP_KEYMGR_H
#define SKIP_KEYMGR_H

#include "skip_types.h"
#include "LL.h"
#include "Bstream.h"
#include "skip_params.h"
#include "skip_localid.h"

#define COUNTERSTART  2997907200              // 1-1-95 0h in NTP time

#define CACHED_KIJ_SIZE (256/8)


#define	NTP_TO_NCOUNTER(n)		((n-COUNTERSTART)/UPDATE_FREQ)
#define	NCOUNTER_TO_NTP(n)		(UPDATE_FREQ * n + COUNTERSTART)

#define	NCOUNTER_TO_UNIX(n)		(NTP_TO_UNIX(NCOUNTER_TO_NTP(n)))

#define CURRENT_NCOUNTER    	(NTP_TO_NCOUNTER(UNIX_TO_NTP(time(0))))  
#define UNTIL_NEXT_NCOUNTER		(time(0)-(time(0)/UPDATE_FREQ))



#define KEY_NONE		0	// No key
#define KEY_MASTER		1	// Manual Key   (manual or computed)
#define	KEY_RAW_ESP		2	// ESP raw key  (manual)
#define	KEY_RAW_AH		3	// AH raw key   (manual)

#define KIJALG			0
#define KPALG			1

// Key manager error values -- used internally
#define KEYMGR_OK		0
#define KEYMGR_NOCERT		1
#define KEYMGR_BADALG		2
#define KEYMGR_SHORTKEY		3
#define KEYMGR_BAD_N_OFFSET	4
#define KEYMGR_NO_MANUAL_KEY	5
#define KEYMGR_LOCAL_EXPIRED	6
#define KEYMGR_BAD_VER		7
#define KEYMGR_NO_LOCALID       8
#define KEYMGR_DUP_LOCALIDS     9
#define KEYMGR_BADCERT		10

extern int UPDATE_FREQ;

typedef unsigned char ENC_ALG_TYPE;
typedef unsigned char MAC_ALG_TYPE;

int cryptor_get_Ekeylen(int, int, ENC_ALG_TYPE );
int cryptor_get_keylen(int, int, ENC_ALG_TYPE );
int cryptor_get_ivlen(int, int, ENC_ALG_TYPE );
int cryptor_get_flags(int, int, ENC_ALG_TYPE );
int mac_get_keylen(int, MAC_ALG_TYPE );

int skip_dispatch(int, SkipParams *);

Bstream keymgr_encrypt(int, int, ENC_ALG_TYPE , const Bstream&, const Bstream&);
Bstream keymgr_decrypt(int, int, ENC_ALG_TYPE , const Bstream& , const Bstream&);

int skip_init();

Bstream skip_get_cached_secret(u_char, const Bstream, int);
void skip_cache_secret(Bstream& , u_char, Bstream&, u_long , int=0);

int
skip_get_dh_public_value(Bigint &pub, Bigint &g, Bigint &p, 
			  	 const Bstream &mkid, u_char, u_long & );

int make_response(void *, void *, int *, struct remote_info *);
int make_boxid_msg(u_char, Bstream, void *);
int get_skip_request(int, void *, int );
Bstream skip_random_encrypt(Bstream, Bstream);

void init_cryptolib();
void skip_init_internal_cryptors(int);
void skip_init_internal_macs(int);
void skip_fetch_rsp( int, Bstream&);
void skip_send_cert_reply(Bstream &);
Bstream skip_kp_to_Akp(Bstream, u_char, int);
Bstream skip_kp_to_Ekp(Bstream, u_char, int);
extern Bstream get_random_bytes(int len);
Bstream kijtokijn(Bstream, u_long);
skip_get_raw_keys(int , u_char , Bstream , ENC_ALG_TYPE , MAC_ALG_TYPE ,
                  u_long , Bstream &, Bstream &, Bstream &);

void set_kij_alg(int , unsigned char , unsigned char );
extern int skip_set_cdp_port(int, unsigned short);

#ifdef SYSV
/*
#define bcopy(s,d,n)	memcpy(d,s,n)
*/
#endif

#endif 
