/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_softsecret.C	1.7 96/10/02"
 
#include <skip_os.h>
 
#include "skip_log.h"

#include "Bstream.h"
#include "Bigint.h"
#include "Time.h"

#include "skip_crypt.h"
#include "skip_keymgr.h"
#include "skip_secret.h"
#include "skip_softsecret.h"
#include "skip_params.h"

extern void randpool_addbytes(unsigned char const *buf, unsigned len);


Bstream skip_softsecret::prepare_kij(int ver, u_char kij_alg, u_long ncounter)
{
	Bstream kij;

	int keylen = cryptor_get_Ekeylen(ver, KIJALG,  kij_alg);

	if (ver == SKIP_V1) 
		kij = secret;
	if (ver == SKIP_V2) 
		kij = kijtokijn(secret, ncounter);
	if (keylen > kij.getlength()) {
		skip_log(SKIP_NOTICE,   "Warning: Master key too short"
					"prepadded with 0");
		Bstream res(keylen - kij.getlength(), (byte)0);
		res+=kij;
		kij=res;
	}
	else {
		kij.consume(kij.getlength()-keylen);
	}
	return kij;
}	

int
skip_softsecret::generate_kp_iv(SkipParams *p)
{
	String temp;

	int keylen;
	int e_keylen, a_keylen;
	Bstream kij;

	// This returns the shared secret truncated to the size required to
	// use it as a key to kij_alg

	// Get the length of the key required for the crypt algorithm.  We
	// use keylen but this is wrong.

	// The length of kp should be the size of larger of the two 
	// algorithms (crypt,mac), rounded up to the block size of the
	// kij algorithm.

	e_keylen=cryptor_get_Ekeylen(p->ver, KPALG, p->kp_alg);
	if (e_keylen < 0) {
		skip_log(SKIP_ERROR,
			 "Unsupported Traffic encryption Algorithm %d",
			 p->kp_alg);
		return KEYMGR_BADALG;
	}
	// Get the length of the key required for the MAC algorithm
	a_keylen=mac_get_keylen(p->ver, p->mac_alg);
	if (a_keylen < 0) {
		skip_log(SKIP_ERROR, "Unsupported MAC Algorithm %d",p->mac_alg);
		return KEYMGR_BADALG;
	}

	// We need to generate a kp that is large enough for the bigger of
	// the two.

	keylen=(a_keylen < e_keylen)?e_keylen:a_keylen;

	p->kp = get_random_bytes(keylen);
#ifdef DEBUG
	fprintf(stdout,"kp=");p->kp.print();fflush(stdout);
#endif

	// Create the IV for the traffic key algorithm
	if (cryptor_get_flags(p->ver, KPALG, p->kp_alg) & SKIP_STREAM_CIPHER) {
		unsigned char zero[8];
		bzero(zero, sizeof(zero));
		p->iv = Bstream(8, zero);
	} else {
		p->iv = get_random_bytes(
		       cryptor_get_ivlen(p->ver, KPALG, p->kp_alg));
	}

// Truncated the key to support to it's correct length.

	if (p->ver == SKIP_V1) {
		keylen = cryptor_get_keylen(p->ver, KPALG, p->kp_alg);
		p->kp.consume(p->kp.getlength()-keylen);
	} else if (p->ver == SKIP_V2) {

		/* XXX Disgusto hack.  The e_kp length determined earlier
		XXX is actually the length of the encrypted key.  This was
		XXX correct when we needed to determine the size of the key
		XXX to generate since the encrypted key length inherently
		XXX (and incorrectly) includes the block size of the kij
		XXX algorithm.  We now need to adjust the key length
		XXX down to the real kp length or we'll end up using the
		XXX wrong size key down in the kernel.  So, we switch to
		XXX the non-encrypted kp length.  THis needs to be fixed
		XXX generically.
		*/
		e_keylen=cryptor_get_keylen(p->ver, KPALG, p->kp_alg);

		/* Back to Sanity */
		p->e_kp=skip_kp_to_Ekp(p->kp, p->kp_alg, e_keylen);
		p->a_kp=skip_kp_to_Akp(p->kp, p->mac_alg, a_keylen);
	} else
		return KEYMGR_BAD_VER;

	kij=prepare_kij(p->ver, p->kij_alg, p->counter_n);


	// Now encrypt the traffic key using kij and the kij algorithm.
	p->encrypted_kp = keymgr_encrypt(p->ver, KIJALG, p->kij_alg, kij, 
				    p->kp);

#ifdef DEBUG
	fprintf(stdout,"encrypted kp=");
	p->encrypted_kp.print();
	fflush(stdout);
#endif
	return KEYMGR_OK;
}

int
skip_softsecret::decrypt_kp(SkipParams *p)
{
	int offset;
	int e_keylen, a_keylen;
	int keylen;
	Bstream kij;

	kij=prepare_kij(p->ver, p->kij_alg, p->counter_n);

#ifdef DEBUG
	fprintf(stdout, "skip_decrypt_kp: kij = "); kij.print(); fflush(stdout);
#endif

	p->kp = keymgr_decrypt(p->ver, KIJALG, p->kij_alg, kij, p->encrypted_kp);

	if (p->kp.getlength() > 0)
		randpool_addbytes(p->kp.getdatap(), p->kp.getlength());

	e_keylen=cryptor_get_keylen(p->ver, KPALG, p->kp_alg);
	if (e_keylen < 0) {
		skip_log(SKIP_ERROR,
			 "Unsupported Traffic encryption Algorithm %d",
			 p->kp_alg);
		return KEYMGR_BADALG;
	}

	a_keylen=mac_get_keylen(p->ver, p->mac_alg);
	if (a_keylen < 0) {
		skip_log(SKIP_ERROR, "Unsupported MAC Algorithm %d",
					p->mac_alg);
		return KEYMGR_BADALG;
	}

	p->e_kp = skip_kp_to_Ekp(p->kp, p->kp_alg, e_keylen);
	p->a_kp = skip_kp_to_Akp(p->kp, p->mac_alg, a_keylen);

// Truncated the key to support to it's correct length.

	keylen = (a_keylen > e_keylen)?a_keylen:e_keylen; /// XXX V1?
	p->kp.consume(p->kp.getlength()-keylen);

#ifdef DEBUG
	fprintf(stdout,"encrypted kp=");encrypted_kp.print();fflush(stdout);
#endif
#ifdef DEBUG
	fprintf(stdout,"kp=");kp.print();fflush(stdout);
#endif
	return KEYMGR_OK;
}

Bstream skip_softsecret::encode()
{
	Bstream nullstr;
	return nullstr;
}

int skip_softsecret::decode(Bstream x)
{
	return 0;
}


