/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/


#pragma ident "@(#)skiptool_stubs.c	1.18 96/09/30 Sun Microsystems"

/*
 * skiptool_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `skiptool.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include "skiptool_ui.h"

#include <skip_os.h>
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_ioctl.h>
#include <skip_acl.h>
#include <skip_lib.h>

#include "es_glue.h"

/*
 * Global object definitions.
 */
skiptool_base_window_objects	*Skiptool_base_window;
skiptool_key_params_win_objects	*Skiptool_key_params_win;
skiptool_required_win_objects	*Skiptool_required_win;
skiptool_about_win_objects	*Skiptool_about_win;
skiptool_hostwin_objects	*Skiptool_hostwin;
skiptool_hostwin_v1_objects	*Skiptool_hostwin_v1;
skiptool_hostwin_v2_objects	*Skiptool_hostwin_v2;
skiptool_hostwin_raw_objects	*Skiptool_hostwin_raw;
skiptool_netwin_objects		*Skiptool_netwin;
skiptool_netwin_v1_objects	*Skiptool_netwin_v1;
skiptool_netwin_v2_objects	*Skiptool_netwin_v2;
skiptool_netwin_raw_objects	*Skiptool_netwin_raw;
skiptool_nomwin_v1_objects	*Skiptool_nomwin_v1;
skiptool_nomwin_v2_objects	*Skiptool_nomwin_v2;

es_acl_t			*add_xhostwin, *add_xnetwin, *add_xnomwin_v1,
				*add_xnomwin_v2;
extern void			init();
extern void			get_key_params();
extern void			access_update();
extern void			editor();
extern int			is_double_click();
extern int			is_xdouble_click();
extern void			host_swap();
extern void			host_delete();
extern void			key_status();
extern void			es_win_cancel();
extern void			set_key_params();
extern void			set_key_defaults();
extern void			required_systems_add();
extern void			required_systems_done();
extern void			stats();
extern void			es_sync_win();
extern void			es_do_props();
extern void			es_win_apply();
extern void			es_do_addprops();
extern void			acl_save();
extern void			acl_build();
extern void			show_mode();
extern void			s_nsid_hostwin_v2_callback();
extern void			s_nsid_netwin_v2_callback();
extern void			s_nsid_nomwin_v2_callback();

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

void
main(int argc, char **argv)
{
	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
	INSTANCE = xv_unique_key();
	
	/*
	 * Initialize user interface components.
	 * Do NOT edit the object initializations by hand.
	 */
	Skiptool_base_window = skiptool_base_window_objects_initialize(NULL, NULL);
	Skiptool_key_params_win = skiptool_key_params_win_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_required_win = skiptool_required_win_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_about_win = skiptool_about_win_objects_initialize(NULL, Skiptool_base_window->base_window);

#ifdef notdef
	Skiptool_hostwin_v2 = skiptool_hostwin_v2_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_hostwin_raw = skiptool_hostwin_raw_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_hostwin_v1 = skiptool_hostwin_v1_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_hostwin = skiptool_hostwin_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_netwin_raw = skiptool_netwin_raw_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_netwin = skiptool_netwin_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_netwin_v1 = skiptool_netwin_v1_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_nomwin_v1 = skiptool_nomwin_v1_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_nomwin_v2 = skiptool_nomwin_v2_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_netwin_v2 = skiptool_netwin_v2_objects_initialize(NULL, Skiptool_base_window->base_window);
#endif
	
	init(argc, argv);

	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(Skiptool_base_window->base_window);
	exit(0);
}

#endif


/*
 * Menu handler for `menu (Key Management...)'.
 */
Menu_item
skiptool_menu_item0_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
acl_build(); show_mode(); access_update();
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `access_ctrl'.
 */
void
skiptool_base_window_access_ctrl_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
access_update();
	}
	
	if (value == 1)
	{
access_update();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `access_mode'.
 */
void
skiptool_base_window_access_mode_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
access_update();
	}
	
	if (value == 1)
	{
access_update();
	}
	
	if (value == 2)
	{
access_update();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `delete_button'.
 */
void
skiptool_base_window_delete_button_notify_callback(Panel_item item, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
host_delete();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `key_apply'.
 */
void
skiptool_key_params_win_key_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_key_params_win_objects *ip = (skiptool_key_params_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Skiptool_key_params_win->key_params_win, XV_SHOW, FALSE, NULL);
	
	{
set_key_params();

	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `key_default'.
 */
void
skiptool_key_params_win_key_default_notify_callback(Panel_item item, Event *event)
{
	skiptool_key_params_win_objects *ip = (skiptool_key_params_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
set_key_defaults();

	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `required_add'.
 */
void
skiptool_required_win_required_add_notify_callback(Panel_item item, Event *event)
{
	skiptool_required_win_objects *ip = (skiptool_required_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
required_systems_add();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `required_cancel'.
 */
void
skiptool_required_win_required_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_required_win_objects *ip = (skiptool_required_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
required_systems_done();
	}
	
	/* gxv_end_connections */

}

/*
 * Menu handler for `help_menu (About...)'.
 */
Menu_item
skiptool_help_menu_item1_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Background event callback function for `controls1'.
 * This is a function generated by guide to handle popup 
 * menu help_menu for control area controls1.
 */
void
skiptool_base_window_controls1_background_handler(Xv_opaque panel, Event *event)
{
	
	if (event_action(event) == ACTION_MENU && event_is_down(event)) {
		Menu	menu = (Menu) xv_get(panel, WIN_MENU);

		if (menu)
			menu_show(menu, panel, event, 0);
	}
}

/*
 * Menu handler for `stats_menu (Interface Stats)'.
 */
Menu_item
skiptool_stats_menu_item0_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(0);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `stats_menu (Header Stats)'.
 */
Menu_item
skiptool_stats_menu_item1_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(1);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `stats_menu (Algorithm Stats)'.
 */
Menu_item
skiptool_stats_menu_item2_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(3);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `stats_menu (Key Stats)'.
 */
Menu_item
skiptool_stats_menu_item3_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(2);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `s_nsid'.
 */
void
skiptool_hostwin_v2_s_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_hostwin_v2_objects *ip = (skiptool_hostwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
s_nsid_hostwin_v2_callback(ip);
	}
	
	/* gxv_end_connections */

}


/*
 * Notify callback function for `hostlist'.
 */
int
hostlist_notify(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_SELECT:
		editor(ip->hostlist, 0, row);
		if (is_double_click(row)) {
			editor(ip->hostlist, 2, row);
		}
		break;

	case PANEL_LIST_OP_VALIDATE:
		break;

	case PANEL_LIST_OP_DELETE:
		break;
	}
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return XV_OK;
}

/*
 * Notify callback function for `xhostlist'.
 */
int
xhostlist_notify(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_SELECT:
		editor(ip->xhostlist, 0, row);
		if (is_xdouble_click(row)) {
			editor(ip->xhostlist, 2, row);
		}
		break;

	case PANEL_LIST_OP_VALIDATE:
		break;

	case PANEL_LIST_OP_DELETE:
		break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return XV_OK;
}

/*
 * Notify callback function for `delete_xbutton'.
 */
void
skiptool_base_window_delete_xbutton_notify_callback(Panel_item item, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
host_delete();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `to_x'.
 */
void
skiptool_base_window_to_x_notify_callback(Panel_item item, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
host_swap();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `to_a'.
 */
void
skiptool_base_window_to_a_notify_callback(Panel_item item, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
host_swap();
	}
	
	/* gxv_end_connections */

}

/*
 * Menu handler for `stats_menu (Key Stats)'.
 */
Menu_item
skiptool_stats_menu_item4_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(4);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `stats_menu (Authentication Stats (IPSP))'.
 */
Menu_item
skiptool_stats_menu_item5_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(5);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `menu (Key Management...)'.
 */
Menu_item
skiptool_menu_item1_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_key_params_win->key_params_win, XV_SHOW, TRUE, NULL);
		
		{
get_key_params();

		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `menu (Save)'.
 */
Menu_item
skiptool_menu_item3_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
acl_save();
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `menu (Exit)'.
 */
Menu_item
skiptool_menu_item4_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
exit(0);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu (Off)'.
 */
Menu_item
skiptool_version_menu_item0_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_hostwin->hostwin, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu (SKIP)'.
 */
Menu_item
skiptool_version_menu_item1_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_hostwin_v2->hostwin_v2, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu (SKIP (SunScreen Compatibility))'.
 */
Menu_item
skiptool_version_menu_item2_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_hostwin_v1->hostwin_v1, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu_nom (SKIP)'.
 */
Menu_item
skiptool_version_menu_nom_item0_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_nomwin_v2->nomwin_v2, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu_nom (SKIP (SunScreen Compatibility))'.
 */
Menu_item
skiptool_version_menu_nom_item1_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_nomwin_v1->nomwin_v1, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu_net (Off)'.
 */
Menu_item
skiptool_version_menu_net_item0_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_netwin->netwin, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu_net (SKIP)'.
 */
Menu_item
skiptool_version_menu_net_item1_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_netwin_v2->netwin_v2, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu_net (SKIP (SunScreen Compatibility))'.
 */
Menu_item
skiptool_version_menu_net_item2_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_netwin_v1->netwin_v1, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `version_menu_net (ESP/AH (manual keying))'.
 */
Menu_item
skiptool_version_menu_net_item3_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_netwin_raw->netwin_raw, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}


/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_hostwin_v2_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_v2_objects *ip = (skiptool_hostwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->hostwin_v2, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_hostwin_raw_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_raw_objects *ip = (skiptool_hostwin_raw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->hostwin_raw, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_hostwin_v1_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_v1_objects *ip = (skiptool_hostwin_v1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->hostwin_v1, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_hostwin_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_objects *ip = (skiptool_hostwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->hostwin, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_netwin_raw_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_netwin_raw_objects *ip = (skiptool_netwin_raw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->netwin_raw, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_netwin_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_netwin_objects *ip = (skiptool_netwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->netwin, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_netwin_v1_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_netwin_v1_objects *ip = (skiptool_netwin_v1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->netwin_v1, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_nomwin_v1_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_nomwin_v1_objects *ip = (skiptool_nomwin_v1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->nomwin_v1, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `s_nsid'.
 */
void
skiptool_nomwin_v2_s_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_nomwin_v2_objects *ip = (skiptool_nomwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
s_nsid_nomwin_v2_callback(ip);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_nomwin_v2_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_nomwin_v2_objects *ip = (skiptool_nomwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->nomwin_v2, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `s_nsid'.
 */
void
skiptool_netwin_v2_s_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_netwin_v2_objects *ip = (skiptool_netwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
s_nsid_netwin_v2_callback(ip);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_apply'.
 */
void
skiptool_netwin_v2_win_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_netwin_v2_objects *ip = (skiptool_netwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_apply(xv_get(ip->netwin_v2, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Menu handler for `version_menu (ESP/AH (manual keying))'.
 */
Menu_item
skiptool_version_menu_item3_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_hostwin_raw->hostwin_raw, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `xversion_menu_nom (SKIP )'.
 */
Menu_item
skiptool_xversion_menu_nom_item0_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
xv_set(add_xnomwin_v2->win, XV_SHOW, TRUE, NULL);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `xversion_menu_nom (SKIP (SunScreen Compatibility))'.
 */
Menu_item
skiptool_xversion_menu_nom_item1_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
xv_set(add_xnomwin_v1->win, XV_SHOW, TRUE, NULL);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `exc_menu (Host...)'.
 */
Menu_item
skiptool_exc_menu_item0_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
xv_set(add_xhostwin->win, XV_SHOW, TRUE, NULL);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `exc_menu (Network...)'.
 */
Menu_item
skiptool_exc_menu_item1_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
xv_set(add_xnetwin->win, XV_SHOW, TRUE, NULL);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_hostwin_v2_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_v2_objects *ip = (skiptool_hostwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->hostwin_v2, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_hostwin_raw_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_raw_objects *ip = (skiptool_hostwin_raw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->hostwin_raw, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_hostwin_v1_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_v1_objects *ip = (skiptool_hostwin_v1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->hostwin_v1, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_hostwin_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_objects *ip = (skiptool_hostwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->hostwin, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_netwin_raw_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_netwin_raw_objects *ip = (skiptool_netwin_raw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->netwin_raw, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_netwin_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_netwin_objects *ip = (skiptool_netwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->netwin, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_netwin_v1_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_netwin_v1_objects *ip = (skiptool_netwin_v1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->netwin_v1, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_nomwin_v1_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_nomwin_v1_objects *ip = (skiptool_nomwin_v1_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->nomwin_v1, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_nomwin_v2_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_nomwin_v2_objects *ip = (skiptool_nomwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->nomwin_v2, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `win_cancel'.
 */
void
skiptool_netwin_v2_win_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_netwin_v2_objects *ip = (skiptool_netwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
es_win_cancel(xv_get(ip->netwin_v2, WIN_CLIENT_DATA));
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `skip_mode'.
 */
void
skiptool_hostwin_v2_skip_mode_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_hostwin_v2_objects *ip = (skiptool_hostwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
xv_set(ip->tunnel_label, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 1)
	{
xv_set(ip->tunnel_label, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 0)
	{
xv_set(ip->tunnel_addr, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 1)
	{
xv_set(ip->tunnel_addr, PANEL_INACTIVE, TRUE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `r_nsid'.
 */
void
skiptool_hostwin_v2_r_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_hostwin_v2_objects *ip = (skiptool_hostwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
xv_set(ip->keyid, PANEL_VALUE, "", NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `skip_mode'.
 */
void
skiptool_hostwin_raw_skip_mode_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_hostwin_raw_objects *ip = (skiptool_hostwin_raw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
xv_set(ip->tunnel_label, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 1)
	{
xv_set(ip->tunnel_label, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 0)
	{
xv_set(ip->tunnel_addr, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 1)
	{
xv_set(ip->tunnel_addr, PANEL_INACTIVE, TRUE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `skip_mode'.
 */
void
skiptool_netwin_raw_skip_mode_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_netwin_raw_objects *ip = (skiptool_netwin_raw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
xv_set(ip->tunnel_label, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 1)
	{
xv_set(ip->tunnel_label, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 0)
	{
xv_set(ip->tunnel_addr, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 1)
	{
xv_set(ip->tunnel_addr, PANEL_INACTIVE, TRUE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `r_nsid'.
 */
void
skiptool_nomwin_v2_r_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_nomwin_v2_objects *ip = (skiptool_nomwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
xv_set(ip->keyid, PANEL_VALUE, "", NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `skip_mode'.
 */
void
skiptool_nomwin_v2_skip_mode_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_nomwin_v2_objects *ip = (skiptool_nomwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */

}

/*
 * Notify callback function for `skip_mode'.
 */
void
skiptool_netwin_v2_skip_mode_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_netwin_v2_objects *ip = (skiptool_netwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
xv_set(ip->tunnel_label, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 1)
	{
xv_set(ip->tunnel_label, PANEL_INACTIVE, TRUE, NULL);
	}
	
	if (value == 0)
	{
xv_set(ip->tunnel_addr, PANEL_INACTIVE, FALSE, NULL);
	}
	
	if (value == 1)
	{
xv_set(ip->tunnel_addr, PANEL_INACTIVE, TRUE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `r_nsid'.
 */
void
skiptool_netwin_v2_r_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_netwin_v2_objects *ip = (skiptool_netwin_v2_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
xv_set(ip->keyid, PANEL_VALUE, "", NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `about_button'.
 */
void
skiptool_base_window_about_button_notify_callback(Panel_item item, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Skiptool_about_win->about_win, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}
