/*
**	ssh_packet.h	-- packet stuff (pack and unpack)
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_PACKET_H
#define __SSH_PACKET_H

#include "ssh_types.h"

#define SSH_PACKET_LENGTH_LEN	sizeof(uint32_t)	/* bytes for length */
#define SSH_PACKET_CRC_LEN	sizeof(uint32_t)	/* bytes for CRC */
#define SSH_UNITS		8		/* units for packets */
#define SSH_DATA_LEN_DIFF	5		/* length & data diff */

#ifdef __cplusplus
extern "C" {
#endif

/*
**	functions to pack and unpack a message
*/
int ssh_packet_unpack(struct ssh_struct * ssh_info, uint8_t * packet,
	uint32_t * data_len, uint8_t * type, uint8_t * data,
	uint32_t out_size);

int ssh_packet_pack(uint8_t * packet, uint32_t * total_len, uint8_t type,
	uint8_t * data, uint32_t data_len, uint32_t out_size);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_PACKET_H */

