/*
**	ssh_ident.h	-- handles saving user RSA identities
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/


#ifndef __SSH_IDENT_H
#define __SSH_IDENT_H

#define SSH_IDENT_MOD_BITS	1024		/* bits for modulus */
#define SSH_IDENT_EXP		0x10001		/* exponent */

#define SSH_IDENTITY_HEAD	"KSSH Format 1.0"	/* header for ident */
#define SSH_IDENTITY_HEAD_LEN	30			/* max len of head */

#define SSH_IDENTITY_CHECKHEAD_LEN	4	/* header len for new format */

/*
** if we are to use the Tatu Ylonen's identity file format
*/
#define SSH_IDENT_YLONEN_FILE_ID	"SSH PRIVATE KEY FILE FORMAT 1.1\n"
#define SSH_IDENT_YLONEN_FILE_ID_LEN	100

#ifdef __cplusplus
extern "C" {
#endif

/*
**	generate a kohno-format identity file.
*/
int ssh_identity_gen(struct ssh_struct * ssh_info, const char * priv_file,
	const char * pub_file, const char * msg, const char * passphrase,
	int bits, uint8_t cipher_type);

/*
**	load identity file  .  Note that _within_ ssh_ident.c,
**	the actual action depends of the specification of
**	SSH_USE_YLONEN_IDENTITY.  Either a kohno-format or a ylonen-format
**	identity file will be read
*/
int ssh_identity_load(struct ssh_struct * ssh_info, const char * filename,
	const char * passphrase, MP_Int * public_key_modulus,
	MP_Int * public_key_exponent, MP_Int * private_key_modulus,
	MP_Int * private_key_exponent);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_IDENT_H */

