#!/bin/sh
export PGPPATH=.
export PGPPASS=testpass
export USEPASS="-p testpass"

echo ========== Generating key:
#needs existing pubring.pkr with good parameters in the first key.
#I could use newkeygen, but it takes a while...

./newkey5 -K 0 -k 0 -r pubring.pkr -u "Test Key" $USEPASS
#this probably should be a cat, but...
mv pubnew.pkr pubring.pkr
mv secnew.skr secring.skr

#fix pubring to allow crypyption
./lookup5 -x -m Test | ./minipgp5 -t 24 $USEPASS >>pubring.pkr
echo -ne "\260\001\147" >>pubring.pkr
#strictly, you also need to use pgpk -s to sign the DSS key on the pubring

pgpk -l

echo ========== encrypt test

cat newkey5 | ./minipgp5 -l rdx | ./minipgp5 -z | ./minipgp5 -k 0 >rdx.enc
rm -f rdx
pgpv rdx.enc
if cmp rdx newkey5; then echo quick encrypt ok; else exit 0; fi
rm -f rdx rdx.enc

echo ========== encrypt and One pass sig test

for siga in 17; do
    for hash in 1 2; do
        for alg in 1 2 3; do
            echo testing enc $alg, hash $hash, sig $siga
            cat newkey5 | ./minipgp5 -l rdx >rdx.one
            ./minipgp5 -A $siga -a $hash -t 1 $USEPASS -1 >rdx.pre
            ./minipgp5 -3 -A $siga -a $hash -t 1 $USEPASS <newkey5 >rdx.two
            cat rdx.pre rdx.one rdx.two | ./minipgp5 -z | \
               ./minipgp5 -k 0 -a $alg >rdx.enc
            rm -f rdx rdx.pre rdx.one rdx.two
            pgpv rdx.enc -o rdx

            if cmp rdx newkey5 ; then echo pgp decrypt ok; else exit 0; fi
            ./minipgp5  <rdx.enc $USEPASS | ./minipgp5 | ./minipgp5  >rdy.out
            if cmp rdy.out newkey5 ; then echo our decrypt ok; else exit 0; fi
        done
    done
done
rm rdx rdy.out

echo ========== Detached Signature test

for siga in 17; do
for hash in 1 2; do
    ./minipgp5 -3 <minipgp5 >minipgp5.sig $USEPASS -a $hash -A $siga
    ./minipgp5 <minipgp5 -v minipgp5.sig
    pgpv minipgp5.sig
done
done

rm minipgp5.sig

echo ========== Conventional test
for xa in 3 1 0; do
for ya in 1 3; do
for a in 1 3; do
    echo testing conv-key only a C:$a S:$xa H:$ya SC:$za
    ./minipgp5 -x $xa -y $ya -s $a -a $a -C -p $PGPPASS <README >cvt.one
    ./minipgp5 -m "MESSAGE" <cvt.one >cvt1.asc
    ./minipgp5  -p $PGPPASS <cvt.one | diff README - | head
    pgpv cvt1.asc -o cvtv.one
    diff README cvtv.one
    rm cvtv.one cvt.one cvt1.asc
    echo testing conv only a C:$a S:$xa H:$ya
    ./minipgp5 -x $xa -y $ya -s $a -a $a -c -p $PGPPASS <README >cvt.two
    ./minipgp5 -m "MESSAGE" <cvt.two >cvt2.asc
    ./minipgp5  -p $PGPPASS <cvt.two | diff README - | head
    pgpv cvt2.asc -o cvtv.two
    diff README cvtv.two

    rm -f cvtv.two cvt.two cvt2.asc
done
done
done


echo ========== Decrypt test
#this fixes pgpe
./newkey5 -K 0 -k 0 -r pubring.pkr -u "Second Key" #-p $PGPPASS
pgpk -a pubnew.pkr

rm -f wrx.out
pgpe newkey5 -r Test -s -u Test -o wrx.out
./minipgp5  <wrx.out -p $PGPPASS | ./minipgp5 | ./minipgp5  >wry.out
if cmp wry.out newkey5; then echo our decrypt ok; else exit 0; fi
rm wry.out
