/*

    ``gpgp'' Gnome/GTK Front for PGP
    Copyright (C) 1998  Max Valianskiy

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    $Id: gpgp_unsign.c,v 1.26 1998/08/16 19:51:28 maxcom Stab $ 

*/

#include "../config.h"
#include "../version.h"

#include <gnome.h>

#include "gpgp.h"
#include "pgman.h"

enum 
  {
   GNOME_PGP_ERROR_SIGNAL,
   GNOME_PGP_CANCEL_SIGNAL,
   LAST_SIGNAL
  };

/* static void cancel_cb (GtkWidget *widget, gpointer data);*/

static void gnome_pgp_unsign_class_init          (GnomePgpUnSignClass *klass);
static void gnome_pgp_unsign_init                (GnomePgpUnSign      *ttt);

static gint gnome_pgp_unsign_signals[LAST_SIGNAL] = { 0 };

guint
gnome_pgp_unsign_get_type ()
{
  static guint gnome_pgp_unsign_type = 0;

  if (!gnome_pgp_unsign_type)
    {
      GtkTypeInfo gnome_pgp_unsign_info =
      {
        "GnomePgpUnSign",
        sizeof (GnomePgpUnSign),
        sizeof (GnomePgpUnSignClass),
        (GtkClassInitFunc) gnome_pgp_unsign_class_init,
        (GtkObjectInitFunc) gnome_pgp_unsign_init,
        (GtkArgSetFunc) NULL,
        (GtkArgGetFunc) NULL
      };

      gnome_pgp_unsign_type = gtk_type_unique (gtk_widget_get_type (), &gnome_pgp_unsign_info);
    }

  return gnome_pgp_unsign_type;
}

static void
gnome_pgp_unsign_class_init (GnomePgpUnSignClass *class)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass*) class;
  
  gnome_pgp_unsign_signals[GNOME_PGP_ERROR_SIGNAL] = gtk_signal_new ("error",
                                         GTK_RUN_FIRST,
                                         object_class->type,
                                         GTK_SIGNAL_OFFSET (GnomePgpUnSignClass,error),
                                         gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);

  gnome_pgp_unsign_signals[GNOME_PGP_CANCEL_SIGNAL] = gtk_signal_new ("cancel",
                                         GTK_RUN_FIRST,
                                         object_class->type,
                                         GTK_SIGNAL_OFFSET (GnomePgpUnSignClass,cancel),
                                         gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);
  
  gtk_object_class_add_signals (object_class, gnome_pgp_unsign_signals, LAST_SIGNAL);

  class->error = NULL;
}

static void
gnome_pgp_unsign_init (GnomePgpUnSign *page)
{
}

static void unsign_finish_cb(GnomePgpUnSign* page);

void gnome_pgp_unsign_action(GnomePgpUnSign* page)
{
  page->obuf = g_malloc(page->bufsize);
  memcpy(page->obuf, page->buf, page->bufsize);
  page->obufsize = page->bufsize;

  page->filename="filename";

  gtk_widget_hide(GTK_WIDGET(page));
  
  pgp_unsign_action(page->buf, page->bufsize, &page->obuf, &page->obufsize,(PgmanActionFunc) unsign_finish_cb, page);
}

struct ok_pack
  {
   GtkWidget* page;
   GtkWidget* box;
  };

static void okbox_ok_cb (GtkWidget *widget, struct ok_pack* data)
{
 gtk_widget_destroy(data->page);
 gtk_widget_destroy(data->box);
 g_free(data);
}

static void next_time_cb(GtkToggleButton* widget, void* data)
{
 gpgp_options.sign_verbose = widget->active;
 gnome_config_set_bool("gpgp/Options/UnSign Verbose", gpgp_options.sign_verbose);
 gnome_config_sync();
}

static
void unsign_finish_cb(GnomePgpUnSign* page)
{
 if (pgman_error)
   {
    page->error_info=pgman_error;
    gtk_signal_emit(GTK_OBJECT(page), gnome_pgp_unsign_signals[GNOME_PGP_ERROR_SIGNAL]); 
    return;
   }

 if (gpgp_options.unsign_verbose)
 {
  struct ok_pack* pack;
  GtkWidget* okbox;
  GtkWidget* check;
 
  pack = g_malloc(sizeof(struct ok_pack));
 
  okbox = gnome_message_box_new(_("Operation complete"), GNOME_MESSAGE_BOX_INFO, GNOME_STOCK_BUTTON_OK, NULL);
  pack->box  = okbox;
  pack->page = GTK_WIDGET(page);
  gtk_widget_show(okbox);
 
  gnome_dialog_button_connect (GNOME_DIALOG (okbox), 0, GTK_SIGNAL_FUNC (okbox_ok_cb), pack);
 
  check = gtk_check_button_new_with_label(_("Show next time"));
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check),TRUE);
  gtk_signal_connect(GTK_OBJECT(check),"toggled", GTK_SIGNAL_FUNC(next_time_cb),NULL);   
  gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(okbox)->vbox),check,
                              FALSE, TRUE, GNOME_PAD_SMALL);
  gtk_widget_show(check);
 }
}

/*static void cancel_cb (GtkWidget *widget, gpointer data)
{
 gtk_signal_emit(GTK_OBJECT(data), gnome_pgp_unsign_signals[GNOME_PGP_CANCEL_SIGNAL]);
 if (GNOME_PGP_UNSIGN(data)->obuf)
   g_free(GNOME_PGP_UNSIGN(data)->obuf);
 GNOME_PGP_UNSIGN(data)->obuf=NULL;
 GNOME_PGP_UNSIGN(data)->obufsize=0;
 gtk_widget_destroy(GTK_WIDGET(data));
}*/

GtkWidget*
gnome_pgp_unsign_new (char* buf, int bufsize)
{
  GnomePgpUnSign* page;

  page = gtk_type_new (gnome_pgp_unsign_get_type ());
 
  page->buf = buf;
  page->bufsize = bufsize;
 
  return GTK_WIDGET (page);
}
