#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <rand.h>
#include "libopgp.h"

FILE *inf, *outf;

extern int PGP_s2kca, PGP_s2kha, PGP_s2ksa;

#ifndef NOPIPE
#include <wait.h>
int split()
{
  int passpipe[2];

  pipe(passpipe);
  if (!(fork())) {
    inf = fdopen(passpipe[0], "rb");
    close(passpipe[1]);
    return 1;
  }
  outf = fdopen(passpipe[1], "wb");
  close(passpipe[0]);
  return 0;
}
#endif

char usagestr[] =
"General:\n"
"-i input.file  override stdin\n"
"-o output.file override stdout\n"
"-p passphrase  supply passphrase\n"
"-r ring.file   use keyring\n"
"\nLiteral:\n"
"-l file.name   literalize as file.name\n"
"\nSign:\n"
"-k keyid       Sign with keyid\n"
"-S sigalg      Sign using algorithm\n"
"-d hash        Sign using digest\n"
"-1             Generate onepass sig header, and V3 sig\n"
"-3             Generate V3 Signature (detached)\n"
"-4             Generate V4 Signature (detached)\n"
"-5             Generate onepass sig header and V4 Sig\n"
"-t sigtype     Signature type, 0 is binary, 1 is text, etc.\n"
"\nCompress:\n"
"-z, -2         Compress (-2 is for pgp2 compatibility)\n"
"\nEncrypt:\n"
"-e keyid       PKEncrypt to keyid\n"
"-C             Symmetrical Encryption using encrypted session key\n"
"-c             Symmetrical Encryption using only passphrase\n"
"-s alg         Encrypt from passphrase using conventional alg\n"
"-x alg         Encrypt from passphrase using salt alg\n"
"-y alg         Encrypt from passphrase using hash alg\n"
"-A pkealg      PKEncrypt using alg\n"
"-a symalg      encrypt using symmetric alg\n"
"\nArmor:\n"
"-m MESSAGE     Armor (MESSAGE appears as type)\n"
"\nOther:\n"
"-v sig.file    Verify stdin v.s. this detached signature\n"
"-O             Convert new to old CTB format\n"
#ifndef NOPIPE
"\nOtherwise extract until a literal is unpacked or text is found\n"
"or use -I to extract only a single step\n"
"Literal, Sign, Compress, Encrypt, and Armor can be combined.\n"
#else
"\nOtherwise extract one step (dearmor, decrypt, decompr, delit)\n"
#endif
 ;

#ifndef NOPIPE
#define WAITRET(x) {fclose(outf); if( !spl ) wait(&spl); return (x);}
#else
#define WAITRET(x) { if(!stepf) { fclose(inf); fflush(outf); \
 fseek(outf,0,SEEK_SET); inf = outf; outf = tmpfile(); } }
#endif

#define optset(let,var,val) else if (i == (let)) var = (val)
#define optfile(let,fp,mode) else if (i == (let) && \
      (NULL != ((fp) = fopen(optarg, mode))))

/*------------*/
int main(int argc, char *argv[])
{
  char keybuf[256], *pp = NULL;
  unsigned char dbuf[4200], *bp;
  char fname[256] = "", *litn = NULL;
  int i, j, k, ll;
  int zipf = 0, syma = 1, encf = 0, convf = 0, signf = 0, styp = 0, halg = 2;
  int armorf = 0, spl = 1, stepf = 0, cctbf = 0;
  keyid_t keyid[16], keyid2 = 0;
  FILE *sigfile = NULL, *ofsav;
  void *hctx;

  inf = stdin, outf = stdout;

  memset(keybuf, 0, 256);
  while ((i = getopt(argc, argv,
                     "i:o:e:k:p:r:a:d:A:S:IOl:cCs:y:x:z2v:1345t:m:")) != -1) {
    if (i == 'k')
      sscanf(optarg, "%qx", &keyid2);
    else if (i == 'e')
      sscanf(optarg, "%qx", &keyid[encf++]);
    else if (i == 'l')
      strcpy(fname, optarg), litn = fname;
    else if (i == 'p')          /* password */
      strcpy(keybuf, optarg), pp = keybuf;
    else if (i == 'm')
      armorf++, strcpy(dbuf, optarg);
    else if (i == 'r')
      PGP_kring(optarg);
    optfile('v', sigfile, "rb");
    optfile('i', inf, "rb");
    optfile('o', outf, "wb");
    optset('a', syma, atoi(optarg));
    optset('d', halg, atoi(optarg));
    optset('c', convf, -1);
    optset('C', convf, 1);
    optset('I', stepf, 1);
    optset('O', cctbf, 1);
    optset('z', zipf, 1);
    optset('2', zipf, 2);
    optset('s', PGP_s2kca, atoi(optarg));
    optset('y', PGP_s2kha, atoi(optarg));
    optset('x', PGP_s2ksa, atoi(optarg));
    optset('t', styp, atoi(optarg));
    optset('1', signf, 1);
    optset('3', signf, 3);
    optset('4', signf, 4);
    optset('5', signf, 5);
    else {                      /* indent will give an error */
      fprintf(stderr, "%c not recognized\n%s", i, usagestr);
      exit(-1);
    }
  }
  if (cctbf) {
    PGP_xctb(inf, outf);
    return 0;
  }
  /* ========================= */
  /* check detached sig */
  if (sigfile) {
    bp = PGP_gtpkt(sigfile, fgetc(sigfile), NULL);
    halg = *bp == 3 ? bp[16] : bp[3];  /* grab algorithm */
    fclose(sigfile);
    hctx = PGP_hini(halg);
    while (!feof(inf) && 0 < (k = fread(dbuf, 1, 4096, inf)))
      PGP_hblk(hctx, dbuf, k);
    i = PGP_sigck(bp, hctx);
    free(bp);
    fprintf(stderr, "%s\n", i ? "BAD SIGNATURE" : "good signature");
    return i;
  }
  ofsav = outf;
#ifndef NOPIPE
  if ((signf || litn) && (zipf || encf || convf || armorf) && (spl = split()))
    signf = 0, litn = NULL;
  if (!(signf || litn) && zipf && (encf || convf || armorf) && (spl = split()))
    zipf = 0;
  if (!(signf || litn || zipf) && (encf || convf) && armorf && (spl = split()))
    encf = 0, convf = 0;
#else
  outf = tmpfile();
#endif
  if (signf || litn) {
    i = PGP_elsgm(inf, outf, litn, signf, styp, halg, keyid2, pp);
    WAITRET(i);
  }
  if (zipf) {
    i = PGP_zip(inf, outf, zipf - 1);
    WAITRET(i);
  }
  if (encf || convf) {
    PGP_encry(inf, outf, encf, convf, keyid, syma, &pp);
    WAITRET(0);
  }
  if (armorf) {
    i = PGP_armor(inf, outf, dbuf, NULL);
    WAITRET(i);
  }
  /* ========================= */
  if (!(signf || litn || zipf || encf || convf || armorf))
    for (;;) {
      ll = fgetc(inf);
      ungetc(ll, inf);
      if (ll < 0x80) {
        if (armorf)
          break;
#ifndef NOPIPE
        if (!stepf && (spl = split()))
          continue;
#endif
        PGP_dearmor(inf, outf);
        WAITRET(0);
        if (stepf)
          break;
        continue;
      }
      armorf++;
      if (ll < 0xc0)
        ll = 0xc0 + ((ll & 0x3c) >> 2);
      ll -= 0xc0;
#ifndef NOPIPE
      if ((ll == 1 || ll == 3 || ll == 8 || ll == 9 || ll == 10)
          && !stepf && (spl = split()))
        continue;
#endif
      if (ll == 1 || ll == 3 || ll == 10) {  /* incl 0xa8,3,PGP */
        PGP_decry(inf, outf, pp);
        WAITRET(0);
      } else if (ll == 8) {
        PGP_unzip(inf, outf);
        WAITRET(0);
      } else if (ll == 9) {     /* naked symmetrical */
        unsigned char xfix[] =
        {4, 1, 0, 1};

        bp = xfix;
        PGP_gts2k(&bp, pp, &hctx);
        PGP_cdec(inf, outf, &hctx, 1);
        WAITRET(0);
      } else if (ll == 2 || ll == 4 || ll == 11) {
        i = PGP_delcs(inf, outf, &j, NULL);
        if (j)
          fprintf(stderr, i ? "FAILED SIGNATURE CHECK\n" : "good signature\n");
        stepf = 1;
      }
      if (stepf)
        break;
    }
#ifdef NOPIPE
  else {
    fclose(outf);
    outf = inf;
  }
  fseek(outf, 0, SEEK_SET);
  while (!feof(outf))
    fwrite(dbuf, 1, fread(dbuf, 1, 4096, outf), ofsav);
#endif
  return 0;
}
